/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.teiid.designer.core.refactor.RefactorCommand;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;

public class RefactorCommandProcessorDialog
extends SelectionDialog
implements PluginConstants {
    private final String TITLE = UiConstants.Util.getString("RefactorCommandProcessorDialog.problemDialog.title", new Object[0]);
    private static final String HEADER_ERROR_MESSAGE = UiConstants.Util.getString("RefactorCommandProcessorDialog.headerErrorMessage.text", new Object[0]);
    private static final String HEADER_WARNING_MESSAGE = UiConstants.Util.getString("RefactorCommandProcessorDialog.headerWarningMessage.text", new Object[0]);
    private static final int WIDTH = 600;
    private static final int HEIGHT = 150;
    private RefactorCommand command;
    private ProblemTablePanel pnlProblemTable;
    TableColumn column1;
    TableColumn column2;

    public RefactorCommandProcessorDialog(Shell parent, RefactorCommand command) {
        super(parent);
        this.command = command;
        this.init();
    }

    private void init() {
        this.setTitle(this.TITLE);
        if (this.problemSetContainsErrors()) {
            this.setMessage(HEADER_ERROR_MESSAGE);
        } else {
            this.setMessage(HEADER_WARNING_MESSAGE);
        }
    }

    private boolean problemSetContainsErrors() {
        boolean bHasError = false;
        Collection colMessages = this.command.getPostExecuteMessages();
        if (colMessages != null && !colMessages.isEmpty()) {
            for (IStatus stTemp : colMessages) {
                if (stTemp.getSeverity() < 4) continue;
                bHasError = true;
                break;
            }
        }
        return bHasError;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gd = new GridData(1808);
        gd.widthHint = 600;
        gd.heightHint = 150;
        parent.setLayoutData((Object)gd);
        this.createMessageArea(parent);
        this.pnlProblemTable = new ProblemTablePanel(parent, this.command);
        GridData gd2 = new GridData(1808);
        gd2.widthHint = 570;
        gd2.heightHint = 100;
        this.pnlProblemTable.setLayoutData(gd2);
        return parent;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    class ProblemTableContentProvider
    implements IStructuredContentProvider {
        RefactorCommand mrcCommand;

        public ProblemTableContentProvider(RefactorCommand mrcCommand) {
            this.mrcCommand = mrcCommand;
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            Object[] result = null;
            Collection colMessages = new ArrayList();
            if (this.mrcCommand != null) {
                colMessages = this.mrcCommand.getPostExecuteMessages();
            }
            if (colMessages != null && !colMessages.isEmpty()) {
                int numRows = colMessages.size();
                result = new Object[numRows];
                Iterator it = colMessages.iterator();
                int i = 0;
                while (i < numRows) {
                    Object oObject = it.next();
                    result[i] = new ProblemTableRow(oObject);
                    ++i;
                }
            }
            return colMessages == null || colMessages.isEmpty() ? new Object[]{} : result;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
            this.mrcCommand = (RefactorCommand)theNewInput;
            if (theNewInput != null) {
                theViewer.refresh();
            }
        }
    }

    class ProblemTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ProblemTableLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int iColumnIndex) {
            Object oRealObject = ((ProblemTableRow)theElement).getObject();
            Image imgResult = null;
            if (oRealObject instanceof IStatus) {
                IStatus status = (IStatus)oRealObject;
                switch (iColumnIndex) {
                    case 0: {
                        if (status.getSeverity() == 4) {
                            imgResult = UiPlugin.getDefault().getImage("icons/full/obj16/error_obj.gif");
                            break;
                        }
                        if (status.getSeverity() != 2) break;
                        imgResult = UiPlugin.getDefault().getImage("icons/full/obj16/warning_obj.gif");
                        break;
                    }
                }
            }
            return imgResult;
        }

        public String getColumnText(Object theElement, int iColumnIndex) {
            ProblemTableRow row = (ProblemTableRow)theElement;
            return row.getColumnText(iColumnIndex);
        }
    }

    class ProblemTablePanel
    extends Composite
    implements SelectionListener {
        private RefactorCommand mrcCommand;
        private final String FOUND_PROBLEMS_HEADING;
        private Composite pnlTableStuff;
        private Table tblProblemTable;
        private String[] columnNames;
        private TableViewer tvRoleTableViewer;
        private ProblemTableContentProvider cpProblemContentProvider;
        private ProblemTableLabelProvider lpProblemLabelProvider;

        public ProblemTablePanel(Composite parent, RefactorCommand mrcCommand) {
            super(parent, 0);
            this.FOUND_PROBLEMS_HEADING = UiConstants.Util.getString("RefactorCommandProcessorDialog.foundProblems.title", new Object[0]);
            this.columnNames = new String[]{this.FOUND_PROBLEMS_HEADING, ""};
            this.mrcCommand = mrcCommand;
            this.createControl(this);
        }

        public void setVisible(boolean b) {
            RefactorCommandProcessorDialog.this.column1.pack();
            RefactorCommandProcessorDialog.this.column2.pack();
            super.setVisible(b);
        }

        public void createControl(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            this.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(1808);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.setLayoutData(gridData);
            this.createTableStuffPanel(parent);
        }

        private void createTableStuffPanel(Composite parent) {
            this.pnlTableStuff = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.pnlTableStuff.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(1808);
            this.pnlTableStuff.setLayoutData((Object)gridData);
            this.createTableViewerPanel(this.pnlTableStuff);
        }

        private void createTableViewerPanel(Composite parent) {
            this.createTable(parent);
            this.createTableViewer();
            this.cpProblemContentProvider = new ProblemTableContentProvider(this.mrcCommand);
            this.lpProblemLabelProvider = new ProblemTableLabelProvider();
            this.tvRoleTableViewer.setContentProvider((IContentProvider)this.cpProblemContentProvider);
            this.tvRoleTableViewer.setLabelProvider((IBaseLabelProvider)this.lpProblemLabelProvider);
            if (this.mrcCommand != null) {
                this.tvRoleTableViewer.setInput((Object)this.mrcCommand);
            }
        }

        private void createTable(Composite parent) {
            int style = 68356;
            this.tblProblemTable = new Table(parent, style);
            TableLayout layout = new TableLayout();
            this.tblProblemTable.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.tblProblemTable.setLayoutData((Object)gridData);
            this.tblProblemTable.setLinesVisible(true);
            this.tblProblemTable.setHeaderVisible(true);
            RefactorCommandProcessorDialog.this.column1 = new TableColumn(this.tblProblemTable, 16384);
            RefactorCommandProcessorDialog.this.column1.setText(this.columnNames[1]);
            RefactorCommandProcessorDialog.this.column1.setResizable(false);
            RefactorCommandProcessorDialog.this.column1.setImage(UiPlugin.getDefault().getImage("icons/full/cview16/errorwarning_tab.gif"));
            RefactorCommandProcessorDialog.this.column1.setText("");
            RefactorCommandProcessorDialog.this.column1.pack();
            ColumnWeightData weight = new ColumnWeightData(1);
            layout.addColumnData((ColumnLayoutData)weight);
            RefactorCommandProcessorDialog.this.column2 = new TableColumn(this.tblProblemTable, 16384);
            RefactorCommandProcessorDialog.this.column2.setText(this.columnNames[0]);
            RefactorCommandProcessorDialog.this.column2.pack();
            ColumnWeightData weight2 = new ColumnWeightData(12, 50, true);
            layout.addColumnData((ColumnLayoutData)weight2);
        }

        private void createTableViewer() {
            this.tvRoleTableViewer = new TableViewer(this.tblProblemTable);
            this.tvRoleTableViewer.setUseHashlookup(true);
            this.tvRoleTableViewer.setColumnProperties(this.columnNames);
            CellEditor[] editors = new CellEditor[this.columnNames.length];
            editors[0] = null;
            editors[1] = null;
            this.tvRoleTableViewer.setCellEditors(editors);
        }

        public void widgetSelected(SelectionEvent e) {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class ProblemTableRow {
        private Object oObject;

        public ProblemTableRow(Object oObject) {
            this.oObject = oObject;
        }

        public Object getObject() {
            return this.oObject;
        }

        public String getColumnText(int iColumnIndex) {
            String sResult = "";
            if (this.oObject instanceof IStatus) {
                IStatus status = (IStatus)this.oObject;
                switch (iColumnIndex) {
                    case 0: {
                        sResult = "";
                        break;
                    }
                    case 1: {
                        sResult = status.getMessage();
                    }
                }
            } else {
                switch (iColumnIndex) {
                    case 0: {
                        sResult = this.oObject.toString();
                        break;
                    }
                    case 1: {
                        sResult = this.oObject.toString();
                    }
                }
            }
            return sResult;
        }

        public Object getValue(int theIndex) {
            Object oResult = null;
            return oResult;
        }
    }
}

