/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class SaveModifiedResourcesDialog
extends SelectionDialog {
    private static final String TITLE = UiConstants.Util.getString("SaveModifiedResourcesDialog.dialogTitle.text", new Object[0]);
    private static final String HEADER_MESSAGE = UiConstants.Util.getString("SaveModifiedResourcesDialog.headerMessage.text", new Object[0]);
    private static final String SAVE_ERROR_TITLE = UiConstants.Util.getString("SaveModifiedResourcesDialog.saveError.title", new Object[0]);
    private static final String SAVE_ERROR_MESSAGE = UiConstants.Util.getString("SaveModifiedResourcesDialog.saveError.message", new Object[0]);
    private Collection resourcesToIgnore;
    private Collection colResourcesToDisplay;
    protected IBaseLabelProvider labelProvider;
    protected IContentProvider contentProvider;
    private SaveModifiedResourcesTablePanel pnlSaveModifiedResourcesTable;

    public SaveModifiedResourcesDialog(Shell parent) {
        super(parent);
        this.setTitle(TITLE);
        this.setMessage(HEADER_MESSAGE);
    }

    public SaveModifiedResourcesDialog(Shell parent, Collection resourcesToIgnore) {
        super(parent);
        this.resourcesToIgnore = resourcesToIgnore;
        this.setTitle(TITLE);
        this.setMessage(HEADER_MESSAGE);
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 400;
        parent.setLayoutData((Object)gd);
        this.createMessageArea(parent);
        this.pnlSaveModifiedResourcesTable = new SaveModifiedResourcesTablePanel(parent);
        this.pnlSaveModifiedResourcesTable.refresh();
        return parent;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
    }

    protected void okPressed() {
        Iterator it = this.getResourcesToDisplay().iterator();
        ArrayList<IResource> arylUnsavedFiles = new ArrayList<IResource>();
        while (it.hasNext()) {
            boolean bDone;
            IResource resTemp = (IResource)it.next();
            if (!(resTemp instanceof IFile) || (bDone = ModelEditorManager.save((IFile)resTemp))) continue;
            arylUnsavedFiles.add(resTemp);
        }
        if (!arylUnsavedFiles.isEmpty()) {
            String sList = arylUnsavedFiles.toString();
            MessageDialog.openError((Shell)this.getParentShell(), (String)SAVE_ERROR_TITLE, (String)(String.valueOf(SAVE_ERROR_MESSAGE) + sList));
        }
        super.okPressed();
    }

    public Collection getResourcesToDisplay() {
        if (this.colResourcesToDisplay == null) {
            Collection colDirtyFiles = ModelEditorManager.getDirtyResources();
            this.colResourcesToDisplay = new ArrayList();
            if (this.resourcesToIgnore != null && !this.resourcesToIgnore.isEmpty() && colDirtyFiles != null && !colDirtyFiles.isEmpty()) {
                Iterator itDirty = colDirtyFiles.iterator();
                Object[] ignores = this.resourcesToIgnore.toArray();
                while (itDirty.hasNext()) {
                    IFile dirtyFile = (IFile)itDirty.next();
                    if (dirtyFile.getType() != 1) continue;
                    int i = 0;
                    while (i < ignores.length) {
                        ModelResource mrIgnore = (ModelResource)ignores[i];
                        ModelResource mrDirtyFile = ModelUtilities.getModelResourceForIFile(dirtyFile, false);
                        if (mrDirtyFile == mrIgnore) {
                            itDirty.remove();
                        }
                        ++i;
                    }
                }
            }
            this.colResourcesToDisplay = colDirtyFiles;
        }
        return this.colResourcesToDisplay;
    }

    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void setContentProvider(IContentProvider theContentProvider) {
        this.contentProvider = theContentProvider;
    }

    protected IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected void setLabelProvider(IBaseLabelProvider theLabelProvider) {
        this.labelProvider = theLabelProvider;
    }

    protected class SaveModifiedResourcesTableContentProvider
    implements IStructuredContentProvider {
        protected SaveModifiedResourcesTableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            Object[] result = null;
            Collection colDirtyFiles = SaveModifiedResourcesDialog.this.getResourcesToDisplay();
            if (colDirtyFiles != null && !colDirtyFiles.isEmpty()) {
                int numRows = colDirtyFiles.size();
                result = new Object[numRows];
                Iterator it = colDirtyFiles.iterator();
                int i = 0;
                while (i < numRows) {
                    Object oObject = it.next();
                    result[i] = new SaveModifiedResourcesTableRow(oObject);
                    ++i;
                }
            }
            return colDirtyFiles == null || colDirtyFiles.isEmpty() ? new Object[]{} : result;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
            if (theNewInput != null) {
                theViewer.refresh();
            }
        }
    }

    protected class SaveModifiedResourcesTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected SaveModifiedResourcesTableLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int iColumnIndex) {
            return null;
        }

        public String getColumnText(Object theElement, int iColumnIndex) {
            SaveModifiedResourcesTableRow row = (SaveModifiedResourcesTableRow)theElement;
            return row.getColumnText(iColumnIndex);
        }
    }

    class SaveModifiedResourcesTablePanel
    extends Composite {
        private Composite pnlTableStuff;
        private Table tblSaveModifiedResourcesTable;
        private String[] columnNames;
        private TableViewer tvSaveModifiedTableViewer;

        public SaveModifiedResourcesTablePanel(Composite parent) {
            super(parent, 0);
            this.columnNames = new String[]{""};
            this.createControl(this);
        }

        public void refresh() {
            this.tvSaveModifiedTableViewer.refresh();
        }

        public void createControl(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            this.setLayout((Layout)gridLayout);
            gridLayout.numColumns = 1;
            GridData gridData = new GridData(1808);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.setLayoutData(gridData);
            this.createTableStuffPanel(parent);
        }

        private void createTableStuffPanel(Composite parent) {
            this.pnlTableStuff = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.pnlTableStuff.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(1808);
            this.pnlTableStuff.setLayoutData((Object)gridData);
            this.createTableViewerPanel(this.pnlTableStuff);
        }

        private void createTableViewerPanel(Composite parent) {
            this.createTable(parent);
            this.createTableViewer();
            if (SaveModifiedResourcesDialog.this.getContentProvider() == null) {
                SaveModifiedResourcesDialog.this.setContentProvider((IContentProvider)new SaveModifiedResourcesTableContentProvider());
            }
            if (SaveModifiedResourcesDialog.this.getLabelProvider() == null) {
                SaveModifiedResourcesDialog.this.setLabelProvider((IBaseLabelProvider)new SaveModifiedResourcesTableLabelProvider());
            }
            this.tvSaveModifiedTableViewer.setContentProvider(SaveModifiedResourcesDialog.this.getContentProvider());
            this.tvSaveModifiedTableViewer.setLabelProvider(SaveModifiedResourcesDialog.this.getLabelProvider());
            this.tvSaveModifiedTableViewer.setInput(new Object());
        }

        private void createTable(Composite parent) {
            int style = 68356;
            this.tblSaveModifiedResourcesTable = new Table(parent, style);
            TableLayout layout = new TableLayout();
            this.tblSaveModifiedResourcesTable.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.tblSaveModifiedResourcesTable.setLayoutData((Object)gridData);
            this.tblSaveModifiedResourcesTable.setLinesVisible(true);
            this.tblSaveModifiedResourcesTable.setHeaderVisible(true);
            TableColumn column1 = new TableColumn(this.tblSaveModifiedResourcesTable, 16384, 0);
            column1.setText(this.columnNames[0]);
            ColumnWeightData weight = new ColumnWeightData(1);
            layout.addColumnData((ColumnLayoutData)weight);
        }

        private void createTableViewer() {
            this.tvSaveModifiedTableViewer = new TableViewer(this.tblSaveModifiedResourcesTable);
            this.tvSaveModifiedTableViewer.setUseHashlookup(true);
            this.tvSaveModifiedTableViewer.setColumnProperties(this.columnNames);
            CellEditor[] editors = new CellEditor[this.columnNames.length];
            editors[0] = null;
            this.tvSaveModifiedTableViewer.setCellEditors(editors);
        }
    }

    class SaveModifiedResourcesTableRow {
        private Object oObject;

        public SaveModifiedResourcesTableRow(Object oObject) {
            this.oObject = oObject;
        }

        public Object getObject() {
            return this.oObject;
        }

        public String getColumnText(int iColumnIndex) {
            String sResult = "<unknown>";
            if (this.oObject instanceof IResource) {
                IResource resource = (IResource)this.oObject;
                switch (iColumnIndex) {
                    case 0: {
                        sResult = resource.getFullPath().makeRelative().toString();
                    }
                }
            }
            return sResult;
        }

        public Object getValue(int theIndex) {
            Object oResult = null;
            return oResult;
        }
    }
}

