/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.delete;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.teiid.designer.core.refactor.IRefactorModelHandler;
import org.teiid.designer.core.refactor.RelatedResourceFinder;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.refactor.AbstractResourcesRefactoring;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.delete.DeleteResourcesCompositeChange;
import org.teiid.designer.ui.refactor.delete.DeleteResourcesDescriptor;

public class DeleteResourcesRefactoring
extends AbstractResourcesRefactoring {
    private boolean deleteContents;

    public DeleteResourcesRefactoring(List<IResource> selectedResources) {
        super(RefactorResourcesUtils.getString("DeleteRefactoring.title", new Object[0]), selectedResources);
    }

    public boolean isDeleteContents() {
        return this.deleteContents;
    }

    public void setDeleteContents(boolean deleteContents) {
        this.deleteContents = deleteContents;
    }

    private void checkProjectReadOnly(IProject project, RefactoringStatus status) {
        if (this.isDeleteContents() && ModelUtil.isIResourceReadOnly((IResource)project)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyResourceError", project.getName())));
        }
    }

    private boolean isSelectedOrChildResource(final IResource child) {
        if (this.getResources().contains(child)) {
            return true;
        }
        final boolean[] status = new boolean[1];
        IResourceVisitor childVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (resource.equals((Object)child)) {
                    status[0] = true;
                    return false;
                }
                return true;
            }
        };
        for (IResource selected : this.getResources()) {
            try {
                selected.accept(childVisitor);
                if (!status[0]) continue;
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    @Override
    protected void checkResource(IResource resource, IProgressMonitor progressMonitor, RefactoringStatus status) {
        String readOnlyStatusMsg;
        int readOnlyStatusLevel;
        if (this.isSelectedOrChildResource(resource)) {
            readOnlyStatusLevel = 2;
            readOnlyStatusMsg = RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyResourceError", resource.getName());
        } else {
            readOnlyStatusLevel = 4;
            readOnlyStatusMsg = RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyRelatedResourceError", resource.getName());
        }
        RefactorResourcesUtils.checkResourceExists(resource, status);
        if (status.getSeverity() > 2) {
            return;
        }
        RefactorResourcesUtils.checkResourceSynched(resource, status);
        if (status.getSeverity() > 2) {
            return;
        }
        if (resource instanceof IProject) {
            this.checkProjectReadOnly((IProject)resource, status);
        } else {
            RefactorResourcesUtils.checkResourceWritable(resource, status, readOnlyStatusLevel, readOnlyStatusMsg);
        }
        if (status.getSeverity() > 2) {
            return;
        }
        RefactorResourcesUtils.checkExtensionManager(resource, IRefactorModelHandler.RefactorType.DELETE, progressMonitor, status);
        if (status.getSeverity() > 2) {
            return;
        }
        RefactorResourcesUtils.checkSavedResource(resource, status);
        if (status.getSeverity() > 2) {
            return;
        }
        if (!this.getResources().contains(resource)) {
            RefactorResourcesUtils.checkOpenEditors(resource, status);
        }
    }

    public RefactoringStatus checkInitialConditions(final IProgressMonitor progressMonitor) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            progressMonitor.beginTask(RefactorResourcesUtils.getString("DeleteRefactoring.initialConditions", new Object[0]), 1);
            if (!this.checkResourcesNotEmpty(status)) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (!RefactorResourcesUtils.containsOnlyProjects(this.getResources()) && !RefactorResourcesUtils.containsOnlyNonProjects(this.getResources())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("DeleteRefactoring.containsProjectsAndResourcesError", new Object[0]));
                return refactoringStatus;
            }
            for (IResource resource : this.getResources()) {
                this.checkResource(resource, progressMonitor, status);
                if (status.getSeverity() > 2) {
                    break;
                }
                RefactorResourcesUtils.AbstractResourceCallback callback = new RefactorResourcesUtils.AbstractResourceCallback(){

                    @Override
                    public void checkValidFile(IFile relatedFile, RefactoringStatus validityStatus) {
                        DeleteResourcesRefactoring.this.checkResource((IResource)relatedFile, progressMonitor, validityStatus);
                    }
                };
                RefactorResourcesUtils.calculateRelatedResources(resource, status, callback, RelatedResourceFinder.Relationship.DEPENDENT);
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor progressMonitor) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.clearChanges();
        try {
            progressMonitor.beginTask(RefactorResourcesUtils.getString("DeleteRefactoring.finalConditions", new Object[0]), 2);
            RelatedResourceCallback callback = new RelatedResourceCallback();
            for (IResource resource : this.getResources()) {
                this.addChange(resource, (Change)new DeleteResourceChange(resource.getFullPath(), true, this.isDeleteContents()));
                RefactorResourcesUtils.calculateRelatedResources(resource, status, callback, RelatedResourceFinder.Relationship.DEPENDENT);
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    public Change createChange(IProgressMonitor progressMonitor) throws OperationCanceledException, CoreException {
        try {
            DeleteResourcesCompositeChange change;
            progressMonitor.beginTask(RefactorResourcesUtils.getString("DeleteRefactoring.creatingChange", new Object[0]), 1);
            DeleteResourcesCompositeChange deleteResourcesCompositeChange = change = new DeleteResourcesCompositeChange(this.getName(), this.getChanges().toArray(new Change[0]), this.isDeleteContents(), this.getResources());
            return deleteResourcesCompositeChange;
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, DeleteResourcesDescriptor.REFACTORING_ID, ex.getMessage()));
        }
        finally {
            progressMonitor.done();
        }
    }

    private class RelatedResourceCallback
    extends AbstractResourcesRefactoring.VdbResourceCallback {
        private final Set<IResource> indexedResources = new HashSet<IResource>();

        private RelatedResourceCallback() {
        }

        @Override
        public void indexFile(IResource resource, IFile relatedFile, RefactoringStatus status) throws Exception {
            if (this.indexedResources.contains(relatedFile)) {
                return;
            }
            this.indexedResources.add((IResource)relatedFile);
            RefactorResourcesUtils.unloadModelResource((IResource)relatedFile);
            if (!DeleteResourcesRefactoring.this.getResourcesAndChildren(status).contains(relatedFile)) {
                DeleteResourceChange change = new DeleteResourceChange(relatedFile.getFullPath(), true, DeleteResourcesRefactoring.this.isDeleteContents());
                DeleteResourcesRefactoring.this.addChange((IResource)relatedFile, (Change)change);
            }
            RefactorResourcesUtils.calculateRelatedVdbResources((IResource)relatedFile, status, this);
        }

        @Override
        public void indexVdb(IResource resource, IFile vdbFile, RefactoringStatus status) {
            if (!DeleteResourcesRefactoring.this.getResourcesAndChildren(status).contains(vdbFile)) {
                super.indexVdb(resource, vdbFile, status);
            }
        }
    }
}

