/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.delete;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.refactor.RelatedResourceFinder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.refactor.AbstractResourcesRefactoring;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.delete.DeleteResourcesRefactoring;

public class DeleteResourcesWizard
extends RefactoringWizard {
    public DeleteResourcesWizard(DeleteResourcesRefactoring refactoring, String pageTitle) {
        super((Refactoring)refactoring, 36);
        this.setDefaultPageTitle(pageTitle);
    }

    protected void addUserInputPages() {
        List<IResource> resources = ((AbstractResourcesRefactoring)this.getRefactoring()).getResources();
        this.addPage((IWizardPage)new DeleteResourcesConfigurationPage(resources));
    }

    private static class DeleteResourcesConfigurationPage
    extends UserInputWizardPage {
        private Button deleteContentsButton;

        public DeleteResourcesConfigurationPage(List<IResource> resources) {
            super(RefactorResourcesUtils.getString("DeleteRefactoring.DeleteResourcesConfigurationPage", new Object[0]));
            CoreArgCheck.isNotEmpty(resources, (String)"");
        }

        public DeleteResourcesRefactoring getRefactoring() {
            return (DeleteResourcesRefactoring)super.getRefactoring();
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Point defaultSpacing = LayoutConstants.getSpacing();
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.horizontalSpacing = defaultSpacing.x * 2;
            gridLayout.verticalSpacing = defaultSpacing.y;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Image image = parent.getDisplay().getSystemImage(4);
            Label imageLabel = new Label(composite, 0);
            imageLabel.setBackground(image.getBackground());
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
            List<IResource> resources = this.getRefactoring().getResources();
            Label label = new Label(composite, 64);
            label.setFont(composite.getFont());
            boolean onlyProjects = RefactorResourcesUtils.containsOnlyProjects(resources);
            if (onlyProjects) {
                if (resources.size() == 1) {
                    label.setText(RefactorResourcesUtils.getString("DeleteRefactoring.labelSingleProject", resources.get(0).getName()));
                } else {
                    label.setText(RefactorResourcesUtils.getString("DeleteRefactoring.labelMultiProjects", new Integer(resources.size())));
                }
            } else if (RefactorResourcesUtils.containsLinkedResource(resources)) {
                if (resources.size() == 1) {
                    label.setText(RefactorResourcesUtils.getString("DeleteRefactoring.labelSingleLinked", resources.get(0).getName()));
                } else {
                    label.setText(RefactorResourcesUtils.getString("DeleteRefactoring.labelMultiLinked", new Integer(resources.size())));
                }
            } else if (resources.size() == 1) {
                label.setText(RefactorResourcesUtils.getString("DeleteRefactoring.labelSingle", resources.get(0).getName()));
            } else {
                label.setText(RefactorResourcesUtils.getString("DeleteRefactoring.labelMulti", new Integer(resources.size())));
            }
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gridData);
            Composite supportArea = new Composite(composite, 0);
            supportArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            gridLayout = new GridLayout(1, false);
            gridLayout.horizontalSpacing = defaultSpacing.x * 2;
            gridLayout.verticalSpacing = defaultSpacing.y;
            supportArea.setLayout((Layout)gridLayout);
            if (onlyProjects) {
                this.createProjectInfoArea(supportArea, resources);
            } else {
                this.createResourceInfoArea(supportArea, resources);
            }
            this.setControl((Control)composite);
        }

        private void createProjectInfoArea(Composite parent, List<IResource> resources) {
            this.deleteContentsButton = new Button(parent, 32);
            this.deleteContentsButton.setFont(parent.getFont());
            this.deleteContentsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.deleteContentsButton.setText(RefactorResourcesUtils.getString("DeleteRefactoring.projectDeleteContents", new Object[0]));
            this.deleteContentsButton.setFocus();
            this.deleteContentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.getRefactoring().setDeleteContents(deleteContentsButton.getSelection());
                }
            });
            Label projectLocationsLabel = new Label(parent, 0);
            GridData labelData = new GridData(4, 4, true, false);
            labelData.verticalIndent = 5;
            projectLocationsLabel.setLayoutData((Object)labelData);
            projectLocationsLabel.setText(resources.size() == 1 ? RefactorResourcesUtils.getString("DeleteRefactoring.projectLocation", new Object[0]) : RefactorResourcesUtils.getString("DeleteRefactoring.projectLocations", new Object[0]));
            int style = 586;
            if (resources.size() != 1) {
                style |= 0x800;
            }
            StyledText projectLocationsList = new StyledText(parent, style);
            projectLocationsList.setAlwaysShowScrollBars(false);
            labelData.horizontalIndent = projectLocationsList.getLeftMargin();
            GridData gridData = new GridData(4, 4, true, true);
            projectLocationsList.setLayoutData((Object)gridData);
            projectLocationsList.setBackground(projectLocationsList.getDisplay().getSystemColor(22));
            StringBuffer buf = new StringBuffer();
            for (IResource resource : resources) {
                String location = resource.getFullPath().toOSString();
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(location);
            }
            projectLocationsList.setText(buf.toString());
            gridData.heightHint = Math.min(this.convertHeightInCharsToPixels(5), projectLocationsList.computeSize((int)-1, (int)-1).y);
        }

        private void createResourceInfoArea(Composite parent, List<IResource> resources) {
            Group group = WidgetFactory.createGroup((Composite)parent, (String)RefactorResourcesUtils.getString("DeleteRefactoring.deleteResourceLabel", new Object[0]), (int)1808);
            TreeViewer viewer = new TreeViewer((Composite)group, 2820);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
            viewer.setContentProvider((IContentProvider)new ResourcesContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new ModelExplorerLabelProvider());
            viewer.setAutoExpandLevel(5);
            viewer.setInput(resources);
            Label detailLabel = new Label(parent, 0);
            detailLabel.setText(RefactorResourcesUtils.getString("DeleteRefactoring.previewOrOKLabel", new Object[0]));
        }
    }

    private static class IndexResourceCallback
    extends RefactorResourcesUtils.AbstractResourceCallback {
        private Set<IResource> resources = new HashSet<IResource>();

        private IndexResourceCallback() {
        }

        public Set<IResource> getResources() {
            return this.resources;
        }

        @Override
        public void indexFile(IResource resource, IFile relatedFile, RefactoringStatus status) throws Exception {
            this.resources.add((IResource)relatedFile);
            RefactorResourcesUtils.calculateRelatedVdbResources((IResource)relatedFile, status, this);
        }

        @Override
        public void indexVdb(IResource resource, IFile vdbFile, RefactoringStatus status) {
            this.resources.add((IResource)vdbFile);
        }
    }

    private static class ResourcesContentProvider
    implements ITreeContentProvider {
        private Set<IResource> rootCollection = new HashSet<IResource>();

        private ResourcesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == null) {
                return new Object[0];
            }
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            if (this.rootCollection.contains(parentElement)) {
                RefactoringStatus status = new RefactoringStatus();
                IndexResourceCallback callback = new IndexResourceCallback();
                RefactorResourcesUtils.calculateRelatedResources((IResource)parentElement, status, callback, RelatedResourceFinder.Relationship.DEPENDENT);
                RefactorResourcesUtils.calculateRelatedVdbResources((IResource)parentElement, status, callback);
                return callback.getResources().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IContainer) {
                return true;
            }
            return this.rootCollection.contains(element);
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
            this.rootCollection.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.rootCollection.clear();
            if (newInput instanceof List) {
                for (Object element : (List)newInput) {
                    if (!(element instanceof IResource)) continue;
                    this.rootCollection.add((IResource)element);
                }
            }
        }
    }
}

