/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.move;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.refactor.AbstractRefactorAction;
import org.teiid.designer.ui.refactor.move.MoveResourcesRefactoring;
import org.teiid.designer.ui.refactor.move.MoveResourcesWizard;

public class MoveRefactorAction
extends AbstractRefactorAction {
    @Override
    protected RefactoringWizard getRefactoringWizard(List<IResource> resources, IWorkbenchWindow window) {
        MoveResourcesRefactoring refactoring = new MoveResourcesRefactoring(resources);
        String wizardTitle = "Move Resource";
        if (resources.size() > 1) {
            wizardTitle = String.valueOf(wizardTitle) + "s";
        }
        return new MoveResourcesWizard(refactoring, wizardTitle);
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        List resources = SelectionUtilities.getSelectedIResourceObjects((ISelection)selection);
        for (IResource resource : resources) {
            if (!(resource instanceof IProject)) continue;
            action.setEnabled(false);
            return;
        }
        IPath parentDirectory = null;
        for (IResource resource : resources) {
            IPath path = resource.getFullPath();
            path = path.uptoSegment(path.segmentCount() - 1);
            if (parentDirectory == null) {
                parentDirectory = path;
                continue;
            }
            if (parentDirectory.equals((Object)path)) continue;
            action.setEnabled(false);
            return;
        }
        super.selectionChanged(action, selection);
    }
}

