/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.move.MoveResourcesRefactoring;

public class MoveResourcesDescriptor
extends RefactoringDescriptor {
    static final String RESOURCE_PATH_KEY = "ResourcePathKey";
    static final String DESTINATION_PATH_KEY = "DestinationPathKey";
    static final String REFACTORING_ID = MoveResourcesDescriptor.class.getPackage().getName();
    private static final String UNAMED_DESCRIPTOR = "Unamed_Descriptor";
    private IPath destinationPath = null;
    private Collection<IPath> resourcePaths = Collections.emptyList();

    public MoveResourcesDescriptor() {
        this(null, UNAMED_DESCRIPTOR, null);
    }

    public MoveResourcesDescriptor(String project, String description, String comment) {
        super(REFACTORING_ID, project, description, comment, 6);
    }

    public IPath getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(IPath destination) {
        CoreArgCheck.isNotNull((Object)destination);
        this.destinationPath = destination;
    }

    public Collection<IPath> getResourcePaths() {
        return this.resourcePaths;
    }

    public void setResourcePathsToMove(Collection<IPath> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public void setResourcesToMove(Collection<IResource> resources) {
        CoreArgCheck.isNotNull(resources);
        this.resourcePaths = new ArrayList<IPath>();
        for (IResource resource : resources) {
            this.resourcePaths.add(resource.getFullPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource destination = root.findMember(this.destinationPath);
            if (!(destination instanceof IFolder) && !(destination instanceof IProject) || !destination.exists()) {
                status.addFatalError(RefactorResourcesUtils.getString("MoveResourceDescriptor.destinationNotExistError", this.destinationPath));
                return null;
            }
            ArrayList<IResource> resources = new ArrayList<IResource>();
            Iterator<IPath> iterator = this.resourcePaths.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    MoveResourcesRefactoring refactoring = new MoveResourcesRefactoring(resources);
                    refactoring.setDestination((IContainer)destination);
                    return refactoring;
                }
                IPath resourcePath = iterator.next();
                IResource resource = root.findMember(resourcePath);
                if (resource == null || !resource.exists()) {
                    status.addFatalError(RefactorResourcesUtils.getString("MoveResourceDescriptor.resourceNoExistError", resourcePath));
                    return null;
                }
                if (!(resource instanceof IFile) && !(resource instanceof IFolder)) {
                    status.addFatalError(RefactorResourcesUtils.getString("MoveResourceDescriptor.resourceNotFileOrFolder", resourcePath));
                    return null;
                }
                resources.add(resource);
            }
        }
        catch (Exception ex) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)ex.getMessage()));
            throw new CoreException((IStatus)new Status(4, REFACTORING_ID, ex.getMessage()));
        }
    }
}

