/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.move;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.teiid.designer.core.refactor.IRefactorModelHandler;
import org.teiid.designer.core.refactor.PathPair;
import org.teiid.designer.core.refactor.RelatedResourceFinder;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.refactor.AbstractResourcesRefactoring;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.move.MoveResourcesCompositeChange;
import org.teiid.designer.ui.refactor.move.MoveResourcesDescriptor;

public class MoveResourcesRefactoring
extends AbstractResourcesRefactoring {
    private IContainer destination;

    public MoveResourcesRefactoring(List<IResource> selectedResources) {
        super(RefactorResourcesUtils.getString("MoveRefactoring.title", new Object[0]), selectedResources);
    }

    public IContainer getDestination() {
        return this.destination;
    }

    public void setDestination(IContainer destination) {
        this.destination = destination;
    }

    @Override
    protected void checkResource(IResource resource, IProgressMonitor progressMonitor, RefactoringStatus status) {
        String readOnlyStatusMsg = this.getResources().contains(resource) ? RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyResourceError", resource.getName()) : RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyRelatedResourceError", resource.getName());
        RefactorResourcesUtils.checkResourceExists(resource, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkResourceSynched(resource, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkResourceWritable(resource, status, 4, readOnlyStatusMsg);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkResourceIsNotProject(resource, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkExtensionManager(resource, IRefactorModelHandler.RefactorType.MOVE, progressMonitor, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkModelResourceWritable(resource, status, 4, readOnlyStatusMsg);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkSavedResource(resource, status);
        if (!status.isOK()) {
            return;
        }
        RefactorResourcesUtils.checkOpenEditors(resource, status);
    }

    public RefactoringStatus checkInitialConditions(final IProgressMonitor progressMonitor) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            progressMonitor.beginTask(RefactorResourcesUtils.getString("MoveRefactoring.initialConditions", new Object[0]), 1);
            for (IResource resource : this.getResources()) {
                this.checkResource(resource, progressMonitor, status);
                if (!status.isOK()) {
                    break;
                }
                RefactorResourcesUtils.AbstractResourceCallback callback = new RefactorResourcesUtils.AbstractResourceCallback(){

                    @Override
                    public void checkValidFile(IFile relatedFile, RefactoringStatus validityStatus) {
                        MoveResourcesRefactoring.this.checkResource((IResource)relatedFile, progressMonitor, validityStatus);
                    }
                };
                RefactorResourcesUtils.calculateRelatedResources(resource, status, callback, RelatedResourceFinder.Relationship.DEPENDENT);
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor progressMonitor) throws OperationCanceledException {
        this.clearChanges();
        RefactoringStatus status = new RefactoringStatus();
        try {
            try {
                String destinationPath = ModelUtil.getLocation((IResource)this.destination).makeAbsolute().toOSString();
                progressMonitor.beginTask(RefactorResourcesUtils.getString("MoveRefactoring.finalConditions", new Object[0]), 2);
                Set<PathPair> pathPairs = RefactorResourcesUtils.calculateResourceMoves(this.getResources(), destinationPath, RefactorResourcesUtils.Option.EXCLUDE_FOLDERS);
                RelatedResourceCallback relatedResourceCallback = new RelatedResourceCallback(pathPairs);
                for (IResource resource : this.getResources()) {
                    RefactorResourcesUtils.calculateRelatedResources(resource, status, relatedResourceCallback, RelatedResourceFinder.Relationship.DEPENDENT);
                    if (ModelUtil.isModelFile((IResource)resource)) {
                        IFile file = (IFile)resource;
                        Set<PathPair> importPathPairs = RefactorResourcesUtils.calculateImportChanges(file, destinationPath, this.getResourcesAndChildren(status));
                        TextFileChange textFileChange = RefactorResourcesUtils.calculateTextChanges(file, importPathPairs);
                        for (PathPair pair : importPathPairs) {
                            RefactorResourcesUtils.calculateModelImportsElementLChanges(file, pair, textFileChange);
                        }
                        if (this.addTextChange(file, textFileChange)) {
                            RefactorResourcesUtils.calculateRelatedVdbResources((IResource)file, status, new AbstractResourcesRefactoring.VdbResourceCallback());
                        }
                    }
                    this.addChange(resource, (Change)new MoveResourceChange(resource, this.destination));
                }
            }
            catch (Exception ex) {
                UiConstants.Util.log((Throwable)ex);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)ex.getMessage()));
                RefactoringStatus refactoringStatus = status;
                progressMonitor.done();
                return refactoringStatus;
            }
        }
        finally {
            progressMonitor.done();
        }
        return status;
    }

    public Change createChange(IProgressMonitor progressMonitor) throws OperationCanceledException, CoreException {
        try {
            MoveResourcesCompositeChange change;
            progressMonitor.beginTask(RefactorResourcesUtils.getString("MoveRefactoring.creatingChange", new Object[0]), 1);
            MoveResourcesCompositeChange moveResourcesCompositeChange = change = new MoveResourcesCompositeChange(this.getName(), this.getChanges().toArray(new Change[0]), this.destination, this.getResources());
            return moveResourcesCompositeChange;
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, MoveResourcesDescriptor.REFACTORING_ID, ex.getMessage()));
        }
        finally {
            progressMonitor.done();
        }
    }

    private class RelatedResourceCallback
    extends AbstractResourcesRefactoring.VdbResourceCallback {
        private final Set<PathPair> pathPairs;
        private final Set<IResource> history = new HashSet<IResource>();

        public RelatedResourceCallback(Set<PathPair> pathPairs) {
            this.pathPairs = pathPairs;
        }

        @Override
        public void checkValidFile(IFile relatedFile, RefactoringStatus status) {
            MoveResourcesRefactoring.this.checkResource((IResource)relatedFile, (IProgressMonitor)new NullProgressMonitor(), status);
        }

        @Override
        public void indexFile(IResource resource, IFile relatedFile, RefactoringStatus status) throws Exception {
            RefactorResourcesUtils.unloadModelResource((IResource)relatedFile);
            if (this.history.contains(relatedFile)) {
                return;
            }
            this.history.add((IResource)relatedFile);
            if (MoveResourcesRefactoring.this.getResourcesAndChildren(status).contains(relatedFile)) {
                return;
            }
            if (this.pathPairs == null || this.pathPairs.isEmpty()) {
                return;
            }
            IPath relatedFilePath = ModelUtil.getLocation((IResource)relatedFile).makeAbsolute();
            IPath relatedParentPath = relatedFilePath.removeLastSegments(1);
            HashSet<PathPair> relativePathPairs = new HashSet<PathPair>();
            for (PathPair absPathPair : this.pathPairs) {
                relativePathPairs.add(RefactorResourcesUtils.getRelativePath(relatedParentPath.toOSString(), absPathPair));
            }
            TextFileChange textFileChange = RefactorResourcesUtils.calculateTextChanges(relatedFile, relativePathPairs);
            for (PathPair pair : relativePathPairs) {
                RefactorResourcesUtils.calculateModelImportsElementLChanges(relatedFile, pair, textFileChange);
            }
            if (MoveResourcesRefactoring.this.addTextChange(relatedFile, textFileChange)) {
                RefactorResourcesUtils.calculateRelatedVdbResources((IResource)relatedFile, status, this);
            }
        }
    }
}

