/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.move;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.refactor.AbstractResourcesRefactoring;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.SingleProjectModelContentProvider;
import org.teiid.designer.ui.refactor.move.MoveResourcesRefactoring;

public class MoveResourcesWizard
extends RefactoringWizard {
    public MoveResourcesWizard(MoveResourcesRefactoring refactoring, String pageTitle) {
        super((Refactoring)refactoring, 36);
        this.setDefaultPageTitle(pageTitle);
    }

    protected void addUserInputPages() {
        List<IResource> resources = ((AbstractResourcesRefactoring)this.getRefactoring()).getResources();
        this.addPage((IWizardPage)new MoveResourceDestinationPage(resources));
    }

    private static class MoveResourceDestinationPage
    extends UserInputWizardPage {
        private final SingleProjectModelContentProvider contentProvider;
        private final ILabelProvider labelProvider = new ModelExplorerLabelProvider();
        private TreeViewer treeViewer;

        public MoveResourceDestinationPage(List<IResource> resources) {
            super(RefactorResourcesUtils.getString("MoveRefactoring.moveResourceDestinationPage", new Object[0]));
            CoreArgCheck.isNotEmpty(resources, (String)"");
            IProject project = resources.get(0).getProject();
            this.contentProvider = new SingleProjectModelContentProvider(project);
        }

        public MoveResourcesRefactoring getRefactoring() {
            return (MoveResourcesRefactoring)super.getRefactoring();
        }

        private RefactoringStatus createErrorStatus(String msg) {
            return RefactoringStatus.createFatalErrorStatus((String)msg);
        }

        private boolean verifyResourcesProject(Collection<IResource> resources) {
            if (resources == null || resources.isEmpty()) {
                return false;
            }
            IProject project = null;
            for (IResource resource : resources) {
                if (project == null) {
                    project = resource.getProject();
                    continue;
                }
                if (project.equals((Object)resource.getProject())) continue;
                return false;
            }
            return true;
        }

        private void verifyDestination(Object selection) {
            if (!(selection instanceof IContainer)) {
                String msg = RefactorResourcesUtils.getString("MoveRefactoring.destinationNotFolder", new Object[0]);
                this.setPageComplete(this.createErrorStatus(msg));
                return;
            }
            IContainer destination = (IContainer)selection;
            String destinationPath = destination.getFullPath().toString();
            if (destination instanceof IProject) {
                IProject project = (IProject)destination;
                try {
                    if (!project.isOpen() || project.getNature("org.teiid.designer.core.modelNature") == null) {
                        String msg = RefactorResourcesUtils.getString("MoveRefactoring.destinationProjectNotOpen", new Object[0]);
                        this.setPageComplete(this.createErrorStatus(msg));
                        return;
                    }
                }
                catch (CoreException ex) {
                    ModelerCore.Util.log((Throwable)ex);
                    this.setPageComplete(this.createErrorStatus(ex.getMessage()));
                    return;
                }
            }
            RefactoringStatus status = new RefactoringStatus();
            RefactorResourcesUtils.checkResourceExists((IResource)destination, status);
            RefactorResourcesUtils.checkResourceSynched((IResource)destination, status);
            String readOnlyStatusMsg = RefactorResourcesUtils.getString("ResourcesRefactoring.readOnlyResourceError", destination.getName());
            RefactorResourcesUtils.checkResourceWritable((IResource)destination, status, 4, readOnlyStatusMsg);
            if (!status.isOK()) {
                this.setPageComplete(this.createErrorStatus(status.getEntryWithHighestSeverity().getMessage()));
                return;
            }
            List<IResource> resources = this.getRefactoring().getResources();
            if (!this.verifyResourcesProject(resources)) {
                String msg = RefactorResourcesUtils.getString("MoveRefactoring.resourcesNotInSameProject", new Object[0]);
                this.setPageComplete(this.createErrorStatus(msg));
                return;
            }
            for (IResource resource : resources) {
                IFolder folderResource;
                String resourcePath;
                String msg;
                if (!resource.getProject().equals((Object)destination.getProject())) {
                    msg = RefactorResourcesUtils.getString("MoveRefactoring.destinationNotSameProject", new Object[0]);
                    this.setPageComplete(this.createErrorStatus(msg));
                    return;
                }
                if (resource.getParent().equals((Object)destination)) {
                    msg = RefactorResourcesUtils.getString("MoveRefactoring.destinationSame", new Object[0]);
                    this.setPageComplete(this.createErrorStatus(msg));
                    return;
                }
                if (resource instanceof IFolder && destinationPath.startsWith(resourcePath = String.valueOf((folderResource = (IFolder)resource).getFullPath().toString()) + '/')) {
                    String msg2 = RefactorResourcesUtils.getString("MoveRefactoring.destinationSubFolder", new Object[0]);
                    this.setPageComplete(this.createErrorStatus(msg2));
                    return;
                }
                String proposedPath = String.valueOf(destinationPath) + '/' + resource.getName();
                IWorkspaceRoot workspaceRoot = resource.getWorkspace().getRoot();
                if (workspaceRoot.findMember(proposedPath) == null) continue;
                String msg3 = RefactorResourcesUtils.getString("MoveRefactoring.nameClash", resource.getName());
                this.setPageComplete(this.createErrorStatus(msg3));
                return;
            }
            this.getRefactoring().setDestination(destination);
            this.setPageComplete(RefactoringStatus.create((IStatus)Status.OK_STATUS));
        }

        private void addSelectionChangeListener() {
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    this.verifyDestination(ss.getFirstElement());
                }
            });
        }

        private void addLabel(Composite parent) {
            Label label = new Label(parent, 64);
            String text = new String(RefactorResourcesUtils.getString("MoveRefactoring.destinationLabelDefaultText", new Object[0]));
            label.setText(text);
            GridData data = new GridData(4, 0x1000008, true, false);
            data.widthHint = this.convertWidthInCharsToPixels(50);
            label.setLayoutData((Object)data);
        }

        private void createViewer(Composite parent) {
            this.treeViewer = new TreeViewer(parent, 2820);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            gd.heightHint = this.convertHeightInCharsToPixels(15);
            this.treeViewer.getTree().setLayoutData((Object)gd);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            IWorkspaceRoot root = ModelerCore.getWorkspace().getRoot();
            this.treeViewer.setInput((Object)root);
            IProject project = this.getRefactoring().getResources().get(0).getProject();
            this.treeViewer.setExpandedElements(new Object[]{project});
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)project));
            this.verifyDestination(project);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite result = new Composite(parent, 0);
            result.setLayout((Layout)new GridLayout());
            this.addLabel(result);
            this.createViewer(result);
            Dialog.applyDialogFont((Control)result);
            this.addSelectionChangeListener();
            this.setControl((Control)result);
        }
    }
}

