/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.rename.RenameResourceRefactoring;

public class RenameResourceWizard
extends RefactoringWizard {
    public RenameResourceWizard(RenameResourceRefactoring refactoring, String pageTitle) {
        super((Refactoring)refactoring, 36);
        this.setDefaultPageTitle(pageTitle);
    }

    protected void addUserInputPages() {
        IResource resource = ((RenameResourceRefactoring)this.getRefactoring()).getResource();
        this.addPage((IWizardPage)new RenameResourceDestinationPage(resource));
    }

    private static class RenameResourceDestinationPage
    extends UserInputWizardPage {
        static final String STAR_DOT = "*.";
        private String initialFileExtension;
        private final IResource resource;
        private Text nameField;

        public RenameResourceDestinationPage(IResource resource) {
            super(RefactorResourcesUtils.getString("RenameRefactoring.renameResourcePage", new Object[0]));
            CoreArgCheck.isNotNull((Object)resource);
            this.resource = resource;
            this.initialFileExtension = this.resource.getFileExtension();
        }

        public RenameResourceRefactoring getRefactoring() {
            return (RenameResourceRefactoring)super.getRefactoring();
        }

        private RefactoringStatus createErrorStatus(String key, Object ... args) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString(key, args));
        }

        private boolean siblingNameClash(String proposedName) {
            IPath newPath = this.resource.getFullPath().removeLastSegments(1).append(proposedName);
            IWorkspaceRoot workspaceRoot = this.resource.getWorkspace().getRoot();
            boolean result = workspaceRoot.findMember(newPath) != null;
            return result;
        }

        private final void validatePage() {
            String newName = this.nameField.getText();
            if (newName == null || newName.length() == 0) {
                this.setPageComplete(this.createErrorStatus("RenameRefactoring.invalidNoName", new Object[0]));
                return;
            }
            char[] validChars = new char[]{'.', '_'};
            ValidationResultImpl result = new ValidationResultImpl((Object)newName);
            CoreValidationRulesUtil.validateStringNameChars((ValidationResult)result, (String)newName, (char[])validChars);
            if (result.hasProblems()) {
                ValidationProblem problem = result.getProblems()[0];
                this.setPageComplete(RefactoringStatus.createErrorStatus((String)problem.getMessage()));
                return;
            }
            int i = 0;
            int invalid = 0;
            while (i < newName.length()) {
                if (validChars[0] == newName.charAt(i)) {
                    ++invalid;
                }
                if (invalid > 1) {
                    this.setPageComplete(this.createErrorStatus("RenameRefactoring.invalidPeriodsInName", new Object[0]));
                    return;
                }
                ++i;
            }
            if (this.resource.getName().equals(newName)) {
                this.setPageComplete(this.createErrorStatus("RenameRefactoring.invalidSameName", new Object[0]));
                return;
            }
            if (this.siblingNameClash(newName)) {
                this.setPageComplete(this.createErrorStatus("RenameRefactoring.invalidNameClash", new Object[0]));
                return;
            }
            if (this.initialFileExtension != null && !newName.toUpperCase().endsWith("." + this.initialFileExtension.toUpperCase())) {
                String extString = STAR_DOT + this.initialFileExtension;
                this.setPageComplete(this.createErrorStatus("RenameRefactoring.invalidFileExtension", extString));
                return;
            }
            this.getRefactoring().setNewResourceName(newName);
            this.setPageComplete(RefactoringStatus.create((IStatus)Status.OK_STATUS));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(RefactorResourcesUtils.getString("RenameRefactoring.nameLabel", new Object[0]));
            label.setLayoutData((Object)new GridData());
            this.nameField = new Text(composite, 2048);
            this.nameField.setText(this.resource.getName());
            this.nameField.setFont(composite.getFont());
            this.nameField.setLayoutData((Object)new GridData(4, 1, true, false));
            this.nameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.validatePage();
                }
            });
            this.nameField.selectAll();
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }
    }
}

