/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.search.IModelObjectMatch;
import org.teiid.designer.ui.search.MetadataMatchInfo;
import org.teiid.designer.ui.search.MetadataSearchQuery;

public class MetadataSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter,
UiConstants {
    private final Match[] NO_MATCHES = new Match[0];
    private final MetadataSearchQuery query;

    public MetadataSearchResult(MetadataSearchQuery query) {
        this.query = query;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return this.computeContainedMatches(result, ((IFileEditorInput)editorInput).getFile());
        }
        return this.NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        MetadataMatchInfo info = new MetadataMatchInfo(file.getFullPath().toOSString(), (MetadataSearchResult)result);
        return this.getMatches(info);
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFile getFile(Object element) {
        if (element instanceof MetadataMatchInfo) {
            return ModelerCore.getWorkspace().getRoot().getFile((IPath)new Path(((MetadataMatchInfo)element).getResourcePath()));
        }
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        return Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MetadataSearchResult.class)) + "result.msg", new Object[]{((MetadataSearchQuery)this.getQuery()).getSearchCriteria(), this.getMatchCount()});
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        if (match instanceof IModelObjectMatch) {
            IEditorInput editorInput;
            String matchResourcePath = ((IModelObjectMatch)match).getResourcePath();
            String editorResourcePath = null;
            if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                editorResourcePath = ((IFileEditorInput)editorInput).getFile().getFullPath().toOSString();
            }
            return matchResourcePath.equals(editorResourcePath);
        }
        return false;
    }
}

