/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.search.FindObjectLabelProvider;
import org.teiid.designer.ui.search.IFinderHostDialog;
import org.teiid.designer.ui.search.IFinderPanel;
import org.teiid.designer.ui.search.TwoArrayQuickSorter;

public class ModelObjectSelectionPanel
extends Composite
implements IFinderPanel {
    private static final String TITLE = UiConstants.Util.getString("ModelObjectSelectionPanel.title", new Object[0]);
    private static final String TEXT_ENTRY_LABEL_TEXT = UiConstants.Util.getString("ModelObjectSelectionPanel.textEntryLabel.text", new Object[0]);
    private static final String UPPER_TABLE_LABEL_TEXT = UiConstants.Util.getString("ModelObjectSelectionPanel.upperTableLabel.text", new Object[0]);
    private static final String LOWER_TABLE_LABEL_TEXT = UiConstants.Util.getString("ModelObjectSelectionPanel.lowerTableLabel.text", new Object[0]);
    private HashMap hmUniqueNames;
    private String sSelectedObject;
    private String sSelectedPath;
    private String fUpperListLabel;
    private String fLowerListLabel;
    ILabelProvider fQualifierRenderer;
    private ILabelProvider fFilterRenderer;
    private Object[] fElements = new Object[0];
    private Table fLowerList;
    private Object[] fQualifierElements;
    protected FilteredList fFilteredList;
    private String fFilter;
    Text fFilterText;
    private ISelectionStatusValidator fValidator;
    private String fEmptyListMessage = "";
    private String fEmptySelectionMessage = "";
    private Object[] result;
    private boolean fIgnoreCase = true;
    private boolean fAllowDuplicates = false;
    private boolean fMatchEmptyString = true;
    private Object[] fSelection = new Object[0];
    private Label fMessage;
    private List initialSelections = new ArrayList();
    private IFinderHostDialog fhpHostDialog;
    private IStatus stCurrentStatus;
    private boolean bUserCancelledDuringLoad = false;
    private boolean bEnableProgressCancel = true;

    public ModelObjectSelectionPanel(Composite parent, IFinderHostDialog fhpHostDialog) {
        super(parent, 0);
        this.fhpHostDialog = fhpHostDialog;
        this.fQualifierRenderer = new FindObjectLabelProvider(1);
        this.fFilterRenderer = new FindObjectLabelProvider(0);
        this.init();
    }

    public ModelObjectSelectionPanel(Composite parent, IFinderHostDialog fhpHostDialog, boolean bEnableProgressCancel) {
        super(parent, 0);
        this.fhpHostDialog = fhpHostDialog;
        this.bEnableProgressCancel = bEnableProgressCancel;
        this.fQualifierRenderer = new FindObjectLabelProvider(1);
        this.fFilterRenderer = new FindObjectLabelProvider(0);
        this.init();
    }

    private IFinderHostDialog getHost() {
        return this.fhpHostDialog;
    }

    private void init() {
        this.setUpperListLabel(UPPER_TABLE_LABEL_TEXT);
        this.setLowerListLabel(LOWER_TABLE_LABEL_TEXT);
        this.doLoadObjects();
        this.createControl(this);
    }

    private void doLoadObjects() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                ModelObjectSelectionPanel.this.loadObjects(theMonitor);
                theMonitor.done();
            }
        };
        ProgressMonitorDialog dlg = null;
        try {
            dlg = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dlg.run(true, this.bEnableProgressCancel, (IRunnableWithProgress)op);
            if (dlg.getProgressMonitor().isCanceled()) {
                this.bUserCancelledDuringLoad = true;
            } else {
                dlg.getProgressMonitor().worked(1);
            }
        }
        catch (InterruptedException interruptedException) {
            this.bUserCancelledDuringLoad = true;
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(e.getTargetException());
        }
    }

    public boolean userCancelledDuringLoad() {
        return this.bUserCancelledDuringLoad;
    }

    void loadObjects(IProgressMonitor monitor) {
        ModelWorkspaceSearch mwssSearch = new ModelWorkspaceSearch(monitor);
        Collection colRecordObjects = mwssSearch.getAllModelObjectRecords();
        this.hmUniqueNames = new HashMap();
        if (colRecordObjects == null) {
            return;
        }
        for (ResourceObjectRecord ror : colRecordObjects) {
            if (ror.getName().trim().equals("")) continue;
            if (this.hmUniqueNames.containsKey(ror.getName())) {
                ArrayList aryl = (ArrayList)this.hmUniqueNames.get(ror.getName());
                aryl.add(ror);
                continue;
            }
            ArrayList<ResourceObjectRecord> aryl2 = new ArrayList<ResourceObjectRecord>();
            aryl2.add(ror);
            this.hmUniqueNames.put(ror.getName(), aryl2);
        }
        this.setElements(this.getElementsFromSource());
    }

    private Object[] getElementsFromSource() {
        ArrayList arylElements = new ArrayList(this.hmUniqueNames.values().size());
        for (ArrayList arylTemp : this.hmUniqueNames.values()) {
            arylElements.add(arylTemp.get(0));
        }
        return arylElements.toArray();
    }

    public Object[] getFoldedElements(int index) {
        String sName = null;
        Object[] oArySelection = this.fFilteredList.getSelection();
        if (oArySelection.length > 0) {
            sName = ((ResourceObjectRecord)oArySelection[0]).getName();
        }
        ArrayList aryl = (ArrayList)this.hmUniqueNames.get(sName);
        Object[] oAry = new Object[aryl.size()];
        Iterator it = aryl.iterator();
        int ix = 0;
        while (it.hasNext()) {
            ResourceObjectRecord rorTemp = (ResourceObjectRecord)it.next();
            oAry[ix++] = rorTemp;
        }
        return oAry;
    }

    public void setUpperListLabel(String label) {
        this.fUpperListLabel = label;
    }

    public void setLowerListLabel(String label) {
        this.fLowerListLabel = label;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    public Control createControl(Composite parent) {
        Composite contents = parent;
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createLabel(contents, this.fUpperListLabel);
        this.createFilteredList(contents);
        this.createLabel(contents, this.fLowerListLabel);
        this.createLowerList(contents);
        this.setListElements(this.fElements);
        List initialSelections = this.getInitialElementSelections();
        if (!initialSelections.isEmpty()) {
            Object element = initialSelections.get(0);
            this.setSelection(new Object[]{element});
            this.setLowerSelectedElement(element);
        }
        return contents;
    }

    @Deprecated
    protected List getInitialSelections() {
        if (this.initialSelections.isEmpty()) {
            return null;
        }
        return this.getInitialElementSelections();
    }

    protected List getInitialElementSelections() {
        return this.initialSelections;
    }

    protected void setSelection(Object[] selection) {
        Assert.isNotNull((Object)this.fFilteredList);
        this.fFilteredList.setSelection(selection);
    }

    protected void setListElements(Object[] elements) {
        Assert.isNotNull((Object)this.fFilteredList);
        this.fFilteredList.setElements(elements);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (TEXT_ENTRY_LABEL_TEXT != null) {
            label.setText(TEXT_ENTRY_LABEL_TEXT);
        }
        label.setFont(composite.getFont());
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        this.fMessage = label;
        return label;
    }

    protected Label createLabel(Composite parent, String name) {
        if (name == null) {
            return null;
        }
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setFont(parent.getFont());
        return label;
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.setText(this.fFilter == null ? "" : this.fFilter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                ModelObjectSelectionPanel.this.fFilteredList.setFilter(ModelObjectSelectionPanel.this.fFilterText.getText());
            }
        };
        text.addListener(24, listener);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ModelObjectSelectionPanel.this.fFilteredList.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterText = text;
        return text;
    }

    protected FilteredList createFilteredList(Composite parent) {
        int flags = 2820;
        FilteredList list = new FilteredList(parent, flags, this.fFilterRenderer, this.fIgnoreCase, this.fAllowDuplicates, this.fMatchEmptyString);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        list.setFilter(this.fFilter == null ? "" : this.fFilter);
        list.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ModelObjectSelectionPanel.this.handleDefaultSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                ModelObjectSelectionPanel.this.handleWidgetSelected();
            }
        });
        this.fFilteredList = list;
        return list;
    }

    void handleWidgetSelected() {
        Object[] newSelection = this.fFilteredList.getSelection();
        if (newSelection.length != this.fSelection.length) {
            this.fSelection = newSelection;
            this.handleSelectionChanged();
        } else {
            int i = 0;
            while (i != newSelection.length) {
                if (!newSelection[i].equals(this.fSelection[i])) {
                    this.fSelection = newSelection;
                    this.handleSelectionChanged();
                    break;
                }
                ++i;
            }
        }
    }

    protected Table createLowerList(Composite parent) {
        Table list = new Table(parent, 2816);
        list.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                ModelObjectSelectionPanel.this.handleLowerSelectionChanged();
            }
        });
        list.addListener(8, new Listener(){

            public void handleEvent(Event evt) {
                ModelObjectSelectionPanel.this.handleDefaultSelected();
            }
        });
        list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ModelObjectSelectionPanel.this.fQualifierRenderer.dispose();
            }
        });
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        this.fLowerList = list;
        return list;
    }

    public static int convertWidthInCharsToPixels(FontMetrics fontMetrics, int chars) {
        return fontMetrics.getAverageCharWidth() * chars;
    }

    protected void computeResult() {
        Object[] results = new Object[]{this.getLowerSelectedElement()};
        this.setResult(Arrays.asList(results));
    }

    protected void setResult(List newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    protected void handleDefaultSelected() {
        this.handleUpperSelectionChanged();
        if (this.validateCurrentSelection() && this.getLowerSelectedElement() != null) {
            this.getHost().okPressed();
        }
    }

    protected void handleSelectionChanged() {
        this.validateCurrentSelection();
        this.handleUpperSelectionChanged();
        this.handleLowerSelectionChanged();
    }

    protected boolean validateCurrentSelection() {
        Assert.isNotNull((Object)this.fFilteredList);
        EObject eoSelection = this.getSelectedEObject();
        Object[] elements = new Object[]{eoSelection};
        Object status = eoSelection == null ? new Status(4, "org.eclipse.ui", 4, this.fEmptySelectionMessage, null) : (elements.length > 0 ? (this.fValidator != null ? this.fValidator.validate(elements) : new Status(0, "org.eclipse.ui", 0, "", null)) : (this.fFilteredList.isEmpty() ? new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null) : new Status(4, "org.eclipse.ui", 4, this.fEmptySelectionMessage, null)));
        this.stCurrentStatus = status;
        this.getHost().updateTheStatus(this.stCurrentStatus);
        return status.isOK();
    }

    @Override
    public Object[] getResult() {
        return new Object[]{this.getSelectedEObject()};
    }

    protected Object[] getSelectedElements() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelection();
    }

    void handleUpperSelectionChanged() {
        Object[] oArySelection;
        int index = this.getSelectionIndex();
        this.fLowerList.removeAll();
        if (index < 0) {
            return;
        }
        this.fQualifierElements = this.getFoldedElements(index);
        if (this.fQualifierElements == null) {
            this.updateLowerListWidget(new Object[0]);
        } else {
            this.updateLowerListWidget(this.fQualifierElements);
        }
        this.updateOkState();
        if (this.getSelectedElements()[0] != null && (oArySelection = this.fFilteredList.getSelection()).length > 0) {
            this.sSelectedObject = ((ResourceObjectRecord)oArySelection[0]).getName();
        }
    }

    protected int getSelectionIndex() {
        Assert.isNotNull((Object)this.fFilteredList);
        return this.fFilteredList.getSelectionIndex();
    }

    void handleLowerSelectionChanged() {
        this.updateOkState();
        if (this.getLowerSelectedElement() != null) {
            this.sSelectedPath = ((ResourceObjectRecord)this.getLowerSelectedElement()).getResourcePath();
        }
    }

    public void updateOkState() {
    }

    protected void setLowerSelectedElement(Object element) {
        if (this.fQualifierElements == null) {
            return;
        }
        int i = 0;
        while (i != this.fQualifierElements.length) {
            if (this.fQualifierElements[i].equals(element)) break;
            ++i;
        }
        if (i != this.fQualifierElements.length) {
            this.fLowerList.setSelection(i);
        }
    }

    protected Object getLowerSelectedElement() {
        int index = this.fLowerList.getSelectionIndex();
        if (index >= 0) {
            return this.fQualifierElements[index];
        }
        return null;
    }

    private void updateLowerListWidget(Object[] elements) {
        int length = elements.length;
        Object[] qualifiers = new String[length];
        int i = 0;
        while (i != length) {
            qualifiers[i] = this.fQualifierRenderer.getText(elements[i]);
            ++i;
        }
        TwoArrayQuickSorter sorter = new TwoArrayQuickSorter(this.isCaseIgnored());
        sorter.sort(qualifiers, elements);
        int i2 = 0;
        while (i2 != length) {
            TableItem item = new TableItem(this.fLowerList, 0);
            item.setText((String)qualifiers[i2]);
            item.setImage(this.fQualifierRenderer.getImage(elements[i2]));
            ++i2;
        }
        if (this.fLowerList.getItemCount() > 0) {
            this.fLowerList.setSelection(0);
        }
    }

    public boolean isCaseIgnored() {
        return this.fIgnoreCase;
    }

    protected void handleEmptyList() {
        this.fMessage.setEnabled(false);
        this.fFilterText.setEnabled(false);
        this.fFilteredList.setEnabled(false);
        this.fLowerList.setEnabled(false);
        this.updateOkState();
    }

    @Override
    public void createButtonsForButtonBar(Composite parent) {
    }

    @Override
    public void handleOkPressed() {
    }

    @Override
    public void handleCancelPressed() {
    }

    @Override
    public void updateOKStatus() {
        Status fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
        this.getHost().updateTheStatus((IStatus)fCurrStatus);
    }

    public EObject getSelectedEObject() {
        if (this.sSelectedObject == null) {
            return null;
        }
        String sName = this.sSelectedObject;
        ArrayList aryl = (ArrayList)this.hmUniqueNames.get(sName);
        Iterator it = aryl.iterator();
        ResourceObjectRecord rorSelected = null;
        while (it.hasNext()) {
            ResourceObjectRecord rorTemp = (ResourceObjectRecord)it.next();
            if (!this.sSelectedPath.equals(rorTemp.getResourcePath())) continue;
            rorSelected = rorTemp;
            break;
        }
        EObject eObj = null;
        if (rorSelected != null) {
            try {
                URI uri = URI.createURI((String)rorSelected.getObjectURI());
                eObj = ModelerCore.getModelContainer().getEObject(uri, true);
            }
            catch (CoreException ce) {
                ModelerCore.Util.log(4, (Throwable)ce, ce.getMessage());
            }
        }
        return eObj;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }
}

