/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.ExtendedTitleAreaDialog;
import org.teiid.designer.ui.table.ClipboardPasteStatusRecord;
import org.teiid.designer.ui.table.ITablePasteValidator;

public class ClipboardPasteProblemDialog
extends ExtendedTitleAreaDialog
implements UiConstants,
PluginConstants.Images {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ClipboardPasteProblemDialog.class);
    private static final String[] MESSAGE_TBL_HDRS = new String[]{"", Util.getString(String.valueOf(PREFIX) + "pasteColumnHdr", new Object[0]), Util.getString(String.valueOf(PREFIX) + "pasteDataHdr", new Object[0]), Util.getString(String.valueOf(PREFIX) + "descriptionHdr", new Object[0])};
    private static final int ICON_INDEX = 0;
    private static final int COLUMN_INDEX = 1;
    private static final int DATA_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final Image BLANK_IMAGE;
    private static final Image ERROR_IMAGE;
    private static final Image INFO_IMAGE;
    private static final Image WARNING_IMAGE;
    public static final String TRUNCATED_COLUMN_TITLE;
    private CLabel lblMessagesTitle;
    private SashForm sash;
    private TableEditor dataTableEditor;
    TableViewer dataViewer;
    private DataViewerContentProvider dataViewerContentProvider;
    TableViewer messageViewer;
    private MessageViewerContentProvider messageViewerContentProvider;
    int selectedColumn;
    List statusRecords;
    ITablePasteValidator validator;
    private int errorCount;
    private int infoCount;
    private int validCount;
    private int warningCount;
    private int truncatedColumnCount;
    private int truncatedRowCount;

    static {
        TRUNCATED_COLUMN_TITLE = Util.getString(String.valueOf(PREFIX) + "truncatedColumnHdr", new Object[0]);
        BLANK_IMAGE = UiPlugin.getDefault().getImage("icons/full/cview16/blank.gif");
        ERROR_IMAGE = org.teiid.designer.ui.common.UiPlugin.getDefault().getImage("icons/full/obj16/error_st_obj.gif");
        WARNING_IMAGE = org.teiid.designer.ui.common.UiPlugin.getDefault().getImage("icons/full/obj16/warn_st_obj.gif");
        INFO_IMAGE = org.teiid.designer.ui.common.UiPlugin.getDefault().getImage("icons/full/obj16/info_st_obj.gif");
    }

    public ClipboardPasteProblemDialog(Shell theParent, List theRecords) {
        super(theParent, (AbstractUIPlugin)UiPlugin.getDefault());
        this.statusRecords = theRecords;
    }

    public ClipboardPasteProblemDialog(Shell theParent, List theRecords, ITablePasteValidator theValidator) {
        super(theParent, (AbstractUIPlugin)UiPlugin.getDefault());
        this.statusRecords = theRecords;
        this.validator = theValidator;
    }

    public void create() {
        super.create();
        Table table = this.dataViewer.getTable();
        List firstRow = (List)this.statusRecords.get(0);
        int size = firstRow.size();
        int i = 0;
        while (i < size) {
            TableColumn column = new TableColumn(table, 16384);
            ClipboardPasteStatusRecord record = (ClipboardPasteStatusRecord)firstRow.get(i);
            column.setText(record.getColumnName());
            ++i;
        }
        this.dataViewer.setInput((Object)this.statusRecords);
        TableColumn[] columns = this.dataViewer.getTable().getColumns();
        i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
        this.messageViewer.setInput((Object)this.statusRecords);
        columns = this.messageViewer.getTable().getColumns();
        i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
        this.sash.setWeights(new int[]{60, 40});
        this.setDynamicMessages();
        this.setOkEnabledState(true);
    }

    protected Control createDialogArea(Composite theParent) {
        Composite pnlContents = (Composite)super.createDialogArea(theParent);
        pnlContents.setLayout((Layout)new GridLayout());
        this.sash = new SashForm(pnlContents, 512);
        this.sash.setLayoutData((Object)new GridData(1808));
        this.createPasteDataArea((Composite)this.sash);
        this.createMessageArea((Composite)this.sash);
        this.setDialogTitle(Util.getString(String.valueOf(PREFIX) + "windowTitle", new Object[0]));
        this.setTitle(Util.getString(String.valueOf(PREFIX) + "title", new Object[0]));
        return pnlContents;
    }

    private Composite createMessageArea(Composite theParent) {
        ViewForm viewForm = new ViewForm(theParent, 2048);
        this.lblMessagesTitle = WidgetFactory.createLabel((Composite)viewForm);
        viewForm.setTopLeft((Control)this.lblMessagesTitle);
        Composite pnlContents = new Composite((Composite)viewForm, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Table table = (Table)this.getChildren()[0];
                return super.computeSize(wHint, table.getItemHeight() * 5 + table.getHeaderHeight(), changed);
            }
        };
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pnlContents.setLayout((Layout)layout);
        pnlContents.setLayoutData((Object)new GridData(1808));
        viewForm.setContent((Control)pnlContents);
        int style = 66312;
        this.messageViewer = new TableViewer(pnlContents, style);
        this.messageViewerContentProvider = new MessageViewerContentProvider();
        this.messageViewer.setContentProvider((IContentProvider)this.messageViewerContentProvider);
        this.messageViewer.setLabelProvider((IBaseLabelProvider)new MessageViewerLabelProvider());
        Table table = this.messageViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < MESSAGE_TBL_HDRS.length) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(MESSAGE_TBL_HDRS[i]);
            ++i;
        }
        return viewForm;
    }

    private Composite createPasteDataArea(Composite theParent) {
        ViewForm viewForm = new ViewForm(theParent, 2048);
        viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)viewForm, (String)Util.getString(String.valueOf(PREFIX) + "pasteDataTitle", new Object[0])));
        Composite pnlContents = new Composite((Composite)viewForm, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Table table = (Table)this.getChildren()[0];
                return super.computeSize(wHint, table.getItemHeight() * 10 + table.getHeaderHeight(), changed);
            }
        };
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pnlContents.setLayout((Layout)layout);
        pnlContents.setLayoutData((Object)new GridData(1808));
        viewForm.setContent((Control)pnlContents);
        int style = 66312;
        this.dataViewer = new TableViewer(pnlContents, style);
        this.dataViewerContentProvider = new DataViewerContentProvider();
        this.dataViewer.setContentProvider((IContentProvider)this.dataViewerContentProvider);
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new DataViewerLabelProvider());
        Table table = this.dataViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(1808));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent theEvent) {
                ClipboardPasteProblemDialog.this.handleDataViewerMouseEvent(theEvent);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ClipboardPasteProblemDialog.this.handleDataViewerSelectionEvent();
            }
        });
        this.dataTableEditor = new TableEditor(table);
        this.dataTableEditor.horizontalAlignment = 16384;
        this.dataTableEditor.grabHorizontal = true;
        this.dataTableEditor.minimumWidth = 50;
        return viewForm;
    }

    String getPasteData(int theRow, int theColumn) {
        List row = (List)this.statusRecords.get(theRow);
        ClipboardPasteStatusRecord record = (ClipboardPasteStatusRecord)row.get(theColumn);
        return record.getPasteData();
    }

    private String getDialogMessage() {
        String msg = null;
        msg = this.errorCount > 0 ? Util.getString(String.valueOf(PREFIX) + "errorsExist.msg", new Object[]{new Integer(this.errorCount)}) : (this.validCount == 0 ? Util.getString(String.valueOf(PREFIX) + "noPasteData.msg", new Object[0]) : (this.warningCount > 0 ? (this.truncatedRowCount > 0 ? (this.truncatedColumnCount > 0 ? Util.getString(String.valueOf(PREFIX) + "rowsAndColumnsTruncated.msg", new Object[]{new Integer(this.truncatedRowCount), new Integer(this.truncatedColumnCount)}) : Util.getString(String.valueOf(PREFIX) + "rowsTruncated.msg", new Object[]{new Integer(this.truncatedRowCount)})) : (this.truncatedColumnCount > 0 ? Util.getString(String.valueOf(PREFIX) + "columnsTruncated.msg", new Object[]{new Integer(this.truncatedColumnCount)}) : Util.getString(String.valueOf(PREFIX) + "warningsExist.msg", new Object[0]))) : (this.infoCount > 0 ? Util.getString(String.valueOf(PREFIX) + "infosExist.msg", new Object[0]) : Util.getString(String.valueOf(PREFIX) + "validData.msg", new Object[0]))));
        return msg;
    }

    private int getDialogMessageType() {
        int errorType = 0;
        if (this.errorCount > 0) {
            errorType = 3;
        } else if (this.validCount == 0) {
            errorType = 1;
        } else if (this.warningCount > 0) {
            errorType = 2;
        } else if (this.infoCount > 0) {
            errorType = 1;
        }
        return errorType;
    }

    Image getStatusImage(ClipboardPasteStatusRecord theRecord) {
        Image result = null;
        if (theRecord.isValid()) {
            result = BLANK_IMAGE;
        } else if (theRecord.isError()) {
            result = ERROR_IMAGE;
        } else if (theRecord.isRowTruncated() || theRecord.isColumnTruncated() || theRecord.isProtectedColumn() || theRecord.isWarning()) {
            result = WARNING_IMAGE;
        } else if (theRecord.isInfo()) {
            result = INFO_IMAGE;
        }
        return result;
    }

    public List getStatusRecords() {
        return this.statusRecords;
    }

    void handleDataViewerMouseEvent(MouseEvent theEvent) {
        Table table = this.dataViewer.getTable();
        TableItem[] selectedItems = table.getSelection();
        this.selectedColumn = -1;
        if (selectedItems.length > 0) {
            int numCols = table.getColumnCount();
            int i = 0;
            while (i < numCols) {
                Rectangle bounds = selectedItems[0].getBounds(i);
                if (bounds.contains(theEvent.x, theEvent.y)) {
                    this.selectedColumn = i;
                    break;
                }
                ++i;
            }
            if (this.selectedColumn != -1) {
                int index = table.getSelectionIndex();
                List row = (List)this.statusRecords.get(index);
                ClipboardPasteStatusRecord record = (ClipboardPasteStatusRecord)row.get(this.selectedColumn);
                StructuredSelection selection = new StructuredSelection((Object)record);
                this.messageViewer.setSelection((ISelection)selection, true);
            }
        }
    }

    void handleDataViewerSelectionEvent() {
        List row;
        ClipboardPasteStatusRecord record;
        Table table = this.dataViewer.getTable();
        final int selectedRow = table.getSelectionIndex();
        if (!(selectedRow == -1 || this.selectedColumn == -1 || (record = (ClipboardPasteStatusRecord)(row = (List)this.statusRecords.get(selectedRow)).get(this.selectedColumn)).isRowTruncated() || record.isColumnTruncated() || record.isProtectedColumn())) {
            final Text textWidget = new Text((Composite)table, 0);
            textWidget.setText(record.getPasteData());
            textWidget.setSelection(0, textWidget.getText().length());
            textWidget.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent theEvent) {
                    ClipboardPasteProblemDialog.this.setOkEnabledState(false);
                }

                public void focusLost(FocusEvent theEvent) {
                    String oldText = ClipboardPasteProblemDialog.this.getPasteData(selectedRow, ClipboardPasteProblemDialog.this.selectedColumn);
                    String newText = textWidget.getText();
                    boolean changed = false;
                    if (newText == null) {
                        changed = oldText != null;
                    } else {
                        boolean bl = changed = oldText == null || !oldText.equals(newText);
                    }
                    if (changed) {
                        int[] tableSelectedRowColumn = ClipboardPasteProblemDialog.this.validator.getSelectedRowAndColumn();
                        ClipboardPasteStatusRecord newRecord = ClipboardPasteProblemDialog.this.validator.constructPasteStatusRecord(newText, selectedRow + tableSelectedRowColumn[0], ClipboardPasteProblemDialog.this.selectedColumn + tableSelectedRowColumn[1]);
                        ClipboardPasteProblemDialog.this.setRecord(newRecord, selectedRow, ClipboardPasteProblemDialog.this.selectedColumn);
                        ClipboardPasteProblemDialog.this.dataViewer.refresh((Object)row, true);
                        ClipboardPasteProblemDialog.this.messageViewer.setInput((Object)ClipboardPasteProblemDialog.this.statusRecords);
                    }
                    textWidget.dispose();
                    ClipboardPasteProblemDialog.this.setOkEnabledState(true);
                }
            });
            this.dataTableEditor.setEditor((Control)textWidget, table.getItem(selectedRow), this.selectedColumn);
            textWidget.setFocus();
        }
    }

    void resetCounts() {
        this.warningCount = 0;
        this.validCount = 0;
        this.truncatedRowCount = 0;
        this.truncatedColumnCount = 0;
        this.infoCount = 0;
        this.errorCount = 0;
    }

    public void setDialogTitle(String theTitle) {
        CoreArgCheck.isNotNull((Object)theTitle);
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setText(theTitle);
        }
    }

    private void setDynamicMessages() {
        this.lblMessagesTitle.setText(Util.getString(String.valueOf(PREFIX) + "messagesTitle", new Object[]{new Integer(this.errorCount), new Integer(this.warningCount), new Integer(this.infoCount)}));
        this.setMessage(this.getDialogMessage(), this.getDialogMessageType());
    }

    void setOkEnabledState(boolean theEnableState) {
        boolean enable = theEnableState;
        if (theEnableState) {
            enable = this.errorCount == 0 && this.validCount > 0;
        }
        this.getButton(0).setEnabled(enable);
    }

    void setRecord(ClipboardPasteStatusRecord theRecord, int theRow, int theColumn) {
        List row = (List)this.statusRecords.get(theRow);
        ClipboardPasteStatusRecord oldRecord = (ClipboardPasteStatusRecord)row.get(theColumn);
        this.updateCounts(oldRecord, false);
        this.updateCounts(theRecord, true);
        oldRecord.setPasteData(theRecord.getPasteData());
        oldRecord.setDescription(theRecord.getDescription());
        oldRecord.setType(theRecord.getType());
        this.setDynamicMessages();
        this.getButton(0).setEnabled(this.errorCount == 0);
    }

    void updateCounts(ClipboardPasteStatusRecord theRecord, boolean theIncreaseFlag) {
        int addend = theIncreaseFlag ? 1 : -1;
        Image image = this.getStatusImage(theRecord);
        if (image == BLANK_IMAGE) {
            this.validCount += addend;
        } else if (image == ERROR_IMAGE) {
            this.errorCount += addend;
        } else if (image == WARNING_IMAGE) {
            this.warningCount += addend;
        } else if (image == INFO_IMAGE) {
            this.infoCount += addend;
        }
    }

    void updateTableCellBackground(List theRow, int theColumnIndex) {
        int index;
        ClipboardPasteStatusRecord record = (ClipboardPasteStatusRecord)theRow.get(theColumnIndex);
        if (record.isRowTruncated() && (index = this.statusRecords.indexOf(theRow)) != -1) {
            TableItem item = this.dataViewer.getTable().getItem(index);
            item.setBackground(UiUtil.getSystemColor((int)29));
        }
    }

    class DataViewerContentProvider
    implements IStructuredContentProvider {
        Object[] rows = null;

        DataViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            return this.rows == null ? new Object[]{} : this.rows;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
            boolean validInput = false;
            List result = null;
            ClipboardPasteProblemDialog.this.resetCounts();
            if (theNewInput != null && theNewInput instanceof List && !((List)theNewInput).isEmpty()) {
                result = (List)theNewInput;
                int numRows = result.size();
                int i = 0;
                while (i < numRows) {
                    List row = (List)result.get(i);
                    int numCols = row.size();
                    int j = 0;
                    while (j < numCols) {
                        ClipboardPasteProblemDialog.this.updateCounts((ClipboardPasteStatusRecord)row.get(j), true);
                        ++j;
                    }
                    ++i;
                }
                validInput = true;
            }
            this.rows = validInput ? result.toArray() : new Object[0];
        }
    }

    class DataViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DataViewerLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theColumnIndex) {
            Object obj;
            Image result = null;
            if (theElement instanceof List && (obj = ((List)theElement).get(theColumnIndex)) instanceof ClipboardPasteStatusRecord) {
                result = ClipboardPasteProblemDialog.this.getStatusImage((ClipboardPasteStatusRecord)obj);
            }
            return result;
        }

        public String getColumnText(Object theElement, int theColumnIndex) {
            String result = null;
            if (theElement instanceof List) {
                Object obj = ((List)theElement).get(theColumnIndex);
                if (obj instanceof ClipboardPasteStatusRecord) {
                    ClipboardPasteStatusRecord record = (ClipboardPasteStatusRecord)obj;
                    result = record.getPasteData();
                    ClipboardPasteProblemDialog.this.updateTableCellBackground((List)theElement, theColumnIndex);
                } else {
                    result = super.getText(theElement);
                }
            }
            return result == null ? "" : result;
        }
    }

    class MessageViewerContentProvider
    implements IStructuredContentProvider {
        Object[] rows = null;

        MessageViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            return this.rows == null ? new Object[]{} : this.rows;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
            ArrayList result;
            boolean validInput;
            block8: {
                validInput = true;
                result = null;
                if (theNewInput != null && theNewInput instanceof List && !((List)theNewInput).isEmpty()) {
                    List input = (List)theNewInput;
                    result = new ArrayList(input.size());
                    int numRows = input.size();
                    int i = 0;
                    while (i < numRows) {
                        Object objRow = input.get(i);
                        if (objRow instanceof List) {
                            List row = (List)objRow;
                            int numColumns = row.size();
                            int j = 0;
                            while (j < numColumns) {
                                Object objColumn = row.get(j);
                                if (!(objColumn instanceof ClipboardPasteStatusRecord)) {
                                    validInput = false;
                                    break block8;
                                }
                                if (!((ClipboardPasteStatusRecord)objColumn).isValid()) {
                                    result.add(objColumn);
                                }
                                ++j;
                            }
                        } else {
                            validInput = false;
                            break;
                        }
                        ++i;
                    }
                } else {
                    validInput = false;
                }
            }
            this.rows = validInput ? result.toArray() : new Object[0];
        }
    }

    class MessageViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MessageViewerLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theColumnIndex) {
            Image result = null;
            if (theColumnIndex == 0 && theElement instanceof ClipboardPasteStatusRecord) {
                result = ClipboardPasteProblemDialog.this.getStatusImage((ClipboardPasteStatusRecord)theElement);
            }
            return result;
        }

        public String getColumnText(Object theElement, int theColumnIndex) {
            String result = null;
            if (theElement instanceof ClipboardPasteStatusRecord) {
                ClipboardPasteStatusRecord row = (ClipboardPasteStatusRecord)theElement;
                switch (theColumnIndex) {
                    case 1: {
                        result = row.getColumnName();
                        break;
                    }
                    case 2: {
                        result = row.getPasteData();
                        break;
                    }
                    case 3: {
                        result = row.getDescription();
                        break;
                    }
                    default: {
                        result = "";
                        break;
                    }
                }
            } else {
                result = super.getText(theElement);
            }
            return result;
        }
    }
}

