/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.ui.properties.ModelObjectPropertySourceProvider;
import org.teiid.designer.ui.table.EObjectPropertiesOrderPreferencesListener;
import org.teiid.designer.ui.table.PropertyOrder;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class EObjectPropertiesOrderPreferences
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map eObjectMap;
    private ModelObjectPropertySourceProvider propertySourceProvider;
    private final String newLine = "\n";
    private List listeners = new ArrayList();

    public EObjectPropertiesOrderPreferences() {
        this.eObjectMap = new HashMap();
    }

    public Set getInitializedEObjects() {
        return this.eObjectMap.keySet();
    }

    public void setProperty(String eObject, String property) {
        PropertyOrder columnOrder;
        TreeSet<PropertyOrder> propertiesSet = this.getOrderedPropertiesSet(eObject);
        if (propertiesSet == null) {
            propertiesSet = new TreeSet<PropertyOrder>();
            this.eObjectMap.put(eObject, propertiesSet);
        }
        if (!propertiesSet.contains(columnOrder = new PropertyOrder(property, propertiesSet.size() + 1))) {
            propertiesSet.add(columnOrder);
        }
    }

    private TreeSet getOrderedPropertiesSet(String eObjectName) {
        TreeSet propertyMap = (TreeSet)this.eObjectMap.get(eObjectName);
        return propertyMap;
    }

    public void replaceColumnsList(String eObject, ArrayList list) {
        TreeSet propertiesSet = this.getOrderedPropertiesSet(eObject);
        if (propertiesSet == null) {
            propertiesSet = new TreeSet();
            this.eObjectMap.put(eObject, propertiesSet);
        } else {
            propertiesSet.clear();
        }
        propertiesSet.addAll(list);
    }

    public void removeEObject(String eObject) {
        this.eObjectMap.remove(eObject);
    }

    public ArrayList getOrderedPropertyList(String eObject) {
        TreeSet propertiesSet = this.getOrderedPropertiesSet(eObject);
        ArrayList columns = propertiesSet == null ? new ArrayList() : new ArrayList(propertiesSet);
        Collections.sort(columns, new SortedPropertyOrderComparator());
        return columns;
    }

    public void addOrUpdateEObject(String eObject, EObject propertiesEObject) {
        IPropertySource propertySource = this.getPropertySource(propertiesEObject);
        IPropertyDescriptor[] propertyDescriptors = propertySource.getPropertyDescriptors();
        int size = propertyDescriptors.length;
        int i = 0;
        while (i < size) {
            this.setProperty(eObject, propertyDescriptors[i].getDisplayName());
            ++i;
        }
    }

    public void addOrUpdateProperty(String eObject, String column) {
        this.setProperty(eObject, column);
    }

    private IPropertySource getPropertySource(EObject modelObject) {
        if (this.propertySourceProvider == null) {
            this.propertySourceProvider = ModelUtilities.getPropertySourceProvider();
        }
        return this.propertySourceProvider.getPropertySource(modelObject);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String eObject : this.getInitializedEObjects()) {
            ArrayList properties = this.getOrderedPropertyList(eObject);
            if (properties.size() <= 0) continue;
            Iterator propertiesIterator = properties.iterator();
            while (propertiesIterator.hasNext()) {
                buffer.append(eObject);
                buffer.append("\n");
                PropertyOrder propertyOrder = (PropertyOrder)propertiesIterator.next();
                buffer.append(propertyOrder.getName());
                buffer.append("\n");
                buffer.append(propertyOrder.getOrder());
                buffer.append("\n");
                buffer.append(String.valueOf(propertyOrder.isVisible()));
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public void initializeFromString(String stringRep) {
        this.eObjectMap.clear();
        List lines = CoreStringUtil.split((String)stringRep, (String)"\n");
        int count = 0;
        while (count < lines.size()) {
            String eObject = (String)lines.get(count);
            String property = (String)lines.get(count + 1);
            String order = (String)lines.get(count + 2);
            String visible = (String)lines.get(count + 3);
            PropertyOrder propertyOrder = new PropertyOrder(property, Integer.parseInt(order));
            propertyOrder.setVisible(Boolean.valueOf(visible));
            TreeSet<PropertyOrder> columnSet = this.getOrderedPropertiesSet(eObject);
            if (columnSet == null) {
                columnSet = new TreeSet<PropertyOrder>();
                this.eObjectMap.put(eObject, columnSet);
            }
            columnSet.add(propertyOrder);
            count += 4;
        }
    }

    public void addEObjectPropertiesOrderPreferencesListener(EObjectPropertiesOrderPreferencesListener listener) {
        this.listeners.add(listener);
    }

    public void removeEObjectPropertiesOrderPreferencesListener(EObjectPropertiesOrderPreferencesListener listener) {
        this.listeners.remove(listener);
    }

    public void firePropertiesChanged(List changedEObjects) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((EObjectPropertiesOrderPreferencesListener)this.listeners.get(i)).propertiesChanged(changedEObjects);
            ++i;
        }
    }

    class SortedPropertyOrderComparator
    implements Comparator {
        SortedPropertyOrderComparator() {
        }

        public int compare(Object o1, Object o2) {
            int result = -1;
            if (o1 instanceof PropertyOrder & o2 instanceof PropertyOrder) {
                PropertyOrder p1 = (PropertyOrder)o1;
                PropertyOrder p2 = (PropertyOrder)o2;
                result = p1.getOrder() > p2.getOrder() ? 1 : (p1.getOrder() < p2.getOrder() ? -1 : p1.getName().compareTo(p2.getName()));
            }
            return result;
        }
    }
}

