/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.xsd.XSDFacet;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.table.EObjectPropertiesOrderPreferences;
import org.teiid.designer.ui.table.ModelObjectTableModel;
import org.teiid.designer.ui.table.ModelRowElement;
import org.teiid.designer.ui.table.ModelTableEditor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.wizards.NewModelWizard;

public class TableNotificationHandler
implements INotifyChangedListener,
UiConstants {
    private ModelTableEditor tableEditor;
    private Resource emfResource;
    private HashMap viewersByClass = new HashMap();
    private HashMap modelsByClass = new HashMap();
    private List excludedTypes = new ArrayList();
    private static final String EXTENDED_METACLASS_PREFIX = "extendedMetaclass:";

    TableNotificationHandler(ModelTableEditor editor) {
        this.tableEditor = editor;
        this.emfResource = editor.getEmfResource();
    }

    public void addTable(EClass eClass, TableViewer tableViewer, ModelObjectTableModel model) {
        this.viewersByClass.put(eClass, tableViewer);
        this.modelsByClass.put(eClass, model);
    }

    public void notifyChanged(Notification notification) {
        this.handleNotification(notification);
    }

    private boolean checkNotification(Notification notification) {
        EObject target = NotificationUtilities.getEObject((Notification)notification);
        if (target == null) {
            EObject[] children;
            if (NotificationUtilities.isAdded((Notification)notification)) {
                children = NotificationUtilities.getAddedChildren((Notification)notification);
                if (children != null && children.length > 0) {
                    target = children[0];
                }
            } else if (NotificationUtilities.isRemoved((Notification)notification) && (children = NotificationUtilities.getRemovedChildren((Notification)notification)) != null && children.length > 0) {
                target = children[0];
            }
        }
        if (target != null) {
            Resource resource = target.eResource();
            if (resource == null && NotificationUtilities.isRemoved((Notification)notification)) {
                Object notifier = notification.getNotifier();
                if (notifier instanceof Resource) {
                    resource = (Resource)notifier;
                } else if (notifier instanceof EObject) {
                    resource = notifier instanceof Annotation ? ((Annotation)notifier).getAnnotatedObject().eResource() : ((EObject)notifier).eResource();
                }
            }
            return resource != null && resource.equals(this.emfResource);
        }
        return false;
    }

    private void handleNotification(Notification notification) {
        if (notification instanceof SourcedNotification && ((SourcedNotification)notification).getSource() instanceof NewModelWizard) {
            return;
        }
        if (notification instanceof SourcedNotification) {
            Collection notifications = ((SourcedNotification)notification).getNotifications();
            Iterator iter = notifications.iterator();
            ArrayList<Notification> deleteNotificationsToProcess = new ArrayList<Notification>();
            ArrayList<Notification> nonDeleteNotificationsToProcess = new ArrayList<Notification>();
            while (iter.hasNext()) {
                Notification ntfTemp = (Notification)iter.next();
                if (!this.checkNotification(ntfTemp)) continue;
                if (NotificationUtilities.isRemoved((Notification)ntfTemp)) {
                    deleteNotificationsToProcess.add(ntfTemp);
                    continue;
                }
                nonDeleteNotificationsToProcess.add(ntfTemp);
            }
            if (nonDeleteNotificationsToProcess.size() > 0 || deleteNotificationsToProcess.size() > 0) {
                if (nonDeleteNotificationsToProcess.size() > 0) {
                    int i = nonDeleteNotificationsToProcess.size() - 1;
                    while (i >= 0) {
                        this.handleSingleNotification((Notification)nonDeleteNotificationsToProcess.get(i));
                        --i;
                    }
                }
                if (deleteNotificationsToProcess.size() > 0) {
                    int i = 0;
                    while (i < deleteNotificationsToProcess.size()) {
                        this.handleSingleNotification((Notification)deleteNotificationsToProcess.get(i));
                        ++i;
                    }
                }
            }
        } else if (this.checkNotification(notification)) {
            this.handleSingleNotification(notification);
        }
    }

    private void handleSingleNotification(Notification notification) {
        if (NotificationUtilities.isEObjectNotifier((Notification)notification)) {
            this.handleSingleEObjectNotification(notification);
        } else {
            this.handleSingleResourceNotification(notification);
        }
    }

    private void handleSingleEObjectNotification(Notification notification) {
        block13: {
            EObject target;
            block15: {
                block14: {
                    block12: {
                        target = NotificationUtilities.getEObject((Notification)notification);
                        if (target instanceof EStringToStringMapEntryImpl) {
                            target = target.eContainer();
                        }
                        if (!(target instanceof AnnotationContainer)) break block12;
                        this.refreshAnnotations((AnnotationContainer)target, notification);
                        break block13;
                    }
                    if (!(target instanceof Annotation)) break block14;
                    this.refreshAnnotation((Annotation)target, notification);
                    break block13;
                }
                if (!NotificationUtilities.isAdded((Notification)notification)) break block15;
                EObject[] addedChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                if (addedChildren == null || addedChildren.length <= 0) break block13;
                HashMap typeMap = this.sortObjectsByType(addedChildren);
                for (EClass eClass : typeMap.keySet()) {
                    ModelObjectTableModel model = (ModelObjectTableModel)this.modelsByClass.get(eClass);
                    if (model != null) {
                        model.addRows((ArrayList)typeMap.get(eClass));
                        continue;
                    }
                    EObject anObject = (EObject)((ArrayList)typeMap.get(eClass)).get(0);
                    MetamodelDescriptor descriptor = ModelerCore.getModelEditor().getMetamodelDescriptor(anObject);
                    if (descriptor == null || !descriptor.isPrimary() || anObject instanceof Resource.Diagnostic || !this.isObjectTypeAddable(anObject) || !this.tableEditor.canAddTable(anObject)) continue;
                    this.tableEditor.addTable(eClass, (ArrayList)typeMap.get(eClass));
                }
                break block13;
            }
            if (NotificationUtilities.isRemoved((Notification)notification)) {
                EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
                int i = 0;
                while (i < removedChildren.length) {
                    HashMap typeMap = this.sortObjectsByType(removedChildren);
                    for (EClass eClass : typeMap.keySet()) {
                        ModelObjectTableModel model = (ModelObjectTableModel)this.modelsByClass.get(eClass);
                        if (model == null) continue;
                        model.removeRows((ArrayList)typeMap.get(eClass));
                    }
                    ++i;
                }
            } else if (NotificationUtilities.isChanged((Notification)notification)) {
                Object[] kids;
                ModelObjectTableModel model;
                ModelRowElement row;
                TableViewer viewer = (TableViewer)this.viewersByClass.get(target.eClass());
                if (viewer != null && !viewer.getTable().isDisposed() && (row = (model = (ModelObjectTableModel)this.modelsByClass.get(target.eClass())).getRowElementForInstance(target)) != null) {
                    viewer.refresh((Object)row);
                }
                if ((kids = ModelUtilities.getModelContentProvider().getChildren((Object)target)) != null && kids.length > 0) {
                    int i = 0;
                    while (i < kids.length) {
                        ModelObjectTableModel model2;
                        ModelRowElement row2;
                        EClass childClass;
                        if (kids[i] instanceof EObject && (viewer = (TableViewer)this.viewersByClass.get(childClass = ((EObject)kids[i]).eClass())) != null && !viewer.getTable().isDisposed() && (row2 = (model2 = (ModelObjectTableModel)this.modelsByClass.get(childClass)).getRowElementForInstance((EObject)kids[i])) != null) {
                            viewer.refresh((Object)row2);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private boolean isObjectTypeAddable(Object theObject) {
        boolean result = false;
        Class<?> type = theObject.getClass();
        if (!this.excludedTypes.contains(type)) {
            if (theObject instanceof XSDFacet) {
                this.excludedTypes.add(type);
            } else {
                result = true;
            }
        }
        return result;
    }

    private void refreshAnnotations(AnnotationContainer theAnnotationContainer, Notification theNotification) {
        ModelObjectTableModel model;
        ModelRowElement row;
        TableViewer viewer;
        String key;
        EObject annotatedEObject = null;
        Annotation annotation = NotificationUtilities.isRemoved((Notification)theNotification) ? (Annotation)theNotification.getOldValue() : (Annotation)theNotification.getNewValue();
        annotatedEObject = annotation.getAnnotatedObject();
        if (annotatedEObject == null) {
            return;
        }
        boolean forceRefresh = false;
        if (annotatedEObject instanceof EStringToStringMapEntryImpl && (key = ((EStringToStringMapEntryImpl)annotatedEObject).getKey()).startsWith(EXTENDED_METACLASS_PREFIX)) {
            forceRefresh = true;
        }
        if ((viewer = (TableViewer)this.viewersByClass.get(annotatedEObject.eClass())) != null && !viewer.getTable().isDisposed() && (row = (model = (ModelObjectTableModel)this.modelsByClass.get(annotatedEObject.eClass())).getRowElementForInstance(annotatedEObject)) != null) {
            viewer.refresh((Object)row);
        }
        if (forceRefresh) {
            Set eClasses = this.viewersByClass.keySet();
            for (EClass eClass : eClasses) {
                TableViewer tViewer = (TableViewer)this.viewersByClass.get(eClass);
                if (tViewer.getTable().isDisposed()) continue;
                ModelObjectTableModel model2 = (ModelObjectTableModel)this.modelsByClass.get(eClass);
                model2.refreshProperties();
                EObjectPropertiesOrderPreferences modelTableColumnUtils = UiPlugin.getDefault().getEObjectPropertiesOrderPreferences();
                if (modelTableColumnUtils != null) {
                    modelTableColumnUtils.firePropertiesChanged(null);
                }
                tViewer.refresh();
            }
        }
    }

    private void refreshAnnotations(AnnotationContainer theAnnotationContainer) {
        EObject annotatedEObject = null;
        EList annotations = theAnnotationContainer.getAnnotations();
        for (Object next : annotations) {
            ModelObjectTableModel model;
            ModelRowElement row;
            if (next == null) break;
            annotatedEObject = ((Annotation)next).getAnnotatedObject();
            TableViewer viewer = (TableViewer)this.viewersByClass.get(annotatedEObject.eClass());
            if (viewer == null || viewer.getTable().isDisposed() || (row = (model = (ModelObjectTableModel)this.modelsByClass.get(annotatedEObject.eClass())).getRowElementForInstance(annotatedEObject)) == null) continue;
            viewer.refresh((Object)row);
        }
    }

    private void refreshAnnotation(Annotation annotation, Notification theNotification) {
        EObject annotatedEObject = annotation.getAnnotatedObject();
        if (annotatedEObject == null) {
            return;
        }
        TableViewer viewer = (TableViewer)this.viewersByClass.get(annotatedEObject.eClass());
        if (viewer != null && !viewer.getTable().isDisposed()) {
            ModelRowElement row;
            ModelObjectTableModel model = (ModelObjectTableModel)this.modelsByClass.get(annotatedEObject.eClass());
            model.refreshProperties();
            EObjectPropertiesOrderPreferences modelTableColumnUtils = UiPlugin.getDefault().getEObjectPropertiesOrderPreferences();
            if (modelTableColumnUtils != null) {
                modelTableColumnUtils.firePropertiesChanged(Collections.singletonList(annotatedEObject.eClass().getName()));
            }
            if ((row = model.getRowElementForInstance(annotatedEObject)) != null) {
                viewer.refresh((Object)row);
            }
        }
    }

    private void handleSingleResourceNotification(Notification notification) {
        block8: {
            EObject[] removedChildren;
            block7: {
                if (!NotificationUtilities.isAdded((Notification)notification)) break block7;
                EObject[] addedChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                if (addedChildren == null || addedChildren.length <= 0) break block8;
                if (addedChildren[0] instanceof AnnotationContainer) {
                    this.refreshAnnotations((AnnotationContainer)addedChildren[0]);
                } else {
                    HashMap typeMap = this.sortObjectsByType(addedChildren);
                    for (EClass eClass : typeMap.keySet()) {
                        ModelObjectTableModel model = (ModelObjectTableModel)this.modelsByClass.get(eClass);
                        if (model != null) {
                            model.addRows((ArrayList)typeMap.get(eClass));
                            continue;
                        }
                        EObject anObject = (EObject)((ArrayList)typeMap.get(eClass)).get(0);
                        MetamodelDescriptor descriptor = ModelerCore.getModelEditor().getMetamodelDescriptor(anObject);
                        if (descriptor == null || !descriptor.isPrimary() || !this.tableEditor.canAddTable(anObject)) continue;
                        this.tableEditor.addTable(eClass, (ArrayList)typeMap.get(eClass));
                    }
                }
                break block8;
            }
            if (NotificationUtilities.isRemoved((Notification)notification) && (removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification)) != null && removedChildren.length > 0) {
                int i = 0;
                while (i < removedChildren.length) {
                    HashMap typeMap = this.sortObjectsByType(removedChildren);
                    for (EClass eClass : typeMap.keySet()) {
                        ModelObjectTableModel model = (ModelObjectTableModel)this.modelsByClass.get(eClass);
                        if (model == null) continue;
                        model.removeRows((ArrayList)typeMap.get(eClass));
                    }
                    ++i;
                }
            }
        }
    }

    private HashMap sortObjectsByType(EObject[] objectArray) {
        HashMap result = new HashMap();
        int i = 0;
        while (i < objectArray.length) {
            this.loadObjectTypeMap(objectArray[i], result);
            ++i;
        }
        return result;
    }

    private void loadObjectTypeMap(EObject o, HashMap objectTypeMap) {
        if (o != null) {
            ArrayList<EObject> list = (ArrayList<EObject>)objectTypeMap.get(o.eClass());
            if (list == null) {
                list = new ArrayList<EObject>();
                objectTypeMap.put(o.eClass(), list);
            }
            list.add(o);
            Iterator iter = o.eContents().iterator();
            while (iter.hasNext()) {
                this.loadObjectTypeMap((EObject)iter.next(), objectTypeMap);
            }
        }
    }
}

