/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramContainer;
import org.teiid.designer.ui.util.ModelObjectNotificationHelper;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelObjectTreeViewerNotificationHandler
implements INotifyChangedListener {
    private TreeViewer treeViewer;
    private static int nNotifications = 0;

    public ModelObjectTreeViewerNotificationHandler(TreeViewer tv) {
        this.treeViewer = tv;
    }

    public void notifyChanged(final Notification notification) {
        if (!this.treeIsValid()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelObjectTreeViewerNotificationHandler.this.handleNotification(notification);
            }
        });
    }

    protected ModelObjectNotificationHelper handleNotification(Notification notification) {
        ModelObjectNotificationHelper notificationHelper = new ModelObjectNotificationHelper(notification);
        if (notificationHelper.shouldHandleNotification() && this.treeIsValid() && !notificationHelper.allChangesAreIgnorable()) {
            IResource nextResource;
            Iterator iter = notificationHelper.getAddOrRemoveTargets().iterator();
            EObject nextTarget2 = null;
            while (iter.hasNext()) {
                nextTarget2 = (EObject)iter.next();
                this.getTreeViewer().refresh((Object)nextTarget2);
                if (nextTarget2 instanceof XSDModelGroup) {
                    nextTarget2 = ((XSDModelGroup)nextTarget2).eContainer();
                    this.getTreeViewer().refresh((Object)nextTarget2);
                }
                if (!(nextTarget2.eContainer() instanceof XSDParticle)) continue;
                nextTarget2 = nextTarget2.eContainer();
                this.getTreeViewer().refresh((Object)nextTarget2);
            }
            for (EObject nextTarget2 : notificationHelper.getChangeTargets()) {
                this.getTreeViewer().refresh((Object)nextTarget2);
                if (nextTarget2 instanceof XSDModelGroup) {
                    nextTarget2 = ((XSDModelGroup)nextTarget2).eContainer();
                    this.getTreeViewer().refresh((Object)nextTarget2);
                }
                if (!(nextTarget2.eContainer() instanceof XSDParticle)) continue;
                nextTarget2 = nextTarget2.eContainer();
                this.getTreeViewer().refresh((Object)nextTarget2);
            }
            iter = notificationHelper.getLeftoverNotifications().iterator();
            while (iter.hasNext()) {
                this.handleSingleNotification((Notification)iter.next());
            }
            ArrayList<IResource> refreshedResources = new ArrayList<IResource>();
            if (!notificationHelper.getModifiedResources().isEmpty()) {
                iter = notificationHelper.getModifiedResources().iterator();
                nextResource = null;
                while (iter.hasNext()) {
                    nextResource = (IResource)iter.next();
                    this.getTreeViewer().refresh((Object)nextResource);
                    refreshedResources.add(nextResource);
                }
            }
            if (notificationHelper.getModelChildrenChanged()) {
                iter = notificationHelper.getChangeModels().iterator();
                nextResource = null;
                while (iter.hasNext()) {
                    nextResource = (IResource)iter.next();
                    if (refreshedResources.contains(nextResource)) continue;
                    this.getTreeViewer().refresh((Object)nextResource);
                }
            }
        }
        ++nNotifications;
        return notificationHelper;
    }

    public boolean shouldHandleNotification(Notification notification) {
        return true;
    }

    private void handleSingleNotification(Notification notification) {
        if (NotificationUtilities.isAdded((Notification)notification)) {
            this.performAdd(notification);
        } else if (NotificationUtilities.isRemoved((Notification)notification)) {
            this.performRemove(notification);
        } else if (NotificationUtilities.isChanged((Notification)notification)) {
            this.performChange(notification);
        }
    }

    private void performAdd(Notification notification) {
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject != null && targetObject instanceof EObject && this.treeIsValid() && targetObject instanceof DiagramContainer) {
            HashSet<EObject> refreshTargets = new HashSet<EObject>();
            EObject targetEObject = null;
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            int i = 0;
            while (i < newChildren.length) {
                targetEObject = ((Diagram)newChildren[i]).getTarget();
                if (targetEObject != null && !(targetEObject instanceof ModelAnnotation)) {
                    refreshTargets.add(targetEObject);
                }
                ++i;
            }
            this.refreshTree(refreshTargets);
        }
    }

    private void refreshTree(Collection objects) {
        for (Object nextObj : objects) {
            if (nextObj == null) continue;
            this.getTreeViewer().refresh(nextObj);
        }
    }

    private void performRemove(Notification notification) {
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject instanceof DiagramContainer) {
            HashSet<EObject> refreshTargets = new HashSet<EObject>();
            EObject targetEObject = null;
            EObject[] oldChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            int i = 0;
            while (i < oldChildren.length) {
                targetEObject = ((Diagram)oldChildren[i]).getTarget();
                if (targetEObject != null && !(targetEObject instanceof ModelAnnotation)) {
                    refreshTargets.add(targetEObject);
                }
                ++i;
            }
            this.refreshTree(refreshTargets);
        } else if (targetObject != null && targetObject instanceof EObject && this.treeIsValid()) {
            if (targetObject instanceof ModelAnnotation) {
                ITreeContentProvider cp = (ITreeContentProvider)this.treeViewer.getContentProvider();
                targetObject = cp.getParent(targetObject);
            }
            this.getTreeViewer().refresh(targetObject);
        }
    }

    private void performChange(Notification notification) {
        ModelResource modelResource;
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject instanceof Resource && ((modelResource = ModelUtilities.getModelResource((Resource)targetObject, false)) == null || modelResource.getModelProject().isOpen())) {
            return;
        }
        if (targetObject != null && targetObject instanceof EObject && this.treeIsValid()) {
            if (targetObject instanceof Diagram) {
                EObject targetEObject = ((Diagram)targetObject).getTarget();
                if (!(targetEObject instanceof ModelAnnotation)) {
                    this.getTreeViewer().refresh((Object)targetEObject);
                }
            } else {
                EObject parentObject = ((EObject)targetObject).eContainer();
                if (parentObject == null) {
                    if (!(targetObject instanceof ModelAnnotation)) {
                        this.getTreeViewer().refresh(null);
                    }
                } else {
                    this.getTreeViewer().refresh((Object)parentObject);
                }
            }
        }
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private boolean treeIsValid() {
        return this.getTreeViewer() != null && this.getTreeViewer().getTree() != null && !this.getTreeViewer().getTree().isDisposed();
    }
}

