/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.views;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.views.EditDescriptionDialog;
import org.teiid.designer.ui.views.ModelerView;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DescriptionView
extends ModelerView
implements ISelectionListener,
INotifyChangedListener,
IMenuListener,
ITextEditorExtension2 {
    private static final String DESCRIPTION_TXN_LABEL = UiConstants.Util.getString("DescriptionView.setDescriptionTransactionLabel", new Object[0]);
    private Object currentObject;
    private ModelResource currentModel;
    private StyledTextEditor textViewerPanel;
    private Action editDescriptionAction;
    private Action clearDescriptionAction;

    private void addListeners() {
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        ModelUtilities.addNotifyChangedListener(this);
        this.textViewerPanel.addMenuListener((IMenuListener)this);
    }

    void clear() {
        if (!this.textViewerPanel.isDisposed()) {
            this.setText("");
        }
    }

    private void clearDescription() {
        boolean cancelled = this.openEditorIfNeeded();
        if (!cancelled) {
            this.saveChangedObjectDescription("");
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.textViewerPanel = new StyledTextEditor(parent, 2626);
        this.textViewerPanel.setAllowCut(false);
        this.textViewerPanel.setAllowPaste(false);
        this.textViewerPanel.setAllowUndoRedo(false);
        this.textViewerPanel.setAllowFind(true);
        GridData tvGD = new GridData(1808);
        tvGD.horizontalSpan = 2;
        this.textViewerPanel.setLayoutData((Object)tvGD);
        this.textViewerPanel.setEditable(false);
        Color newColor = UiUtil.getSystemColor((int)22);
        this.textViewerPanel.getTextWidget().setBackground(newColor);
        this.contributeToActionBars();
        this.addListeners();
    }

    @Override
    public void dispose() {
        this.textViewerPanel.addMenuListener((IMenuListener)this);
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        workbenchWindow.getSelectionService().removeSelectionListener((ISelectionListener)this);
        ModelUtilities.removeNotifyChangedListener(this);
        this.textViewerPanel.dispose();
        super.dispose();
    }

    private void editDescription() {
        Shell shell;
        EditDescriptionDialog dialog;
        boolean cancelled = this.openEditorIfNeeded();
        if (!cancelled && (dialog = new EditDescriptionDialog(shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), this.getCurrentObjectName(), this.textViewerPanel.getText())).open() == 0) {
            String newDescription = dialog.getChangedDescription();
            this.saveChangedObjectDescription(newDescription);
            this.refresh();
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        this.editDescriptionAction = new Action(null){

            public void run() {
                DescriptionView.this.editDescription();
            }
        };
        this.editDescriptionAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/edit-document.png"));
        this.editDescriptionAction.setToolTipText(UiConstants.Util.getString("DescriptionView.edit.tooltip", new Object[0]));
        this.editDescriptionAction.setText(UiConstants.Util.getString("DescriptionView.edit.label", new Object[0]));
        manager.add((IAction)this.editDescriptionAction);
        this.clearDescriptionAction = new Action(null){

            public void run() {
                DescriptionView.this.clearDescription();
            }
        };
        this.clearDescriptionAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/clear-document.png"));
        this.clearDescriptionAction.setToolTipText(UiConstants.Util.getString("DescriptionView.clear.tooltip", new Object[0]));
        this.clearDescriptionAction.setText(UiConstants.Util.getString("DescriptionView.clear.label", new Object[0]));
        manager.add((IAction)this.clearDescriptionAction);
    }

    @Override
    public Object getAdapter(Class key) {
        if (key.equals(IFindReplaceTarget.class)) {
            return this.textViewerPanel.getTextViewer().getFindReplaceTarget();
        }
        return super.getAdapter(key);
    }

    String getCurrentObjectDescription() {
        if (this.currentObject instanceof EObject) {
            return ModelObjectUtilities.getDescription((EObject)this.currentObject);
        }
        if (this.currentObject instanceof ModelResource) {
            return ModelUtilities.getModelDescription(this.currentModel);
        }
        return null;
    }

    String getCurrentObjectName() {
        if (this.currentObject instanceof EObject) {
            return ModelerCore.getModelEditor().getName((EObject)this.currentObject);
        }
        if (this.currentObject instanceof ModelResource) {
            return this.currentModel.getItemName();
        }
        return null;
    }

    private boolean haveSameState(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return obj1 != null && obj2 != null;
        }
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private boolean isEditorOpen() {
        if (this.currentObject != null && this.currentModel != null) {
            IFile modelFile = (IFile)this.currentModel.getResource();
            return ModelEditorManager.isOpen(modelFile);
        }
        return false;
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.editDescriptionAction);
        manager.add((IAction)this.clearDescriptionAction);
    }

    public void notifyChanged(Notification notification) {
        boolean descriptionChanged = false;
        if (notification instanceof SourcedNotification) {
            Collection nList = ((SourcedNotification)notification).getNotifications();
            Notification nextNotification2 = null;
            EObject eObj = null;
            for (Notification nextNotification2 : nList) {
                block24: {
                    eObj = NotificationUtilities.getEObject((Notification)nextNotification2);
                    if (eObj == null) {
                        Resource resource = NotificationUtilities.getResource((Notification)nextNotification2);
                        if (resource != null && this.currentModel != null) {
                            try {
                                if (!this.currentModel.getEmfResource().equals(resource)) break block24;
                                descriptionChanged = true;
                                break;
                            }
                            catch (ModelWorkspaceException e) {
                                UiConstants.Util.log(4, (Throwable)e, ((Object)((Object)e)).getClass().getName());
                            }
                        }
                    } else if (eObj instanceof Annotation) {
                        EObject target = ((Annotation)eObj).getAnnotatedObject();
                        if (target != null && target.equals(this.currentObject)) {
                            descriptionChanged = true;
                            break;
                        }
                    } else if (eObj instanceof AnnotationContainer) {
                        EObject target;
                        if (NotificationUtilities.isAdded((Notification)nextNotification2)) {
                            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)nextNotification2);
                            int iChild = 0;
                            while (iChild < newChildren.length) {
                                if (newChildren[iChild] instanceof Annotation && (target = ((Annotation)newChildren[iChild]).getAnnotatedObject()) != null && target.equals(this.currentObject)) {
                                    descriptionChanged = true;
                                    break;
                                }
                                ++iChild;
                            }
                        } else if (NotificationUtilities.isRemoved((Notification)nextNotification2)) {
                            EObject[] oldChildren = NotificationUtilities.getRemovedChildren((Notification)nextNotification2);
                            int iChild = 0;
                            while (iChild < oldChildren.length) {
                                if (oldChildren[iChild] instanceof Annotation && (target = ((Annotation)oldChildren[iChild]).getAnnotatedObject()) != null && target.equals(this.currentObject)) {
                                    descriptionChanged = true;
                                    break;
                                }
                                ++iChild;
                            }
                        }
                    } else if (eObj instanceof ModelAnnotation && ((SourcedNotification)notification).getSource() == this) {
                        descriptionChanged = true;
                    }
                }
                if (!descriptionChanged) {
                    continue;
                }
                break;
            }
        } else {
            EObject target = NotificationUtilities.getEObject((Notification)notification);
            if (target instanceof Annotation && (target = ((Annotation)target).getAnnotatedObject()) != null && target.equals(this.currentObject)) {
                descriptionChanged = true;
            }
        }
        if (descriptionChanged) {
            this.refresh();
        }
    }

    private boolean openEditorIfNeeded() {
        boolean openEditorCancelled = false;
        if (this.currentModel != null && !this.isEditorOpen() && !this.currentModel.getResource().getResourceAttributes().isReadOnly()) {
            IFile modelFile = (IFile)this.currentModel.getResource();
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)ModelEditorManager.OPEN_EDITOR_TITLE, (String)ModelEditorManager.OPEN_EDITOR_MESSAGE)) {
                ModelEditorManager.openInEditMode(modelFile, true, 0);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DescriptionView.this.setFocus();
                    }
                });
            } else {
                openEditorCancelled = true;
            }
        }
        return openEditorCancelled;
    }

    void refresh() {
        Runnable work = new Runnable(){

            @Override
            public void run() {
                DescriptionView.this.setText(DescriptionView.this.getCurrentObjectDescription());
                DescriptionView.this.updateActions();
            }
        };
        UiUtil.runInSwtThread((Runnable)work, (boolean)true);
    }

    private void saveChangedObjectDescription(String changedDescription) {
        if (this.currentObject == null) {
            return;
        }
        String currentDescription = changedDescription;
        String savedDescription = null;
        if (this.currentObject instanceof EObject) {
            savedDescription = ModelObjectUtilities.getDescription((EObject)this.currentObject);
            if (!this.haveSameState(currentDescription, savedDescription)) {
                this.setDescription((EObject)this.currentObject, currentDescription, (Object)this);
            }
        } else if (this.currentObject instanceof ModelResource && !this.haveSameState(currentDescription, savedDescription = ModelUtilities.getModelDescription((ModelResource)this.currentObject))) {
            this.setDescription((ModelResource)this.currentObject, currentDescription, (Object)this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this && !(part instanceof PropertySheet)) {
            this.setCurrentObject(SelectionUtilities.getSelectedObject((ISelection)selection));
            this.updateActions();
        }
    }

    private void setCurrentObject(Object object) {
        this.currentObject = null;
        this.currentModel = null;
        try {
            if (object instanceof EObject) {
                EObject eObj = (EObject)object;
                if (ModelObjectUtilities.supportsDescription(eObj)) {
                    this.currentObject = object;
                    this.currentModel = ModelUtilities.getModelResourceForModelObject(eObj);
                }
            } else if (object instanceof IFile && ModelUtilities.supportsModelDescription((IResource)object)) {
                this.currentModel = ModelUtil.getModelResource((IFile)((IFile)object), (boolean)false);
                this.currentObject = this.currentModel;
            }
        }
        catch (Exception e) {
            UiConstants.Util.log(4, (Throwable)e, e.getClass().getName());
        }
        this.refresh();
    }

    private void setDescription(EObject eObject, String description, Object eventSource) {
        block13: {
            if (!ModelObjectUtilities.isReadOnly(eObject)) {
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)DESCRIPTION_TXN_LABEL, (Object)eventSource);
                boolean succeeded = false;
                try {
                    try {
                        if (eObject.eResource() instanceof XSDResourceImpl) {
                            if (eObject instanceof XSDConcreteComponent) {
                                XsdUtil.addUserInfoAttribute((XSDConcreteComponent)((XSDConcreteComponent)eObject), (String)description);
                            }
                        } else {
                            ModelerCore.getModelEditor().setDescription(eObject, description);
                        }
                        succeeded = true;
                    }
                    catch (ModelerCoreException ex) {
                        String message = UiConstants.Util.getString("DescriptionView.errorSetDescription", (Object)eObject.toString());
                        UiConstants.Util.log(4, (Throwable)ex, message);
                        if (!requiredStart) break block13;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block13;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private void setDescription(ModelResource modelResource, String description, Object eventSource) {
        block12: {
            if (!ModelUtilities.isReadOnly(modelResource)) {
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)DESCRIPTION_TXN_LABEL, (Object)eventSource);
                boolean succeeded = false;
                try {
                    try {
                        ModelAnnotation annotation = modelResource.getModelAnnotation();
                        if (annotation != null) {
                            annotation.setDescription(description);
                        } else {
                            String message = UiConstants.Util.getString("DescriptionView.nullModelAnnotation", (Object)modelResource.getPath().toString());
                            UiConstants.Util.log(4, message);
                        }
                        succeeded = true;
                    }
                    catch (ModelWorkspaceException ex) {
                        String message = UiConstants.Util.getString("DescriptionView.errorSetDescriptionModel", (Object)modelResource.toString());
                        UiConstants.Util.log(4, (Throwable)ex, message);
                        if (!requiredStart) break block12;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block12;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    void setText(String newDescription) {
        if (!this.textViewerPanel.isDisposed()) {
            String newText;
            String string = newText = newDescription == null ? "" : newDescription;
            if (!newText.equals(this.textViewerPanel.getText())) {
                this.textViewerPanel.setText(newText);
            }
        }
    }

    void updateActions() {
        boolean enable = true;
        if (this.currentModel != null) {
            enable = !this.currentModel.isReadOnly();
        } else if (this.currentObject == null) {
            enable = false;
        }
        if (enable && this.currentObject instanceof DiagramProxy) {
            enable = false;
        }
        this.editDescriptionAction.setEnabled(enable);
        this.clearDescriptionAction.setEnabled(enable);
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public boolean validateEditorInputState() {
        return false;
    }

    public void setFocus() {
    }
}

