/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.views;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;

public class EditDescriptionDialog
extends Dialog
implements KeyListener {
    private static final String TITLE = UiConstants.Util.getString("EditDescriptionDialog.title.prefix", new Object[0]);
    private static final String DESRIPTION_TEXT = String.valueOf(' ') + UiConstants.Util.getString("EditDescriptionDialog.description.text", new Object[0]) + ' ';
    private StyledTextEditor textEditor;
    private String currentDescription = "";
    private String changedDescription = "";
    private boolean changed;

    public EditDescriptionDialog(Shell shell, String objectName, String currentDescription) {
        super(shell, String.valueOf(TITLE) + ' ' + objectName);
        this.currentDescription = currentDescription;
        this.changedDescription = currentDescription;
        this.changed = false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgPanel = (Composite)super.createDialogArea(parent);
        Group descGroup = WidgetFactory.createGroup((Composite)dlgPanel, (String)DESRIPTION_TEXT, (int)0);
        descGroup.setLayoutData((Object)new GridData(1808));
        Composite innerPanel = new Composite((Composite)descGroup, 0);
        innerPanel.setLayout((Layout)new GridLayout());
        GridData pgd = new GridData(1808);
        pgd.minimumWidth = 400;
        pgd.minimumHeight = 400;
        pgd.grabExcessVerticalSpace = true;
        pgd.grabExcessHorizontalSpace = true;
        innerPanel.setLayoutData((Object)pgd);
        this.textEditor = new StyledTextEditor(innerPanel, 2818);
        GridData gdt = new GridData(1808);
        gdt.widthHint = 400;
        gdt.heightHint = 400;
        this.textEditor.setLayoutData((Object)gdt);
        this.textEditor.setEditable(true);
        this.textEditor.setAllowFind(false);
        this.textEditor.getTextWidget().setWordWrap(true);
        this.textEditor.setText(this.currentDescription);
        this.textEditor.getTextWidget().addKeyListener((KeyListener)this);
        return dlgPanel;
    }

    protected Control createContents(Composite parent) {
        Control superControl = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return superControl;
    }

    public String getChangedDescription() {
        return this.changedDescription;
    }

    public boolean descriptionChanged() {
        return this.changed && this.changedDescription.equals(this.currentDescription);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.changedDescription = this.textEditor.getText();
        this.changed = true;
        this.getButton(0).setEnabled(true);
    }
}

