/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DatatypeHierarchyTreeViewer
extends TreeViewer {
    public DatatypeHierarchyTreeViewer(Composite parent) {
        this(parent, 2);
    }

    public DatatypeHierarchyTreeViewer(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200);
        this.setContentProvider((IContentProvider)new DatatypeTreeContentProvider());
        this.setLabelProvider((IBaseLabelProvider)ModelUtilities.getEMFLabelProvider());
        super.setInput((Object)Collections.EMPTY_LIST);
    }

    public DatatypeHierarchyTreeViewer(Composite parent, int style, EObject selectedDatatype) {
        this(parent, style);
        ArrayList<EObject> list = new ArrayList<EObject>(1);
        list.add(selectedDatatype);
        super.setInput(list);
    }

    class DatatypeTreeContentProvider
    implements ITreeContentProvider {
        private DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = new Object[]{};
            try {
                result = this.datatypeManager.getSubtypes((EObject)parentElement);
            }
            catch (ModelerCoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
            return result;
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = new Object[1];
            try {
                result[0] = this.datatypeManager.getAnySimpleType();
            }
            catch (ModelerCoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
            return result;
        }

        public Object getParent(Object element) {
            return this.datatypeManager.getBaseType((EObject)element);
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

