/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.filter.StructuredViewerDatatypeFilterer;
import org.teiid.designer.ui.filter.StructuredViewerTextFilterer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DatatypeSelectionDialog
extends ListDialog
implements UiConstants {
    private static final String PREFIX = "DatatypeSelectionDialog.";
    private static final String STRING_STRING = "string";
    private static final String ONE_SPACE = " ";
    private static final String BUILT_IN = DatatypeSelectionDialog.getString("builtInLabel");
    private static final String PATH_GROUP_TITLE = DatatypeSelectionDialog.getString("pathGroupLabel");
    private static final String EMPTY_STRING = "";
    private Spinner ispin = null;
    private int MIN = 0;
    private int MAX = 99999;
    private boolean editLength = false;
    boolean setLengthForAll = false;
    private boolean multipleObjects = false;
    private int initialLength;
    private int currentLength = this.initialLength = 0;
    Button setLengthForAllCheckBox;
    CLabel pathLabel;
    private StructuredViewerDatatypeFilterer entFilter;
    private String originalMessage;

    private static String getString(String key) {
        return UiConstants.Util.getString(PREFIX + key, new Object[0]);
    }

    private static String getString(String key, Object obj) {
        return UiConstants.Util.getString(PREFIX + key, obj);
    }

    public DatatypeSelectionDialog(Shell parent) {
        this(parent, null);
    }

    public DatatypeSelectionDialog(Shell parent, final EObject objectForType) {
        super(parent);
        this.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] result = new Object[]{};
                try {
                    DatatypeManager dtmgr = ModelerCore.getDatatypeManager((EObject)objectForType, (boolean)true);
                    ArrayList<EObject> tmp = new ArrayList<EObject>(Arrays.asList(dtmgr.getAllDatatypes()));
                    DatatypeSelectionDialog.this.removeUrTypesFromList(tmp, dtmgr);
                    result = tmp.toArray();
                }
                catch (ModelerCoreException e) {
                    Util.log((Throwable)e);
                }
                return result;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer v, Object o, Object o2) {
            }
        });
        this.setLabelProvider(ModelUtilities.getEMFLabelProvider());
        this.setAddCancelButton(true);
        this.setTitle(DatatypeSelectionDialog.getString("selectDatatypeTitle"));
        String msg = objectForType == null ? DatatypeSelectionDialog.getString("selectDatatypeMessageNoObject") : DatatypeSelectionDialog.getString("selectDatatypeMessage", objectForType.eClass().getName());
        this.setMessage(msg);
        this.setInput(Collections.EMPTY_LIST);
        this.initFilter();
    }

    public DatatypeSelectionDialog(Shell parent, final EObject objectForType, final EStructuralFeature feature) {
        super(parent);
        this.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] result = new Object[]{};
                try {
                    DatatypeManager dtmgr = ModelerCore.getDatatypeManager((EObject)objectForType, (boolean)true);
                    ArrayList<EObject> tmp = new ArrayList<EObject>(Arrays.asList(dtmgr.getAllowableTypeValues(objectForType, feature)));
                    DatatypeSelectionDialog.this.removeUrTypesFromList(tmp, dtmgr);
                    result = tmp.toArray();
                }
                catch (ModelerCoreException e) {
                    UiConstants.Util.log((Throwable)e);
                }
                return result;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer v, Object o, Object o2) {
            }
        });
        this.setLabelProvider(ModelUtilities.getEMFLabelProvider());
        this.setAddCancelButton(true);
        this.setTitle(DatatypeSelectionDialog.getString("selectDatatypeTitle"));
        this.setMessage(DatatypeSelectionDialog.getString("selectDatatypeMessage", objectForType.eClass().getName()));
        this.setInput(Collections.EMPTY_LIST);
        this.initFilter();
    }

    void removeUrTypesFromList(List types, DatatypeManager dtmgr) {
        try {
            Iterator i = types.iterator();
            while (i.hasNext()) {
                EObject eObj = (EObject)i.next();
                if (dtmgr.getAnySimpleType() == eObj || dtmgr.getAnyType() == eObj) {
                    i.remove();
                    continue;
                }
                String name = ModelerCore.getModelEditor().getName(eObj);
                if (!name.equalsIgnoreCase("integer")) continue;
                i.remove();
            }
        }
        catch (ModelerCoreException e) {
            UiConstants.Util.log((Throwable)e);
        }
    }

    public DatatypeSelectionDialog(Shell parent, final EObject objectForType, String runtimeTypeName) {
        super(parent);
        this.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] result = new Object[]{};
                try {
                    DatatypeManager dtmgr = ModelerCore.getDatatypeManager((EObject)objectForType, (boolean)true);
                    ArrayList<EObject> tmp = new ArrayList<EObject>(Arrays.asList(dtmgr.getAllDatatypes()));
                    DatatypeSelectionDialog.this.removeUrTypesFromList(tmp, dtmgr);
                    result = tmp.toArray();
                }
                catch (ModelerCoreException e) {
                    UiConstants.Util.log((Throwable)e);
                }
                return result;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer v, Object o, Object o2) {
            }
        });
        this.setLabelProvider(ModelUtilities.getEMFLabelProvider());
        this.setAddCancelButton(true);
        this.setTitle(DatatypeSelectionDialog.getString("selectDatatypeTitle"));
        this.setMessage(DatatypeSelectionDialog.getString("selectDatatypeMessage", objectForType.eClass().getName()));
        this.setInput(Collections.EMPTY_LIST);
        this.initFilter();
    }

    private void initFilter() {
        this.entFilter = new StructuredViewerDatatypeFilterer();
        this.entFilter.setDelayTime(100);
        this.setAllowSimple(false);
    }

    public void setAllowSimple(boolean allow) {
        this.entFilter.setAllowSimple(allow);
        if (!allow) {
            this.originalMessage = this.getMessage();
            this.setMessage(String.valueOf(this.originalMessage) + DatatypeSelectionDialog.getString("simpleHiddenMessage"));
        } else if (this.originalMessage != null) {
            this.setMessage(this.originalMessage);
        }
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        }
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                DatatypeSelectionDialog.this.getOkButton().setEnabled(!DatatypeSelectionDialog.this.getTableViewer().getSelection().isEmpty());
                DatatypeSelectionDialog.this.updateSpinner(DatatypeSelectionDialog.this.getTableViewer().getSelection());
                EObject eObj = SelectionUtilities.getSelectedEObject((ISelection)theEvent.getSelection());
                DatatypeSelectionDialog.this.pathLabel.setText(eObj == null ? DatatypeSelectionDialog.EMPTY_STRING : DatatypeSelectionDialog.this.constructPath(eObj));
            }
        });
        this.updateSpinner(this.getTableViewer().getSelection());
    }

    protected Label createMessageArea(Composite composite) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.setLengthForAll = !this.multipleObjects;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        super.createMessageArea(composite);
        StructuredViewerTextFilterer textFilter = new StructuredViewerTextFilterer(StructuredViewerTextFilterer.DEFAULT_PROMPT, StructuredViewerTextFilterer.DEFAULT_CLEAR, (ILabelProvider)new DatatypeLabelProvider(0));
        textFilter.setDelayTime(50);
        Control filterCtrl = textFilter.addControl(composite);
        GridData gd = new GridData(4, 4, true, false);
        gd.verticalIndent = 5;
        filterCtrl.setLayoutData((Object)gd);
        filterCtrl = this.entFilter.addControl(composite);
        gd = new GridData(4, 4, true, false);
        filterCtrl.setLayoutData((Object)gd);
        Composite superComp = (Composite)super.createDialogArea(composite);
        layout = (GridLayout)superComp.getLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 0;
        TableViewer tableViewer = this.getTableViewer();
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo(tableViewer.getControl());
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 16384);
        column.getColumn().setText("Design-time Type");
        column.setLabelProvider((CellLabelProvider)new DatatypeLabelProvider(0));
        column.getColumn().setWidth(140);
        column = new TableViewerColumn(tableViewer, 16384);
        column.getColumn().setText("Run-time Type          ");
        column.setLabelProvider((CellLabelProvider)new DatatypeLabelProvider(1));
        column.getColumn().setWidth(140);
        column = new TableViewerColumn(tableViewer, 16384);
        column.getColumn().setText("Base Type                        ");
        column.setLabelProvider((CellLabelProvider)new DatatypeLabelProvider(2));
        column.getColumn().setWidth(140);
        textFilter.attachToViewer((StructuredViewer)tableViewer, true);
        this.entFilter.attachToViewer((StructuredViewer)tableViewer, true);
        if (this.editLength) {
            Group lengthGroup = WidgetFactory.createGroup((Composite)composite, (String)DatatypeSelectionDialog.getString("lengthOptions"), (int)768, (int)1, (int)2);
            WidgetFactory.createLabel((Composite)lengthGroup, (int)4, (String)DatatypeSelectionDialog.getString("stringLengthLabel"));
            this.ispin = new Spinner((Composite)lengthGroup, 2048);
            this.ispin.setMinimum(this.MIN);
            this.ispin.setMaximum(this.MAX);
            this.ispin.setToolTipText(UiConstants.Util.getString("DatatypeSelectionDialog.lengthSpinner.toolTip", new Object[]{this.ispin.getMinimum(), this.ispin.getMaximum()}));
            this.ispin.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent theEvent) {
                    DatatypeSelectionDialog.this.setLength();
                }
            });
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 2;
            gridData2.widthHint = 100;
            this.ispin.setLayoutData((Object)gridData2);
            this.ispin.setSelection(this.initialLength);
            this.ispin.setEnabled(true);
            if (this.multipleObjects) {
                this.setLengthForAllCheckBox = WidgetFactory.createCheckBox((Composite)lengthGroup, (String)DatatypeSelectionDialog.getString("setLengthForAll"), (int)4, (int)2, (boolean)this.setLengthForAll);
                this.setLengthForAllCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent ev) {
                        DatatypeSelectionDialog.this.setLengthForAll = DatatypeSelectionDialog.this.setLengthForAllCheckBox.getSelection();
                    }
                });
                this.editLength = this.setLengthForAllCheckBox.getSelection();
            } else {
                this.setLengthForAll = true;
            }
        }
        Group group = WidgetFactory.createGroup((Composite)composite, (String)PATH_GROUP_TITLE, (int)1808);
        this.pathLabel = new CLabel((Composite)group, 0);
        this.pathLabel.setFont(composite.getFont());
        this.pathLabel.setLayoutData((Object)new GridData(768));
        List initialSelections = this.getInitialElementSelections();
        if (initialSelections != null && !initialSelections.isEmpty() && initialSelections.get(0) instanceof EObject) {
            this.pathLabel.setText(this.constructPath((EObject)initialSelections.get(0)));
        }
        return composite;
    }

    void setLength() {
        this.currentLength = this.ispin.getSelection();
    }

    public int getLength() {
        return this.currentLength;
    }

    public void setInitialLength(int newLength) {
        this.initialLength = newLength;
    }

    public void setEditLength(boolean editLength) {
        this.editLength = editLength;
    }

    void updateSpinner(ISelection selection) {
        if (this.ispin != null) {
            boolean enable = false;
            Object result = SelectionUtilities.getSelectedObject((ISelection)selection);
            if (this.typeIsString(result)) {
                enable = true;
            }
            this.ispin.setEnabled(enable);
            if (this.setLengthForAllCheckBox != null) {
                this.setLengthForAllCheckBox.setEnabled(enable);
            }
        }
    }

    private boolean typeIsString(Object type) {
        String simpleType;
        return type != null && type instanceof XSDSimpleTypeDefinition && (simpleType = ModelerCore.getWorkspaceDatatypeManager().getRuntimeTypeName((EObject)type)).equalsIgnoreCase(STRING_STRING);
    }

    String constructPath(EObject eo) {
        String sPath;
        IPath result = null;
        if (this.isBuiltin(eo)) {
            sPath = String.valueOf(BUILT_IN) + ONE_SPACE + ModelerCore.getModelEditor().getName(eo);
        } else if (ModelUtil.isXsdFile((Resource)eo.eResource())) {
            result = ModelerCore.getModelEditor().getModelRelativePath(eo);
            sPath = result.toString();
        } else {
            result = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(eo);
            sPath = result.toString();
        }
        return sPath;
    }

    private boolean isBuiltin(EObject eo) {
        boolean bResult = false;
        if (eo instanceof XSDSimpleTypeDefinition) {
            try {
                bResult = ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype(eo);
            }
            catch (Exception exception) {
                bResult = false;
            }
        }
        return bResult;
    }

    public void setMultipleObjects(boolean theMultipleObjects) {
        this.multipleObjects = theMultipleObjects;
    }

    public boolean overrideAllLengths() {
        return this.setLengthForAll;
    }

    class DatatypeLabelProvider
    extends ColumnLabelProvider {
        private final DatatypeManager datatypeManager = ModelerCore.getBuiltInTypesManager();
        private final int columnNumber;

        public DatatypeLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof EObject) {
                switch (this.columnNumber) {
                    case 0: {
                        String name = this.getDesignTimeTypeName((EObject)element);
                        if (name.equalsIgnoreCase("integer")) {
                            name = String.valueOf(name) + " <deprecated>";
                        }
                        return name;
                    }
                    case 1: {
                        String name = ModelerCore.getModelEditor().getName((EObject)element);
                        EObject designTimeType = null;
                        try {
                            designTimeType = this.datatypeManager.getBuiltInDatatype(name);
                        }
                        catch (ModelerCoreException modelerCoreException) {}
                        if (designTimeType == null) break;
                        String runtimeTypename = this.datatypeManager.getRuntimeTypeName(designTimeType);
                        return runtimeTypename;
                    }
                    case 2: {
                        return this.getBaseTypeName((EObject)element);
                    }
                }
            }
            return DatatypeSelectionDialog.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return ModelUtilities.getEMFLabelProvider().getImage(element);
            }
            return null;
        }

        private String getDesignTimeTypeName(EObject eObject) {
            String rawName = ModelUtilities.getEMFLabelProvider().getText((Object)eObject);
            int colonIndex = rawName.indexOf(58);
            if (colonIndex == -1) {
                return rawName;
            }
            return rawName.substring(0, colonIndex).trim();
        }

        private String getBaseTypeName(EObject eObject) {
            String rawName = ModelUtilities.getEMFLabelProvider().getText((Object)eObject);
            int colonIndex = rawName.indexOf(58);
            int fullLength = rawName.length();
            if (colonIndex == -1) {
                return rawName;
            }
            return rawName.substring(colonIndex + 1, fullLength).trim();
        }
    }
}

