/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class DatatypeUtilities {
    private static final String COLON = ":";
    private static final String RIGHT_PARENTH = ")";
    private static final String LEFT_PARENTH = "(";

    public static boolean setColumnSignature(EObject eObject, String newSignature) throws ModelerCoreException {
        MetamodelAspect mmAspect = ModelObjectUtilities.getSqlAspect(eObject);
        if (mmAspect instanceof SqlColumnAspect) {
            int index = newSignature.lastIndexOf(COLON);
            boolean canSetLength = ((SqlColumnAspect)mmAspect).canSetLength();
            if (index > 0) {
                String fullDatatype;
                SqlColumnAspect sqAspect = (SqlColumnAspect)mmAspect;
                String newName = newSignature.substring(0, index).trim();
                if ((fullDatatype = newSignature.substring(++index).trim()).length() > 0 && fullDatatype.toUpperCase().startsWith("STRING(")) {
                    EObject dType;
                    String dTypeString = null;
                    int indexLeft = fullDatatype.indexOf(LEFT_PARENTH);
                    int indexRight = fullDatatype.indexOf(RIGHT_PARENTH);
                    dTypeString = indexLeft > 0 ? fullDatatype.substring(0, indexLeft).trim() : fullDatatype.trim();
                    if (indexRight > 0 && canSetLength) {
                        String lengthString = fullDatatype.substring(indexLeft + 1, indexRight).trim();
                        int length = -1;
                        try {
                            length = Integer.parseInt(lengthString);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (length >= 0) {
                            sqAspect.setLength(eObject, length);
                        }
                    }
                    if (sqAspect.canSetDatatype() && dTypeString != null && dTypeString.length() > 0 && (dType = DatatypeUtilities.getDatatype(dTypeString)) != null) {
                        sqAspect.setDatatype(eObject, dType);
                    }
                } else {
                    EObject dType = DatatypeUtilities.getDatatype(fullDatatype);
                    if (dType != null) {
                        sqAspect.setDatatype(eObject, dType);
                    } else {
                        newName = String.valueOf(newName) + COLON + fullDatatype;
                    }
                }
                ModelerCore.getModelEditor().rename(eObject, newName);
                return true;
            }
            String newName = newSignature.trim();
            ModelerCore.getModelEditor().rename(eObject, newName);
            return true;
        }
        return false;
    }

    public static boolean setParameterSignature(EObject eObject, String newSignature) throws ModelerCoreException {
        MetamodelAspect mmAspect = ModelObjectUtilities.getSqlAspect(eObject);
        if (mmAspect instanceof SqlProcedureParameterAspect) {
            int index = newSignature.indexOf(COLON);
            boolean canSetLength = ((SqlProcedureParameterAspect)mmAspect).canSetLength();
            if (index > 0) {
                String fullDatatype;
                SqlProcedureParameterAspect sppAspect = (SqlProcedureParameterAspect)mmAspect;
                String newName = newSignature.substring(0, index).trim();
                if ((fullDatatype = newSignature.substring(++index)).length() > 0) {
                    EObject dType;
                    String dTypeString = null;
                    int indexLeft = fullDatatype.indexOf(LEFT_PARENTH);
                    int indexRight = fullDatatype.indexOf(RIGHT_PARENTH);
                    dTypeString = indexLeft > 0 ? fullDatatype.substring(0, indexLeft).trim() : fullDatatype.trim();
                    if (indexRight > 0 && canSetLength) {
                        String lengthString = fullDatatype.substring(indexLeft + 1, indexRight).trim();
                        int length = -1;
                        try {
                            length = Integer.parseInt(lengthString);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (length >= 0) {
                            sppAspect.setLength(eObject, length);
                        }
                    }
                    if (sppAspect.canSetDatatype() && dTypeString != null && dTypeString.length() > 0 && (dType = DatatypeUtilities.getDatatype(dTypeString)) != null) {
                        sppAspect.setDatatype(eObject, dType);
                    }
                }
                ModelerCore.getModelEditor().rename(eObject, newName);
                return true;
            }
            String newName = newSignature.trim();
            ModelerCore.getModelEditor().rename(eObject, newName);
            return true;
        }
        return false;
    }

    public static EObject getDatatype(String datatype) throws ModelerCoreException {
        EObject[] result = ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
        String dtName = null;
        int i = 0;
        while (i < result.length) {
            dtName = ModelerCore.getWorkspaceDatatypeManager().getName(result[i]);
            if (dtName != null && dtName.equals(datatype)) {
                return result[i];
            }
            ++i;
        }
        return null;
    }

    public static String getRuntimeTypeName(String datatype) throws ModelerCoreException {
        EObject theDataType;
        String dType = datatype.toLowerCase();
        if (dType.equalsIgnoreCase("int")) {
            dType = "integer".toLowerCase();
        }
        if ((theDataType = DatatypeUtilities.getDatatype(dType)) == null) {
            return datatype;
        }
        return ModelerCore.getWorkspaceDatatypeManager().getRuntimeTypeName(theDataType);
    }

    public static boolean renameSqlColumn(EObject newEObject, String newName) throws ModelerCoreException {
        MetamodelAspect mmAspect = ModelObjectUtilities.getSqlAspect(newEObject);
        if (mmAspect instanceof SqlColumnAspect) {
            if (newName != null && newName.length() > 0) {
                DatatypeUtilities.setColumnSignature(newEObject, newName);
            }
            return true;
        }
        if (mmAspect instanceof SqlProcedureParameterAspect) {
            if (newName != null && newName.length() > 0) {
                DatatypeUtilities.setParameterSignature(newEObject, newName);
            }
            return true;
        }
        return false;
    }

    public static EObject getSqlColumnDatatype(EObject eObject) {
        MetamodelAspect mmAspect = ModelObjectUtilities.getSqlAspect(eObject);
        if (mmAspect instanceof SqlColumnAspect) {
            SqlColumnAspect sqAspect = (SqlColumnAspect)mmAspect;
            return sqAspect.getDatatype(eObject);
        }
        return null;
    }

    public static EObject getSqlParameterDatatype(EObject eObject) {
        MetamodelAspect mmAspect = ModelObjectUtilities.getSqlAspect(eObject);
        if (mmAspect instanceof SqlProcedureParameterAspect) {
            SqlProcedureParameterAspect sqAspect = (SqlProcedureParameterAspect)mmAspect;
            return sqAspect.getDatatype(eObject);
        }
        return null;
    }

    public static EObject getSqlDatatype(EObject eObject) {
        if (eObject instanceof Column) {
            return DatatypeUtilities.getSqlColumnDatatype(eObject);
        }
        if (eObject instanceof ProcedureParameter) {
            return DatatypeUtilities.getSqlParameterDatatype(eObject);
        }
        return null;
    }

    public static boolean canSetLength(EObject eObject, int length) {
        String typeName;
        EObject datatype = DatatypeUtilities.getSqlDatatype(eObject);
        if (datatype != null && (typeName = ModelerCore.getWorkspaceDatatypeManager().getRuntimeTypeName(datatype)) != null && typeName.equals("char")) {
            return length == 1;
        }
        return true;
    }

    public static String getDesignTimeTypeName(EObject eObject) {
        String rawName = ModelUtilities.getEMFLabelProvider().getText((Object)eObject);
        int colonIndex = rawName.indexOf(58);
        if (colonIndex == -1) {
            return rawName;
        }
        return rawName.substring(0, colonIndex).trim();
    }

    public static Collection<String> getAllDesignTimeTypeNames() throws ModelerCoreException {
        EObject[] types = ModelerCore.getWorkspaceDatatypeManager().getBuiltInDatatypes();
        ArrayList<String> names = new ArrayList<String>();
        EObject[] eObjectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            EObject type = eObjectArray[n2];
            String name = DatatypeUtilities.getDesignTimeTypeName(type);
            if (name != null && !name.equalsIgnoreCase("integer")) {
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    public static boolean isNumeric(String type) {
        return "bigdecimal".equalsIgnoreCase(type) || "biginteger".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type) || "long".equalsIgnoreCase(type) || "short".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type) || "decimal".equalsIgnoreCase(type);
    }
}

