/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DesignerProperties
extends Properties
implements StringConstants {
    private static final long serialVersionUID = 1L;

    public DesignerProperties(String guideID) {
        this.setProperty("guideID", guideID);
    }

    public String getGuideID() {
        return this.getProperty("guideID");
    }

    @Override
    public synchronized void clear() {
        String guideID = this.getGuideID();
        super.clear();
        this.setGuideID(guideID);
    }

    public String getProjectName() {
        return this.getProperty("projectName");
    }

    public String getVdbName() {
        return this.getProperty("lastVdbName");
    }

    public String getVdbJndiName() {
        return this.getProperty("vdbJndiName");
    }

    public String getSourceModelName() {
        return this.getProperty("lastSourceModelName");
    }

    public String getViewModelName() {
        return this.getProperty("lastViewModelName");
    }

    public String getConnectionProfileName() {
        return this.getProperty("lastConnectionProfileId");
    }

    public String getSourcesFolderName() {
        return this.getProperty("sourcesFolder");
    }

    public String getViewsFolderName() {
        return this.getProperty("viewsFolder");
    }

    public String getSchemaFolderName() {
        return this.getProperty("schemaFolder");
    }

    public String getWebServiceFolderName() {
        return this.getProperty("wsFolder");
    }

    public String getPreviewTargetObjectName() {
        return this.getProperty("previewTargetObject");
    }

    public String getPreviewTargetModelName() {
        return this.getProperty("previewTargetModel");
    }

    public String getLastSourceModelObjectName() {
        return this.getProperty("lastSourceModelObjectName");
    }

    public String getLastViewModelObjectName() {
        return this.getProperty("lastViewModelObjectName");
    }

    public boolean isImportXmlRemote() {
        String value = this.getProperty("xmlImportType");
        return value != null && value.equalsIgnoreCase("remote");
    }

    public void setGuideID(String ID) {
        this.put("guideID", ID);
    }

    public void setProjectName(String projectName) {
        this.put("projectName", projectName);
    }

    public void setVdbName(String vdbName) {
        this.put("lastVdbName", vdbName);
    }

    public void setVdbJndiName(String vdbJndiName) {
        this.put("vdbJndiName", vdbJndiName);
    }

    public void setSourceModelName(String sourceModelName) {
        this.put("lastSourceModelName", sourceModelName);
    }

    public void setViewModelName(String viewModelName) {
        this.put("lastViewModelName", viewModelName);
    }

    public void setConnectionProfileName(String connProfileName) {
        this.put("lastConnectionProfileId", connProfileName);
    }

    public void setSourcesFolderName(String sourcesFolderName) {
        this.put("sourcesFolder", sourcesFolderName);
    }

    public void setViewsFolderName(String sourcesFolderName) {
        this.put("viewsFolder", sourcesFolderName);
    }

    public void setSchemaFolderName(String schemaFolderName) {
        this.put("schemaFolder", schemaFolderName);
    }

    public void setWebServiceFolderName(String webServiceFolderName) {
        this.put("wsFolder", webServiceFolderName);
    }

    public void setPreviewTargetObjectName(String previewTargetObjectName) {
        this.put("previewTargetObject", previewTargetObjectName);
    }

    public void setPreviewTargetModelName(String previewTargetModelName) {
        this.put("previewTargetModel", previewTargetModelName);
    }

    public void setLastViewModelObjectName(String name) {
        this.put("lastViewModelObjectName", name);
    }

    public void setLastSourceModelObjectName(String name) {
        this.put("lastSourceModelObjectName", name);
    }

    public IContainer getSourcesFolder() {
        IContainer folder = null;
        String projectName = this.getProperty("projectName");
        if (projectName != null && !projectName.isEmpty()) {
            IResource resrc;
            String folderName = projectName;
            String sourcesFolder = this.getProperty("sourcesFolder");
            if (sourcesFolder != null && !sourcesFolder.isEmpty()) {
                folderName = new Path(projectName).append(sourcesFolder).toString();
            }
            if ((resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName)) != null) {
                folder = (IContainer)resrc;
            }
        }
        return folder;
    }

    public IContainer getViewsFolder() {
        IContainer folder = null;
        String projectName = this.getProperty("projectName");
        if (projectName != null && !projectName.isEmpty()) {
            IResource resrc;
            String folderName = projectName;
            String viewsFolder = this.getProperty("viewsFolder");
            if (viewsFolder != null && !viewsFolder.isEmpty()) {
                folderName = new Path(projectName).append(viewsFolder).toString();
            }
            if ((resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName)) != null) {
                folder = (IContainer)resrc;
            }
        }
        return folder;
    }

    public IProject getProject() {
        IProject project = null;
        String projectName = this.getProperty("projectName");
        if (projectName != null) {
            Collection openProjects = DotProjectUtils.getOpenModelProjects();
            for (IProject openProject : openProjects) {
                if (!openProject.getName().equals(projectName)) continue;
                project = openProject;
                break;
            }
        }
        return project;
    }

    public IFile getViewModel() {
        IFile viewModel = null;
        String modelName = this.getProperty("lastViewModelName");
        if (modelName != null) {
            IResource resrc;
            if (!modelName.endsWith(".xmi")) {
                modelName = String.valueOf(modelName) + ".xmi";
            }
            if ((resrc = ModelUtilities.findModelByName(modelName)) != null && ModelUtil.isModelFile((IResource)resrc) && ModelIdentifier.isVirtualModelType(resrc)) {
                viewModel = (IFile)resrc;
            }
        }
        return viewModel;
    }

    public IFile getSourceModel() {
        IFile sourceModel = null;
        String modelName = this.getProperty("lastSourceModelName");
        if (modelName != null) {
            IResource resrc;
            if (!modelName.endsWith(".xmi")) {
                modelName = String.valueOf(modelName) + ".xmi";
            }
            if ((resrc = ModelUtilities.findModelByName(modelName)) != null && ModelUtil.isModelFile((IResource)resrc) && ModelIdentifier.isPhysicalModelType(resrc)) {
                sourceModel = (IFile)resrc;
            }
        }
        return sourceModel;
    }

    public IResource getVDB() {
        String vdbName = this.getProperty("lastVdbName");
        if (vdbName == null) {
            return null;
        }
        WorkspaceResourceFinderUtil.VdbResourceCollectorVisitor visitor = new WorkspaceResourceFinderUtil.VdbResourceCollectorVisitor(vdbName);
        WorkspaceResourceFinderUtil.getProjectFileResources((IResourceVisitor)visitor);
        Collection vdbs = visitor.getFileResources();
        return vdbs.isEmpty() ? null : (IResource)vdbs.iterator().next();
    }

    public IFile getPreviewTargetModel() {
        String targetModelName = this.getPreviewTargetModelName();
        String viewsFolder = this.getViewsFolderName();
        IFile targetPreviewModel = null;
        IProject project = this.getProject();
        if (project != null) {
            IPath targetModelPath = new Path("").makeAbsolute();
            if (viewsFolder != null && targetModelName != null && !viewsFolder.isEmpty() && !targetModelName.isEmpty()) {
                targetModelPath = targetModelPath.append(viewsFolder).append(targetModelName);
                targetPreviewModel = project.getFile(targetModelPath);
            }
        }
        return targetPreviewModel;
    }

    public EObject getPreviewTargetObject() {
        String targetObjName;
        EObject targetEObj = null;
        IFile targetModel = this.getPreviewTargetModel();
        if (targetModel != null && (targetObjName = this.getPreviewTargetObjectName()) != null && !targetObjName.isEmpty()) {
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = ModelUtilities.getModelResourceForIFile(targetModel, true);
            if (resource != null) {
                try {
                    List eObjects = resource.getEObjects();
                    for (EObject eObj : eObjects) {
                        if (!targetObjName.equals(editor.getName(eObj))) continue;
                        targetEObj = eObj;
                        break;
                    }
                }
                catch (ModelWorkspaceException ex) {
                    UiPlugin.getDefault().getPluginUtil().log((Throwable)ex);
                }
            }
        }
        return targetEObj;
    }

    public EObject getLastSourceModelObject() {
        String targetObjName;
        EObject targetEObj = null;
        IFile sourceModel = this.getSourceModel();
        if (sourceModel != null && (targetObjName = this.getLastSourceModelObjectName()) != null && !targetObjName.isEmpty()) {
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = ModelUtilities.getModelResourceForIFile(sourceModel, true);
            if (resource != null) {
                try {
                    List eObjects = resource.getEObjects();
                    for (EObject eObj : eObjects) {
                        if (!targetObjName.equals(editor.getName(eObj))) continue;
                        targetEObj = eObj;
                        break;
                    }
                }
                catch (ModelWorkspaceException ex) {
                    UiPlugin.getDefault().getPluginUtil().log((Throwable)ex);
                }
            }
        }
        return targetEObj;
    }

    public EObject getLastViewModelObject() {
        String targetObjName;
        EObject targetEObj = null;
        IFile targetModel = this.getViewModel();
        if (targetModel != null && (targetObjName = this.getLastViewModelObjectName()) != null && !targetObjName.isEmpty()) {
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = ModelUtilities.getModelResourceForIFile(targetModel, true);
            if (resource != null) {
                try {
                    List eObjects = resource.getEObjects();
                    for (EObject eObj : eObjects) {
                        if (!targetObjName.equals(editor.getName(eObj))) continue;
                        targetEObj = eObj;
                        break;
                    }
                }
                catch (ModelWorkspaceException ex) {
                    UiPlugin.getDefault().getPluginUtil().log((Throwable)ex);
                }
            }
        }
        return targetEObj;
    }

    public boolean isProjectNameSet() {
        return this.getProjectName() != null;
    }

    public boolean isProjectDifferent(IProject newProject) {
        if (newProject == null && this.getProjectName() != null) {
            return true;
        }
        if (newProject != null && this.getProjectName() == null) {
            return true;
        }
        return !newProject.getName().equals(this.getProjectName());
    }

    public boolean isSourceModelDifferent(IFile newFile) {
        if (newFile == null && this.getSourceModelName() != null) {
            return true;
        }
        if (newFile != null && this.getSourceModelName() == null) {
            return true;
        }
        return !newFile.getName().equals(this.getSourceModelName());
    }

    public boolean isViewModelDifferent(IFile newFile) {
        if (newFile == null && this.getViewModelName() != null) {
            return true;
        }
        if (newFile != null && this.getViewModelName() == null) {
            return true;
        }
        return !newFile.getName().equals(this.getViewModelName());
    }

    public boolean isVdbDifferent(IFile newVdb) {
        if (newVdb == null && this.getVdbName() != null) {
            return true;
        }
        if (newVdb != null && this.getVdbName() == null) {
            return true;
        }
        return !newVdb.getName().equals(this.getVdbName());
    }
}

