/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DesignerPropertiesUtil
implements StringConstants {
    private static final DesignerPropertiesUtil INSTANCE = new DesignerPropertiesUtil();

    public static DesignerPropertiesUtil getInstance() {
        return INSTANCE;
    }

    public static String getProjectName(Properties properties) {
        return properties.getProperty("projectName");
    }

    public static String getProjectStatus(Properties properties) {
        return properties.getProperty("projectStatus");
    }

    public static String getVdbName(Properties properties) {
        return properties.getProperty("lastVdbName");
    }

    public static String getVdbJndiName(Properties properties) {
        return properties.getProperty("vdbJndiName");
    }

    public static String getSourceModelName(Properties properties) {
        return properties.getProperty("lastSourceModelName");
    }

    public static String getViewModelName(Properties properties) {
        return properties.getProperty("lastViewModelName");
    }

    public static String getConnectionProfileName(Properties properties) {
        return properties.getProperty("lastConnectionProfileId");
    }

    public static String getSourcesFolderName(Properties properties) {
        return properties.getProperty("sourcesFolder");
    }

    public static String getViewsFolderName(Properties properties) {
        return properties.getProperty("viewsFolder");
    }

    public static String getSchemaFolderName(Properties properties) {
        return properties.getProperty("schemaFolder");
    }

    public static String getWebServiceFolderName(Properties properties) {
        return properties.getProperty("wsFolder");
    }

    public static String getPreviewTargetObjectName(Properties properties) {
        return properties.getProperty("previewTargetObject");
    }

    public static String getPreviewTargetModelName(Properties properties) {
        return properties.getProperty("previewTargetModel");
    }

    public static String getLastSourceModelObjectName(Properties properties) {
        return properties.getProperty("lastSourceModelObjectName");
    }

    public static String getLastViewModelObjectName(Properties properties) {
        return properties.getProperty("lastViewModelObjectName");
    }

    public static boolean isImportXmlRemote(Properties properties) {
        String value = properties.getProperty("xmlImportType");
        return value != null && value.equalsIgnoreCase("remote");
    }

    public static void setProjectName(Properties properties, String projectName) {
        if (projectName == null) {
            properties.remove("projectName");
        } else {
            properties.put("projectName", projectName);
        }
    }

    public static void setProjectStatus(Properties properties, String status) {
        if (status == null) {
            properties.remove("projectStatus");
        } else {
            properties.put("projectStatus", status);
        }
    }

    public static void setVdbName(Properties properties, String vdbName) {
        properties.put("lastVdbName", vdbName);
    }

    public static void setVdbJndiName(Properties properties, String vdbJndiName) {
        properties.put("vdbJndiName", vdbJndiName);
    }

    public static void setSourceModelName(Properties properties, String sourceModelName) {
        properties.put("lastSourceModelName", sourceModelName);
    }

    public static void setViewModelName(Properties properties, String viewModelName) {
        properties.put("lastViewModelName", viewModelName);
    }

    public static void setConnectionProfileName(Properties properties, String connProfileName) {
        properties.put("lastConnectionProfileId", connProfileName);
    }

    public static void setSourcesFolderName(Properties properties, String sourcesFolderName) {
        properties.put("sourcesFolder", sourcesFolderName);
    }

    public static void setViewsFolderName(Properties properties, String sourcesFolderName) {
        properties.put("viewsFolder", sourcesFolderName);
    }

    public static void setSchemaFolderName(Properties properties, String schemaFolderName) {
        properties.put("schemaFolder", schemaFolderName);
    }

    public static void setWebServiceFolderName(Properties properties, String webServiceFolderName) {
        properties.put("wsFolder", webServiceFolderName);
    }

    public static void setPreviewTargetObjectName(Properties properties, String previewTargetObjectName) {
        properties.put("previewTargetObject", previewTargetObjectName);
    }

    public static void setPreviewTargetModelName(Properties properties, String previewTargetModelName) {
        properties.put("previewTargetModel", previewTargetModelName);
    }

    public static void setLastViewModelObjectName(Properties properties, String name) {
        properties.put("lastViewModelObjectName", name);
    }

    public static void setLastSourceModelObjectName(Properties properties, String name) {
        properties.put("lastSourceModelObjectName", name);
    }

    public static IContainer getSourcesFolder(Properties properties) {
        IContainer folder = null;
        String projectName = properties.getProperty("projectName");
        if (projectName != null && !projectName.isEmpty()) {
            IResource resrc;
            String folderName = projectName;
            String sourcesFolder = properties.getProperty("sourcesFolder");
            if (sourcesFolder != null && !sourcesFolder.isEmpty()) {
                folderName = new Path(projectName).append(sourcesFolder).toString();
            }
            if ((resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName)) != null) {
                folder = (IContainer)resrc;
            }
        }
        return folder;
    }

    public static IContainer getViewsFolder(Properties properties) {
        IContainer folder = null;
        String projectName = properties.getProperty("projectName");
        if (projectName != null && !projectName.isEmpty()) {
            IResource resrc;
            String folderName = projectName;
            String viewsFolder = properties.getProperty("viewsFolder");
            if (viewsFolder != null && !viewsFolder.isEmpty()) {
                folderName = new Path(projectName).append(viewsFolder).toString();
            }
            if ((resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName)) != null) {
                folder = (IContainer)resrc;
            }
        }
        return folder;
    }

    public static IProject getProject(Properties properties) {
        IProject project = null;
        String projectName = properties.getProperty("projectName");
        if (projectName == null) {
            return null;
        }
        Collection openProjects = DotProjectUtils.getOpenModelProjects();
        for (IProject openProject : openProjects) {
            if (!openProject.getName().equals(projectName)) continue;
            project = openProject;
            break;
        }
        return project;
    }

    public static IFile getViewModel(Properties properties) {
        IFile viewModel = null;
        String modelName = properties.getProperty("lastViewModelName");
        if (modelName != null) {
            IResource resrc;
            if (!modelName.endsWith(".xmi")) {
                modelName = String.valueOf(modelName) + ".xmi";
            }
            if ((resrc = ModelUtilities.findModelByName(modelName)) != null && ModelUtil.isModelFile((IResource)resrc) && ModelIdentifier.isVirtualModelType(resrc)) {
                viewModel = (IFile)resrc;
            }
        }
        return viewModel;
    }

    public static IFile getSourceModel(Properties properties) {
        IFile sourceModel = null;
        String modelName = properties.getProperty("lastSourceModelName");
        if (modelName != null) {
            IResource resrc;
            if (!modelName.endsWith(".xmi")) {
                modelName = String.valueOf(modelName) + ".xmi";
            }
            if ((resrc = ModelUtilities.findModelByName(modelName)) != null && ModelUtil.isModelFile((IResource)resrc) && ModelIdentifier.isPhysicalModelType(resrc)) {
                sourceModel = (IFile)resrc;
            }
        }
        return sourceModel;
    }

    public static IResource getVDB(Properties properties) {
        String vdbName = properties.getProperty("lastVdbName");
        if (vdbName == null) {
            return null;
        }
        WorkspaceResourceFinderUtil.VdbResourceCollectorVisitor visitor = new WorkspaceResourceFinderUtil.VdbResourceCollectorVisitor(vdbName);
        WorkspaceResourceFinderUtil.getProjectFileResources((IResourceVisitor)visitor);
        return (IResource)visitor.getFileResources().iterator().next();
    }

    public static IFile getPreviewTargetModel(Properties properties) {
        String targetModelName = DesignerPropertiesUtil.getPreviewTargetModelName(properties);
        IFile targetPreviewModel = null;
        if (targetModelName != null) {
            String viewsFolder = DesignerPropertiesUtil.getViewsFolderName(properties);
            IProject project = DesignerPropertiesUtil.getProject(properties);
            if (project != null) {
                Path targetModelPath = new Path("");
                if (viewsFolder != null && !viewsFolder.isEmpty() && !targetModelName.isEmpty()) {
                    targetModelPath = targetModelPath.append(viewsFolder).append(targetModelName);
                    targetPreviewModel = project.getFile((IPath)targetModelPath);
                } else {
                    targetModelPath = targetModelPath.append(targetModelName);
                    targetPreviewModel = project.getFile(targetModelName);
                }
            }
        }
        return targetPreviewModel;
    }

    public static EObject getPreviewTargetObject(Properties properties) {
        String targetObjName;
        EObject targetEObj = null;
        IFile targetModel = DesignerPropertiesUtil.getPreviewTargetModel(properties);
        if (targetModel != null && (targetObjName = DesignerPropertiesUtil.getPreviewTargetObjectName(properties)) != null && !targetObjName.isEmpty()) {
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = ModelUtilities.getModelResourceForIFile(targetModel, true);
            if (resource != null) {
                try {
                    List eObjects = resource.getEObjects();
                    for (EObject eObj : eObjects) {
                        if (!targetObjName.equals(editor.getName(eObj))) continue;
                        targetEObj = eObj;
                        break;
                    }
                }
                catch (ModelWorkspaceException ex) {
                    UiPlugin.getDefault().getPluginUtil().log((Throwable)ex);
                }
            }
        }
        return targetEObj;
    }

    public static EObject getLastSourceModelObject(Properties properties) {
        String targetObjName;
        EObject targetEObj = null;
        IFile sourceModel = DesignerPropertiesUtil.getSourceModel(properties);
        if (sourceModel != null && (targetObjName = DesignerPropertiesUtil.getLastSourceModelObjectName(properties)) != null && !targetObjName.isEmpty()) {
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = ModelUtilities.getModelResourceForIFile(sourceModel, true);
            if (resource != null) {
                try {
                    List eObjects = resource.getEObjects();
                    for (EObject eObj : eObjects) {
                        if (!targetObjName.equals(editor.getName(eObj))) continue;
                        targetEObj = eObj;
                        break;
                    }
                }
                catch (ModelWorkspaceException ex) {
                    UiPlugin.getDefault().getPluginUtil().log((Throwable)ex);
                }
            }
        }
        return targetEObj;
    }

    public static EObject getLastViewModelObject(Properties properties) {
        String targetObjName;
        EObject targetEObj = null;
        IFile targetModel = DesignerPropertiesUtil.getViewModel(properties);
        if (targetModel != null && (targetObjName = DesignerPropertiesUtil.getLastViewModelObjectName(properties)) != null && !targetObjName.isEmpty()) {
            ModelEditor editor = ModelerCore.getModelEditor();
            ModelResource resource = ModelUtilities.getModelResourceForIFile(targetModel, true);
            if (resource != null) {
                try {
                    List eObjects = resource.getEObjects();
                    for (EObject eObj : eObjects) {
                        if (!targetObjName.equals(editor.getName(eObj))) continue;
                        targetEObj = eObj;
                        break;
                    }
                }
                catch (ModelWorkspaceException ex) {
                    UiPlugin.getDefault().getPluginUtil().log((Throwable)ex);
                }
            }
        }
        return targetEObj;
    }

    public static boolean isProjectNameSet(Properties properties) {
        return DesignerPropertiesUtil.getProjectName(properties) != null;
    }

    public static boolean isProjectDifferent(IProject newProject, Properties properties) {
        if (newProject == null && DesignerPropertiesUtil.getProjectName(properties) != null) {
            return true;
        }
        if (newProject != null && DesignerPropertiesUtil.getProjectName(properties) == null) {
            return true;
        }
        return !newProject.getName().equals(DesignerPropertiesUtil.getProjectName(properties));
    }
}

