/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;

public class DiagramLabelProvider
implements ILabelProvider,
UiConstants.ExtensionPoints.DiagramLabelProvider {
    private HashMap providerMap = new HashMap();
    private ILabelProvider lastProvider;
    private String lastType;

    public DiagramLabelProvider() {
        this.loadProviderList();
    }

    private void loadProviderList() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "diagramLabelProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                ILabelProvider labelProvider = null;
                int j = 0;
                while (j < elements.length) {
                    Object provider;
                    if (elements[j].getName().equals("class") && (provider = elements[j].createExecutableExtension("name")) instanceof ILabelProvider) {
                        labelProvider = (ILabelProvider)provider;
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("diagramType")) {
                        String type = elements[j].getAttribute("name");
                        this.providerMap.put(type, labelProvider);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("DiagramLabelProvider.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof Diagram) {
            String message;
            String type = ((Diagram)element).getType();
            if (this.lastType != null && this.lastType.equals(type)) {
                try {
                    result = this.lastProvider.getImage(element);
                }
                catch (Exception e) {
                    message = UiConstants.Util.getString("DiagramLabelProvider.diagramProviderErrorMessage", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
            if (result == null) {
                this.lastType = null;
                this.lastProvider = (ILabelProvider)this.providerMap.get(type);
                if (this.lastProvider != null) {
                    try {
                        result = this.lastProvider.getImage(element);
                        if (result != null) {
                            this.lastType = type;
                        }
                    }
                    catch (Exception e) {
                        message = UiConstants.Util.getString("DiagramLabelProvider.diagramProviderErrorMessage", new Object[0]);
                        UiConstants.Util.log(4, (Throwable)e, message);
                    }
                }
            }
        }
        return result;
    }

    public String getText(Object element) {
        String result = null;
        if (element instanceof Diagram) {
            String message;
            String type = ((Diagram)element).getType();
            if (this.lastType != null && this.lastType.equals(type)) {
                try {
                    result = this.lastProvider.getText(element);
                }
                catch (Exception e) {
                    message = UiConstants.Util.getString("DiagramLabelProvider.diagramProviderErrorMessage", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
            if (result == null) {
                this.lastType = null;
                this.lastProvider = (ILabelProvider)this.providerMap.get(type);
                if (this.lastProvider != null) {
                    try {
                        result = this.lastProvider.getText(element);
                        if (result != null) {
                            this.lastType = type;
                        }
                    }
                    catch (Exception e) {
                        message = UiConstants.Util.getString("DiagramLabelProvider.diagramProviderErrorMessage", new Object[0]);
                        UiConstants.Util.log(4, (Throwable)e, message);
                    }
                }
            }
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.providerMap != null) {
            for (ILabelProvider provider : this.providerMap.values()) {
                if (provider == null) continue;
                try {
                    provider.dispose();
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("DiagramLabelProvider.diagramProviderErrorMessage", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
        }
        this.lastProvider = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

