/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;

public class ExtendedModelObjectContentProvider
implements UiConstants.ExtensionPoints.ExtendedModelContentProvider {
    private static final ArrayList extendedModelProviders = new ArrayList();
    private static boolean loaded = false;

    public ExtendedModelObjectContentProvider() {
        this.loadProviderList();
    }

    private void loadProviderList() {
        if (loaded) {
            return;
        }
        loaded = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "extendedModelContentProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object provider;
                    if (elements[j].getName().equals("class") && (provider = elements[j].createExecutableExtension("name")) instanceof ITreeContentProvider) {
                        extendedModelProviders.add(provider);
                        break;
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelObjectContentProvider.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }

    private ArrayList getExtendedModelChildren(Object parentElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.isXsdObject(parentElement)) {
            return result;
        }
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)true, null, (Object)this);
        boolean succeeded = false;
        try {
            for (ITreeContentProvider provider : extendedModelProviders) {
                try {
                    Object[] extendedObjs = provider.getChildren(parentElement);
                    if (extendedObjs == null || extendedObjs.length <= 0) continue;
                    result.addAll(Arrays.asList(extendedObjs));
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("ModelObjectContentProvider.extendedModelProviderErrorMessage", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
            succeeded = true;
        }
        finally {
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return result;
    }

    private boolean isXsdObject(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ModelResource) {
            return ((ModelResource)obj).isXsd();
        }
        if (obj instanceof EObject) {
            Resource rsrc = ((EObject)obj).eResource();
            return ModelUtil.isXsdFile((Resource)rsrc);
        }
        if (obj instanceof Resource) {
            return ModelUtil.isXsdFile((Resource)((Resource)obj));
        }
        return false;
    }

    public Object[] getChildren(Object theParentElement) {
        ArrayList extendedChildren = this.getExtendedModelChildren(theParentElement);
        if (!extendedChildren.isEmpty()) {
            return extendedChildren.toArray();
        }
        return null;
    }

    public Object getParent(Object theElement) {
        Object result = null;
        for (ITreeContentProvider provider : extendedModelProviders) {
            try {
                result = provider.getParent(theElement);
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelObjectContentProvider.extendedModelProviderErrorMessage", new Object[0]);
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            if (result != null) break;
        }
        return null;
    }

    public boolean hasChildren(Object theElement) {
        return this.hasExtendedModelChildren(theElement);
    }

    private boolean hasExtendedModelChildren(Object parentElement) {
        if (this.isXsdObject(parentElement)) {
            return false;
        }
        for (ITreeContentProvider provider : extendedModelProviders) {
            if (!provider.hasChildren(parentElement)) continue;
            return true;
        }
        return false;
    }
}

