/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.ui.UiConstants;

public class ExtendedModelObjectLabelProvider
implements ILabelProvider,
UiConstants.ExtensionPoints.ExtendedModelLabelProvider {
    private ArrayList extendedModelProviders = new ArrayList();

    public ExtendedModelObjectLabelProvider() {
        this.loadProviderList();
    }

    private void loadProviderList() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "extendedModelLabelProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object provider;
                    if (elements[j].getName().equals("class") && (provider = elements[j].createExecutableExtension("name")) instanceof ILabelProvider) {
                        this.extendedModelProviders.add(provider);
                        break;
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ExtendedModelObjectLabelProvider.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }

    public Image getImage(Object element) {
        Image result = null;
        for (ILabelProvider provider : this.extendedModelProviders) {
            result = provider.getImage(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getText(Object element) {
        String result = null;
        for (ILabelProvider provider : this.extendedModelProviders) {
            result = provider.getText(element);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.extendedModelProviders != null) {
            for (ILabelProvider provider : this.extendedModelProviders) {
                if (provider == null) continue;
                try {
                    provider.dispose();
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("DiagramLabelProvider.diagramProviderErrorMessage", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

