/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class MetamodelSelectionDialog
extends ElementTreeSelectionDialog {
    private static final String PRIMARY_METAMODELS = UiConstants.Util.getString("MetamodelClassDialog.primaryOnly", new Object[0]);
    private static final String ALL_METAMODELS = UiConstants.Util.getString("MetamodelClassDialog.allMetamodels", new Object[0]);
    private boolean primaryMetamodelsOnly = true;
    Collection primaryMetamodelResources;
    TreeViewer treeViewer;
    private PrimaryMetamodelFilter filter;
    private ILabelProvider labelProvider;

    public MetamodelSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.labelProvider = labelProvider;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        this.treeViewer = super.createTreeViewer(panel);
        GridData gd = new GridData(1808);
        panel.setLayoutData((Object)gd);
        Button radioButton = WidgetFactory.createRadioButton((Composite)panel, (String)PRIMARY_METAMODELS, (boolean)true);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MetamodelSelectionDialog.this.setMetamodelFilter(true);
            }
        });
        radioButton = WidgetFactory.createRadioButton((Composite)panel, (String)ALL_METAMODELS, (boolean)false);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MetamodelSelectionDialog.this.setMetamodelFilter(false);
            }
        });
        this.filter = new PrimaryMetamodelFilter();
        this.treeViewer.addFilter((ViewerFilter)this.filter);
        return this.treeViewer;
    }

    public IBaseLabelProvider getViewerLabelProvider() {
        return this.labelProvider;
    }

    protected void setMetamodelFilter(boolean primaryOnly) {
        this.primaryMetamodelsOnly = primaryOnly;
        this.filter.enable = this.primaryMetamodelsOnly;
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                MetamodelSelectionDialog.this.treeViewer.refresh();
            }
        });
    }

    public void setInput(Object input) {
        if (input instanceof Collection) {
            Collection metamodelDescriptors = (Collection)input;
            this.primaryMetamodelResources = new ArrayList(metamodelDescriptors.size());
            for (MetamodelDescriptor mmd : metamodelDescriptors) {
                if (!mmd.isPrimary()) continue;
                String stringUri = mmd.getNamespaceURI();
                URI uri = URI.createURI((String)stringUri);
                Resource r = ModelerCore.getMetamodelRegistry().getResource(uri);
                this.primaryMetamodelResources.add(r);
            }
        }
        super.setInput(input);
    }

    protected Control createContents(Composite theParent) {
        Control control = super.createContents(theParent);
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
        this.updateOKStatus();
        return control;
    }

    public class PrimaryMetamodelFilter
    extends ViewerFilter {
        public boolean enable = true;

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.enable && element instanceof Resource) {
                return MetamodelSelectionDialog.this.primaryMetamodelResources.contains(element);
            }
            return true;
        }
    }
}

