/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;

public class MetamodelSelectionUtilities {
    public static IFile selectViewModelInWorkspace() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)UiConstants.Util.getString("MetamodelSelectionUtilities.selectViewModel_title", new Object[0]), (String)UiConstants.Util.getString("MetamodelSelectionUtilities.selectViewModel_msg", new Object[0]), (boolean)false, null, (ViewerFilter)MetamodelSelectionUtilities.getModelViewerFilter(ModelIdentifier.RELATIONAL_VIEW_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relational"), (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && selections[0] instanceof IFile) {
            return (IFile)selections[0];
        }
        if (selections != null && selections.length == 1 && selections[0] instanceof IFile) {
            return (IFile)selections[0];
        }
        return null;
    }

    public static IFile selectSourceModelInWorkspace() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)UiConstants.Util.getString("MetamodelSelectionUtilities.selectSourceModel_title", new Object[0]), (String)UiConstants.Util.getString("MetamodelSelectionUtilities.selectSourceModel_msg", new Object[0]), (boolean)false, null, (ViewerFilter)MetamodelSelectionUtilities.getModelViewerFilter(ModelIdentifier.RELATIONAL_SOURCE_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relational"), (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && selections[0] instanceof IFile) {
            return (IFile)selections[0];
        }
        return null;
    }

    public static ViewerFilter getModelViewerFilter(final ModelType type, final String metamodelURI) {
        return new ModelWorkspaceViewerFilter(true){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean doSelect = false;
                if (element instanceof IResource) {
                    boolean projectOpen = ((IResource)element).getProject().isOpen();
                    if (projectOpen) {
                        if (element instanceof IProject) {
                            doSelect = true;
                        } else if (element instanceof IContainer) {
                            doSelect = true;
                        } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                            doSelect = ModelIdentifier.isModel((IResource)((IFile)element), type, metamodelURI);
                        }
                    }
                } else if (element instanceof IContainer) {
                    doSelect = true;
                }
                return doSelect;
            }
        };
    }
}

