/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.core.designer.util.ArrayUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.product.IModelerProductContexts;
import org.teiid.designer.ui.viewsupport.IContentFilter;

class MetamodelTreeContentProvider
implements ArrayUtil.Constants,
ITreeContentProvider {
    private ITreeContentProvider emfContentProvider;
    private IContentFilter filter;

    public MetamodelTreeContentProvider(AdapterFactory factory, IContentFilter filter) {
        this.emfContentProvider = new AdapterFactoryContentProvider(factory);
        this.filter = filter;
    }

    public void dispose() {
        this.emfContentProvider.dispose();
    }

    public Object[] getChildren(Object parentElement) {
        Object[] elems;
        if (parentElement instanceof Resource) {
            EPackage ePackage = (EPackage)((Resource)parentElement).getContents().get(0);
            elems = ePackage.eContents().toArray();
        } else {
            elems = this.emfContentProvider.getChildren(parentElement);
        }
        if (this.filter == null) {
            return elems;
        }
        return this.filter.filter(elems);
    }

    public Object[] getElements(Object inputElement) {
        Collection descriptorList = (Collection)inputElement;
        ArrayList<Resource> visibleResults = new ArrayList<Resource>();
        Iterator iter = descriptorList.iterator();
        while (iter.hasNext()) {
            String stringUri = ((MetamodelDescriptor)iter.next()).getNamespaceURI();
            if (!UiPlugin.getDefault().isProductContextValueSupported(IModelerProductContexts.Metamodel.USER_VISIBLE_URI, stringUri)) continue;
            URI uri = URI.createURI((String)stringUri);
            visibleResults.add(ModelerCore.getMetamodelRegistry().getResource(uri));
        }
        if (!visibleResults.isEmpty()) {
            int index = 0;
            Object[] result = new Object[visibleResults.size()];
            Iterator iter2 = visibleResults.iterator();
            while (iter2.hasNext()) {
                result[index++] = iter2.next();
            }
            return result;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return this.emfContentProvider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Resource) {
            return true;
        }
        return this.emfContentProvider.hasChildren(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

