/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.EcoreAdapterFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.IContentFilter;
import org.teiid.designer.ui.viewsupport.MetamodelLabelProvider;
import org.teiid.designer.ui.viewsupport.MetamodelSelectionDialog;
import org.teiid.designer.ui.viewsupport.MetamodelTreeContentProvider;

public class MetamodelTreeViewer
extends TreeViewer {
    public static final EcoreAdapterFactory FACTORY = new EcoreItemProviderAdapterFactory();

    public static SelectionDialog createSelectionDialog(Shell parentShell, boolean primaryOnly) {
        return MetamodelTreeViewer.createSelectionDialog(parentShell, primaryOnly, null);
    }

    public static SelectionDialog createSelectionDialog(Shell parentShell, boolean primaryOnly, IContentFilter filter) {
        MetamodelSelectionDialog dialog = new MetamodelSelectionDialog(parentShell, new MetamodelLabelProvider((AdapterFactory)FACTORY), new MetamodelTreeContentProvider((AdapterFactory)FACTORY, filter));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof EClass) {
                    return new StatusInfo("org.teiid.designer.ui", 0, "");
                }
                String message = UiConstants.Util.getString("MetamodelClassDialog.mustSelectClass", new Object[0]);
                return new StatusInfo("org.teiid.designer.ui", 4, message);
            }
        });
        dialog.setComparator(new ViewerComparator(){});
        dialog.setTitle(UiConstants.Util.getString("MetamodelClassDialog.selectClassTitle", new Object[0]));
        dialog.setMessage(UiConstants.Util.getString("MetamodelClassDialog.selectClassMessage", new Object[0]));
        List<MetamodelDescriptor> descriptors = Arrays.asList(ModelerCore.getMetamodelRegistry().getMetamodelDescriptors());
        dialog.setInput(descriptors);
        return dialog;
    }

    public MetamodelTreeViewer(Composite parent) {
        super(parent, 770);
        this.setContentProvider((IContentProvider)new MetamodelTreeContentProvider((AdapterFactory)FACTORY, null));
        this.setLabelProvider((IBaseLabelProvider)new MetamodelLabelProvider((AdapterFactory)FACTORY));
        List<MetamodelDescriptor> descriptors = Arrays.asList(ModelerCore.getMetamodelRegistry().getMetamodelDescriptors());
        super.setInput(descriptors);
        this.setSorter(new ViewerSorter(){});
    }
}

