/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class ModelIdentifier
implements UiConstants {
    public static final int UNKNOWN_MODEL_ID = -1;
    public static final int UNKNOWN_MODEL_TYPE_ID = ModelType.UNKNOWN;
    public static final ModelType UNKNOWN_MODEL_TYPE = ModelType.UNKNOWN_LITERAL;
    public static final String UNKNOWN_MODEL_STRING = "Unknown";
    public static final String UNKNOWN_MODEL_IMAGE_ID = "icons/full/obj16/Model.gif";
    public static final int RELATIONAL_SOURCE_MODEL_ID = 0;
    public static final int RELATIONAL_SOURCE_MODEL_TYPE_ID = ModelType.PHYSICAL;
    public static final ModelType RELATIONAL_SOURCE_MODEL_TYPE = ModelType.PHYSICAL_LITERAL;
    public static final String RELATIONAL_SOURCE_MODEL_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final String RELATIONAL_SOURCE_MODEL_STRING = "Source";
    public static final String RELATIONAL_SOURCE_MODEL_IMAGE_ID = "icons/full/obj16/Model.gif";
    public static final int EXTENSION_MODEL_ID = 1;
    public static final int EXTENSION_MODEL_TYPE_ID = ModelType.EXTENSION;
    public static final ModelType EXTENSION_MODEL_TYPE = ModelType.EXTENSION_LITERAL;
    public static final String EXTENSION_MODEL_URI = "http://www.metamatrix.com/metamodels/Extension";
    public static final String EXTENSION_MODEL_STRING = ModelType.EXTENSION_LITERAL.getName();
    public static final String EXTENSION_MODEL_IMAGE_ID = "icons/full/obj16/ExtensionModel.gif";
    public static final int FUNCTION_MODEL_ID = 2;
    public static final int FUNCTION_MODEL_TYPE_ID = ModelType.FUNCTION;
    public static final ModelType FUNCTION_MODEL_TYPE = ModelType.FUNCTION_LITERAL;
    public static final String FUNCTION_MODEL_URI = "http://www.metamatrix.com/metamodels/MetaMatrixFunction";
    public static final String FUNCTION_MODEL_STRING = ModelType.FUNCTION_LITERAL.getName();
    public static final String FUNCTION_MODEL_IMAGE_ID = "icons/full/obj16/FunctionModel.gif";
    public static final int LOGICAL_MODEL_ID = 3;
    public static final int LOGICAL_MODEL_TYPE_ID = ModelType.LOGICAL;
    public static final ModelType LOGICAL_MODEL_TYPE = ModelType.LOGICAL_LITERAL;
    public static final String LOGICAL_MODEL_URI = "http://www.metamatrix.com/metamodels/Relationship";
    public static final String LOGICAL_MODEL_STRING = ModelType.LOGICAL_LITERAL.getName();
    public static final String LOGICAL_MODEL_IMAGE_ID = "icons/full/obj16/LogicalModel.gif";
    public static final int RELATIONAL_VIEW_MODEL_ID = 4;
    public static final int RELATIONAL_VIEW_MODEL_TYPE_ID = ModelType.VIRTUAL;
    public static final ModelType RELATIONAL_VIEW_MODEL_TYPE = ModelType.VIRTUAL_LITERAL;
    public static final String RELATIONAL_VIEW_MODEL_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final String RELATIONAL_VIEW_MODEL_STRING = "View";
    public static final String RELATIONAL_VIEW_MODEL_IMAGE_ID = "icons/full/obj16/ViewModel.gif";
    public static final int XML_VIEW_MODEL_ID = 5;
    public static final int XML_VIEW_MODEL_TYPE_ID = ModelType.VIRTUAL;
    public static final ModelType XML_VIEW_MODEL_TYPE = ModelType.VIRTUAL_LITERAL;
    public static final String XML_VIEW_MODEL_URI = "http://www.metamatrix.com/metamodels/XmlDocument";
    public static final String XML_VIEW_MODEL_STRING = "Xml View";
    public static final String XML_VIEW_MODEL_IMAGE_ID = "icons/full/obj16/XmlViewModel.gif";
    public static final int WEB_SERVICES_VIEW_MODEL_ID = 6;
    public static final int WEB_SERVICES_VIEW_MODEL_TYPE_ID = ModelType.VIRTUAL;
    public static final ModelType WEB_SERVICES_MODEL_TYPE = ModelType.VIRTUAL_LITERAL;
    public static final String WEB_SERVICES_VIEW_MODEL_URI = "http://www.metamatrix.com/metamodels/WebService";
    public static final String WEB_SERVICES_VIEW_MODEL_STRING = "Web Services View";
    public static final String WEB_SERVICES_VIEW_MODEL_IMAGE_ID = "icons/full/obj16/WebServiceViewModel.gif";
    public static final int XML_SCHEMA_MODEL_ID = 7;
    public static final int XML_SCHEMA_MODEL_TYPE_ID = ModelType.TYPE;
    public static final ModelType XML_SCHEMA_MODEL_TYPE = ModelType.TYPE_LITERAL;
    public static final String XML_SCHEMA_MODEL_URI = "http://www.eclipse.org/xsd/2002/XSD";
    public static final String XML_SCHEMA_MODEL_STRING = "Xml Schema";
    public static final String XML_SCHEMA_MODEL_IMAGE_ID = "icons/full/obj16/XSDSchema.gif";
    public static final int XML_SERVICE_SOURCE_MODEL_ID = 8;
    public static final int XML_SERVICE_SOURCE_MODEL_TYPE_ID = ModelType.PHYSICAL;
    public static final ModelType XML_SERVICE_SOURCE_MODEL_TYPE = ModelType.PHYSICAL_LITERAL;
    public static final String XML_SERVICE_SOURCE_MODEL_URI = "http://www.metamatrix.com/metamodels/XmlService";
    public static final String XML_SERVICE_SOURCE_MODEL_STRING = "Xml Service";
    public static final String XML_SERVICE_SOURCE_MODEL_IMAGE_ID = "icons/full/obj16/XmlSourceModel.gif";
    public static final int XML_SERVICE_VIEW_MODEL_ID = 9;
    public static final int XML_SERVICE_VIEW_MODEL_TYPE_ID = ModelType.VIRTUAL;
    public static final ModelType XML_SERVICE_VIEW_MODEL_TYPE = ModelType.VIRTUAL_LITERAL;
    public static final String XML_SERVICE_VIEW_MODEL_URI = "http://www.metamatrix.com/metamodels/XmlService";
    public static final String XML_SERVICE_VIEW_MODEL_STRING = "Xml Service View";
    public static final String XML_SERVICE_VIEW_MODEL_IMAGE_ID = "icons/full/obj16/XmlServiceViewModel.gif";
    public static final int RELATIONSHIP_MODEL_ID = 10;
    public static final int RELATIONSHIP_MODEL_TYPE_ID = ModelType.LOGICAL;
    public static final ModelType RELATIONSHIP_MODEL_TYPE = ModelType.LOGICAL_LITERAL;
    public static final String RELATIONSHIP_MODEL_URI = "http://www.metamatrix.com/metamodels/Relationship";
    public static final String RELATIONSHIP_MODEL_STRING = ModelType.LOGICAL_LITERAL.getName();
    public static final String RELATIONSHIP_MODEL_IMAGE_ID = "icons/full/obj16/RelationshipModel.gif";
    public static final int PEOPLE_MODEL_ID = 11;
    public static final int PEOPLE_MODEL_TYPE_ID = ModelType.LOGICAL;
    public static final ModelType PEOPLE_MODEL_TYPE = ModelType.LOGICAL_LITERAL;
    public static final String PEOPLE_MODEL_URI = "http://www.metamatrix.com/metamodels/People";
    public static final String PEOPLE_MODEL_STRING = "People";
    public static final String PEOPLE_MODEL_IMAGE_ID = "icons/full/obj16/PeopleModel.gif";
    public static final int UML_MODEL_ID = 12;
    public static final int UML_MODEL_TYPE_ID = ModelType.LOGICAL;
    public static final ModelType UML_MODEL_TYPE = ModelType.LOGICAL_LITERAL;
    public static final String UML_MODEL_URI = "http://www.eclipse.org/uml2/3.0.0/UML";
    public static final String UML_MODEL_STRING = "UML";
    public static final String UML_MODEL_IMAGE_ID = "icons/full/obj16/UmlModel.gif";
    public static final int XML_MESSAGE_STRUCTURE_MODEL_ID = 13;
    public static final int XML_MESSAGE_STRUCTURE_MODEL_TYPE_ID = ModelType.LOGICAL;
    public static final ModelType XML_MESSAGE_STRUCTURE_MODEL_TYPE = ModelType.LOGICAL_LITERAL;
    public static final String XML_MESSAGE_STRUCTURE_MODEL_URI = "http://www.metamatrix.com/metamodels/XmlDocument";
    public static final String XML_MESSAGE_STRUCTURE_MODEL_STRING = "Xml Message Structure";
    public static final String XML_MESSAGE_STRUCTURE_MODEL_IMAGE_ID = "icons/full/obj16/XmlMessageStructureModel.gif";
    public static final int VDB_SOURCE_MODEL_ID = 14;
    public static final String VDB_SOURCE_MODEL_IMAGE_ID = "icons/full/obj16/vdb-source-model.png";

    public static boolean isModel(IResource theResource, ModelType theModelType, String thePrimaryMetamodelUri) {
        File resourceFile;
        IPath path;
        boolean result = false;
        if (theResource != null && theResource instanceof IFile && theResource.exists() && ModelUtilities.isModelFile(theResource) && (path = theResource.getLocation()) != null && (resourceFile = path.toFile()).exists()) {
            if (ModelUtil.isXsdFile((IResource)theResource) && (thePrimaryMetamodelUri == null || thePrimaryMetamodelUri.equals(XML_SCHEMA_MODEL_URI))) {
                result = true;
            } else {
                XMIHeader header = ModelFileUtil.getXmiHeader((File)resourceFile);
                if (header != null) {
                    if (theModelType != null && header.getModelType() != null) {
                        String theURI;
                        if (header.getModelType().equals(theModelType.getName()) && (theURI = header.getPrimaryMetamodelURI()) != null && theURI.equals(thePrimaryMetamodelUri)) {
                            result = true;
                        }
                    } else if (header.getPrimaryMetamodelURI() != null && header.getPrimaryMetamodelURI().equals(thePrimaryMetamodelUri)) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPrimaryMetamodelURIFromModelResource(ModelResource modelResource, boolean wrapInTransaction, Object source) {
        if (modelResource == null) return null;
        if (!modelResource.exists()) {
            return null;
        }
        String thePMURI = null;
        if (wrapInTransaction) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Get Primary Metamodel URI", (Object)source);
            boolean succeeded = false;
            try {
                try {
                    thePMURI = modelResource.getPrimaryMetamodelUri();
                    succeeded = true;
                    return thePMURI;
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log((Throwable)e);
                    if (!requiredStart) return thePMURI;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        return thePMURI;
                    }
                    ModelerCore.rollbackTxn();
                }
                return thePMURI;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        } else {
            try {
                return modelResource.getPrimaryMetamodelUri();
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return thePMURI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelType getModelTypeFromModelResource(ModelResource modelResource, boolean wrapInTransaction, Object source) {
        if (modelResource == null) return null;
        if (!modelResource.exists()) {
            return null;
        }
        ModelType modelType = null;
        if (wrapInTransaction) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Get Primary Metamodel URI", (Object)source);
            boolean succeeded = false;
            try {
                try {
                    modelType = modelResource.getModelType();
                    succeeded = true;
                    return modelType;
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log((Throwable)e);
                    if (!requiredStart) return modelType;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        return modelType;
                    }
                    ModelerCore.rollbackTxn();
                }
                return modelType;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        } else {
            try {
                return modelResource.getModelType();
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        return modelType;
    }

    public static String getPrimaryMetamodelURI(Object someResource) {
        if (someResource == null) {
            return null;
        }
        String thePMURI = null;
        boolean isXsdFile = false;
        File fileOnFileSystem = null;
        if (someResource instanceof IResource && someResource instanceof IFile) {
            IPath path;
            if (ModelUtilities.isModelFile((IResource)someResource) && (path = ((IResource)someResource).getLocation()) != null) {
                fileOnFileSystem = path.toFile();
            }
            isXsdFile = ModelIdentifier.isSchemaModel((IResource)someResource);
        } else if (someResource instanceof ModelResource) {
            IPath path;
            IResource theIResource = null;
            try {
                theIResource = ((ModelResource)someResource).getCorrespondingResource();
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log((Throwable)theException);
            }
            if (theIResource != null && (path = theIResource.getLocation()) != null) {
                fileOnFileSystem = path.toFile();
            }
            isXsdFile = ModelIdentifier.isSchemaModel((ModelResource)someResource);
        } else if (someResource instanceof File) {
            fileOnFileSystem = (File)someResource;
            isXsdFile = fileOnFileSystem.getName().endsWith("xsd");
        }
        if (fileOnFileSystem != null && fileOnFileSystem.exists()) {
            if (isXsdFile) {
                thePMURI = XML_SCHEMA_MODEL_URI;
            } else {
                XMIHeader header = ModelFileUtil.getXmiHeader((File)fileOnFileSystem);
                if (header != null) {
                    thePMURI = header.getPrimaryMetamodelURI();
                }
            }
        }
        return thePMURI;
    }

    public static String getModelType(Object someResource) {
        if (someResource == null) {
            return null;
        }
        String theModelType = null;
        boolean isXsdFile = false;
        File fileOnFileSystem = null;
        if (someResource instanceof IResource && someResource instanceof IFile) {
            IPath path;
            if (ModelUtilities.isModelFile((IResource)someResource) && (path = ((IResource)someResource).getLocation()) != null) {
                fileOnFileSystem = path.toFile();
            }
            isXsdFile = ModelIdentifier.isSchemaModel((IResource)someResource);
        } else if (someResource instanceof ModelResource) {
            IPath path;
            IResource theIResource = null;
            try {
                theIResource = ((ModelResource)someResource).getCorrespondingResource();
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log((Throwable)theException);
            }
            if (theIResource != null && (path = theIResource.getLocation()) != null) {
                fileOnFileSystem = path.toFile();
            }
            isXsdFile = ModelIdentifier.isSchemaModel((ModelResource)someResource);
        } else if (someResource instanceof File) {
            fileOnFileSystem = (File)someResource;
        }
        if (fileOnFileSystem != null && fileOnFileSystem.exists()) {
            if (isXsdFile) {
                theModelType = XML_SCHEMA_MODEL_TYPE.toString();
            } else {
                XMIHeader header = ModelFileUtil.getXmiHeader((File)fileOnFileSystem);
                if (header != null) {
                    theModelType = header.getModelType();
                }
            }
        }
        return theModelType;
    }

    public static boolean isModel(ModelResource modelResource, ModelType theModelType, String thePrimaryMetamodelUri) {
        boolean result = false;
        if (modelResource != null && modelResource.exists()) {
            try {
                if (modelResource.getUnderlyingResource() != null) {
                    return ModelIdentifier.isModel(modelResource.getUnderlyingResource(), theModelType, thePrimaryMetamodelUri);
                }
                if (ModelUtil.isXsdFile((IResource)modelResource.getUnderlyingResource())) {
                    result = true;
                } else if (theModelType != null) {
                    if (modelResource.getModelType().equals(theModelType) && modelResource.getPrimaryMetamodelDescriptor() != null && modelResource.getPrimaryMetamodelDescriptor().getNamespaceURI() != null && modelResource.getPrimaryMetamodelDescriptor().getNamespaceURI().equals(thePrimaryMetamodelUri)) {
                        result = true;
                    }
                } else if (modelResource.getPrimaryMetamodelDescriptor() != null && modelResource.getPrimaryMetamodelDescriptor().getNamespaceURI() != null && modelResource.getPrimaryMetamodelDescriptor().getNamespaceURI().equals(thePrimaryMetamodelUri)) {
                    result = true;
                }
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log((Throwable)theException);
            }
        }
        return result;
    }

    public static boolean isExtensionModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, EXTENSION_MODEL_TYPE, EXTENSION_MODEL_URI);
    }

    public static boolean isExtensionModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, EXTENSION_MODEL_TYPE, EXTENSION_MODEL_URI);
    }

    public static boolean isSchemaModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, XML_SCHEMA_MODEL_TYPE, XML_SCHEMA_MODEL_URI);
    }

    public static boolean isSchemaModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, XML_SCHEMA_MODEL_TYPE, XML_SCHEMA_MODEL_URI);
    }

    public static boolean isRelationalSourceModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, RELATIONAL_SOURCE_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relational");
    }

    public static boolean isRelationalSourceModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, RELATIONAL_SOURCE_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relational");
    }

    public static boolean isRelationalViewModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, RELATIONAL_VIEW_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relational");
    }

    public static boolean isRelationalViewModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, RELATIONAL_VIEW_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relational");
    }

    public static boolean isXmlViewModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, XML_VIEW_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlDocument");
    }

    public static boolean isXmlViewModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, XML_VIEW_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlDocument");
    }

    public static boolean isXmlViewModel(String theURI) {
        return "http://www.metamatrix.com/metamodels/XmlDocument".equalsIgnoreCase(theURI);
    }

    public static boolean isWebServicesViewModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, WEB_SERVICES_MODEL_TYPE, WEB_SERVICES_VIEW_MODEL_URI);
    }

    public static boolean isWebServicesViewModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, WEB_SERVICES_MODEL_TYPE, WEB_SERVICES_VIEW_MODEL_URI);
    }

    public static boolean isWebServicesViewModel(String theURI) {
        return WEB_SERVICES_VIEW_MODEL_URI.equalsIgnoreCase(theURI);
    }

    public static boolean isLogicalModel(IResource theResource) {
        if (theResource != null && theResource instanceof IFile && theResource.exists() && ModelUtilities.isModelFile(theResource)) {
            XMIHeader header;
            File resourceFile;
            if (ModelIdentifier.isUmlModel(theResource)) {
                return true;
            }
            if (ModelIdentifier.isExtensionModel(theResource)) {
                return true;
            }
            if (ModelIdentifier.isRelationshipModel(theResource)) {
                return true;
            }
            if (ModelIdentifier.isFunctionModel(theResource)) {
                return true;
            }
            if (ModelIdentifier.isPeopleModel(theResource)) {
                return true;
            }
            if (ModelIdentifier.isXmlMessageStructureModel(theResource)) {
                return true;
            }
            IPath path = theResource.getLocation();
            if (path != null && (resourceFile = path.toFile()).exists() && (header = ModelFileUtil.getXmiHeader((File)resourceFile)) != null && header.getModelType() != null) {
                return header.getModelType().equals(LOGICAL_MODEL_TYPE.getName());
            }
        }
        return false;
    }

    public static boolean isLogicalModel(ModelResource modelResource) {
        if (ModelIdentifier.isModel(modelResource, LOGICAL_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relationship")) {
            return true;
        }
        if (ModelIdentifier.isUmlModel(modelResource)) {
            return true;
        }
        if (ModelIdentifier.isExtensionModel(modelResource)) {
            return true;
        }
        if (ModelIdentifier.isRelationshipModel(modelResource)) {
            return true;
        }
        if (ModelIdentifier.isFunctionModel(modelResource)) {
            return true;
        }
        if (ModelIdentifier.isPeopleModel(modelResource)) {
            return true;
        }
        return ModelIdentifier.isXmlMessageStructureModel(modelResource);
    }

    public static boolean isRelationshipModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, LOGICAL_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relationship");
    }

    public static boolean isRelationshipModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, LOGICAL_MODEL_TYPE, "http://www.metamatrix.com/metamodels/Relationship");
    }

    public static boolean isPeopleModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, LOGICAL_MODEL_TYPE, PEOPLE_MODEL_URI);
    }

    public static boolean isUmlModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, LOGICAL_MODEL_TYPE, UML_MODEL_URI);
    }

    public static boolean isUmlModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, LOGICAL_MODEL_TYPE, UML_MODEL_URI);
    }

    public static boolean isPeopleModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, LOGICAL_MODEL_TYPE, PEOPLE_MODEL_URI);
    }

    public static boolean isFunctionModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, null, FUNCTION_MODEL_URI);
    }

    public static boolean isFunctionModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, null, FUNCTION_MODEL_URI);
    }

    public static boolean isFunctionModelUri(String theURI) {
        return FUNCTION_MODEL_URI.equalsIgnoreCase(theURI);
    }

    public static boolean isXmlServiceSourceModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, XML_SERVICE_SOURCE_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlService");
    }

    public static boolean isXmlServiceSourceModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, XML_SERVICE_SOURCE_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlService");
    }

    public static boolean isXmlServiceViewModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, XML_SERVICE_VIEW_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlService");
    }

    public static boolean isXmlServiceViewModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, XML_SERVICE_VIEW_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlService");
    }

    public static boolean isXmlMessageStructureModel(IResource theResource) {
        return ModelIdentifier.isModel(theResource, XML_MESSAGE_STRUCTURE_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlDocument");
    }

    public static boolean isXmlMessageStructureModel(ModelResource modelResource) {
        return ModelIdentifier.isModel(modelResource, XML_MESSAGE_STRUCTURE_MODEL_TYPE, "http://www.metamatrix.com/metamodels/XmlDocument");
    }

    public static ModelType getModelType(IResource theResource) {
        File resourceFile;
        IPath path;
        if (theResource != null && theResource instanceof IFile && theResource.exists() && (path = theResource.getLocation()) != null && (resourceFile = path.toFile()).exists()) {
            XMIHeader header = ModelFileUtil.getXmiHeader((File)resourceFile);
            if (header != null && header.getModelType() != null) {
                String theModelType = header.getModelType();
                return ModelType.get((String)theModelType);
            }
            if (ModelUtil.isXsdFile((IResource)theResource)) {
                return XML_SCHEMA_MODEL_TYPE;
            }
        }
        return ModelType.UNKNOWN_LITERAL;
    }

    public static ModelType getModelType(ModelResource modelResource) {
        if (modelResource != null && modelResource.exists()) {
            try {
                if (modelResource.getUnderlyingResource() != null) {
                    return ModelIdentifier.getModelType(modelResource.getUnderlyingResource());
                }
                if (modelResource.getModelType() != null) {
                    return modelResource.getModelType();
                }
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log((Throwable)theException);
            }
        }
        return ModelType.UNKNOWN_LITERAL;
    }

    public static boolean isVirtualModelType(ModelResource modelResource) {
        return ModelIdentifier.getModelType(modelResource).equals(ModelType.VIRTUAL_LITERAL);
    }

    public static boolean isPhysicalModelType(ModelResource modelResource) {
        return ModelIdentifier.getModelType(modelResource).equals(ModelType.PHYSICAL_LITERAL);
    }

    public static boolean isLogicalModelType(ModelResource modelResource) {
        return ModelIdentifier.getModelType(modelResource).equals(ModelType.LOGICAL_LITERAL);
    }

    public static boolean isVirtualModelType(IResource theResource) {
        return ModelIdentifier.getModelType(theResource).equals(ModelType.VIRTUAL_LITERAL);
    }

    public static boolean isPhysicalModelType(IResource theResource) {
        return ModelIdentifier.getModelType(theResource).equals(ModelType.PHYSICAL_LITERAL);
    }

    public static boolean isLogicalModelType(IResource theResource) {
        return ModelIdentifier.getModelType(theResource).equals(ModelType.LOGICAL_LITERAL);
    }

    public static Image getModelImage(ModelResource modelResource) {
        if (modelResource != null && modelResource.exists()) {
            try {
                if (ModelUtil.isXsdFile((IResource)modelResource.getCorrespondingResource())) {
                    return UiPlugin.getDefault().getImage(XML_SCHEMA_MODEL_IMAGE_ID);
                }
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log((Throwable)theException);
            }
        }
        int modelID = ModelIdentifier.getModelID(modelResource);
        return ModelIdentifier.getImage(modelID);
    }

    public static Image getModelImage(IResource theResource) {
        if (theResource != null && theResource.exists() && ModelUtil.isXsdFile((IResource)theResource)) {
            return UiPlugin.getDefault().getImage(XML_SCHEMA_MODEL_IMAGE_ID);
        }
        int modelID = ModelIdentifier.getModelID(theResource);
        return ModelIdentifier.getImage(modelID);
    }

    public static Image getImage(int modelID) {
        Image modelImage = null;
        switch (modelID) {
            case 0: {
                modelImage = UiPlugin.getDefault().getImage("icons/full/obj16/Model.gif");
                break;
            }
            case 4: {
                modelImage = UiPlugin.getDefault().getImage(RELATIONAL_VIEW_MODEL_IMAGE_ID);
                break;
            }
            case 5: {
                modelImage = UiPlugin.getDefault().getImage(XML_VIEW_MODEL_IMAGE_ID);
                break;
            }
            case 1: {
                modelImage = UiPlugin.getDefault().getImage(EXTENSION_MODEL_IMAGE_ID);
                break;
            }
            case 2: {
                modelImage = UiPlugin.getDefault().getImage(FUNCTION_MODEL_IMAGE_ID);
                break;
            }
            case 7: {
                modelImage = UiPlugin.getDefault().getImage(XML_SCHEMA_MODEL_IMAGE_ID);
                break;
            }
            case 3: {
                modelImage = UiPlugin.getDefault().getImage(LOGICAL_MODEL_IMAGE_ID);
                break;
            }
            case 6: {
                modelImage = UiPlugin.getDefault().getImage(WEB_SERVICES_VIEW_MODEL_IMAGE_ID);
                break;
            }
            case 8: {
                modelImage = UiPlugin.getDefault().getImage(XML_SERVICE_SOURCE_MODEL_IMAGE_ID);
                break;
            }
            case 9: {
                modelImage = UiPlugin.getDefault().getImage(XML_SERVICE_VIEW_MODEL_IMAGE_ID);
                break;
            }
            case 10: {
                modelImage = UiPlugin.getDefault().getImage(RELATIONSHIP_MODEL_IMAGE_ID);
                break;
            }
            case 11: {
                modelImage = UiPlugin.getDefault().getImage(PEOPLE_MODEL_IMAGE_ID);
                break;
            }
            case 12: {
                modelImage = UiPlugin.getDefault().getImage(UML_MODEL_IMAGE_ID);
                break;
            }
            case 13: {
                modelImage = UiPlugin.getDefault().getImage(XML_MESSAGE_STRUCTURE_MODEL_IMAGE_ID);
                break;
            }
            case 14: {
                modelImage = UiPlugin.getDefault().getImage(VDB_SOURCE_MODEL_IMAGE_ID);
                break;
            }
            default: {
                modelImage = UiPlugin.getDefault().getImage("icons/full/obj16/Model.gif");
            }
        }
        return modelImage;
    }

    private static int getModelID(IResource theResource) {
        if (theResource != null && theResource instanceof IFile && theResource.exists()) {
            if (ModelIdentifier.isSchemaModel(theResource)) {
                return 7;
            }
            if (ModelIdentifier.isRelationalSourceModel(theResource)) {
                ModelResource mr = ModelUtilities.getModelResourceForIFile((IFile)theResource, true);
                if (mr != null && ModelUtilities.isVdbSourceModel(mr)) {
                    return 14;
                }
                return 0;
            }
            if (ModelIdentifier.isExtensionModel(theResource)) {
                return 1;
            }
            if (ModelIdentifier.isRelationalViewModel(theResource)) {
                return 4;
            }
            if (ModelIdentifier.isXmlViewModel(theResource)) {
                return 5;
            }
            if (ModelIdentifier.isFunctionModel(theResource)) {
                return 2;
            }
            if (ModelIdentifier.isWebServicesViewModel(theResource)) {
                return 6;
            }
            if (ModelIdentifier.isXmlServiceSourceModel(theResource)) {
                return 8;
            }
            if (ModelIdentifier.isXmlServiceViewModel(theResource)) {
                return 9;
            }
            if (ModelIdentifier.isUmlModel(theResource)) {
                return 12;
            }
            if (ModelIdentifier.isRelationshipModel(theResource)) {
                return 10;
            }
            if (ModelIdentifier.isPeopleModel(theResource)) {
                return 11;
            }
            if (ModelIdentifier.isXmlMessageStructureModel(theResource)) {
                return 13;
            }
            if (ModelIdentifier.isLogicalModel(theResource)) {
                return 3;
            }
        }
        return -1;
    }

    private static int getModelID(ModelResource modelResource) {
        if (modelResource != null && modelResource.exists()) {
            if (ModelIdentifier.isSchemaModel(modelResource)) {
                return 7;
            }
            if (ModelIdentifier.isRelationalSourceModel(modelResource)) {
                if (ModelUtilities.isVdbSourceModel(modelResource)) {
                    return 14;
                }
                return 0;
            }
            if (ModelIdentifier.isExtensionModel(modelResource)) {
                return 1;
            }
            if (ModelIdentifier.isRelationalViewModel(modelResource)) {
                return 4;
            }
            if (ModelIdentifier.isXmlViewModel(modelResource)) {
                return 5;
            }
            if (ModelIdentifier.isFunctionModel(modelResource)) {
                return 2;
            }
            if (ModelIdentifier.isWebServicesViewModel(modelResource)) {
                return 6;
            }
            if (ModelIdentifier.isXmlServiceSourceModel(modelResource)) {
                return 8;
            }
            if (ModelIdentifier.isXmlServiceViewModel(modelResource)) {
                return 9;
            }
            if (ModelIdentifier.isUmlModel(modelResource)) {
                return 12;
            }
            if (ModelIdentifier.isRelationshipModel(modelResource)) {
                return 10;
            }
            if (ModelIdentifier.isPeopleModel(modelResource)) {
                return 11;
            }
            if (ModelIdentifier.isXmlMessageStructureModel(modelResource)) {
                return 13;
            }
            if (ModelIdentifier.isLogicalModel(modelResource)) {
                return 3;
            }
        }
        return -1;
    }
}

