/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ModelInitializerSelectionDialog
extends ListDialog
implements IStructuredContentProvider {
    private static final String TITLE = UiConstants.Util.getString("ModelInitializerSelectionDialog.title", new Object[0]);
    private static final String MESSAGE = UiConstants.Util.getString("ModelInitializerSelectionDialog.message", new Object[0]);
    private static final String DESCRIPTION = UiConstants.Util.getString("ModelInitializerSelectionDialog.description", new Object[0]);
    MetamodelDescriptor descriptor;
    Text description;
    private Object dialogInput;

    public ModelInitializerSelectionDialog(Shell parentShell, MetamodelDescriptor descriptor) {
        super(parentShell);
        this.descriptor = descriptor;
        super.setContentProvider((IStructuredContentProvider)this);
        super.setLabelProvider((ILabelProvider)new LabelProvider());
        super.setInput((Object)descriptor);
        this.dialogInput = descriptor;
        super.setAddCancelButton(false);
        super.setTitle(TITLE);
        super.setMessage(MESSAGE);
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        return this.descriptor.getModelInitializerNames().toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        super.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String name = (String)SelectionUtilities.getSelectedObject((ISelection)event.getSelection());
                if (name != null) {
                    ModelInitializerSelectionDialog.this.description.setText(ModelInitializerSelectionDialog.this.descriptor.getModelInitializerDescription(name));
                } else {
                    ModelInitializerSelectionDialog.this.description.setText("");
                }
            }
        });
        WidgetFactory.createLabel((Composite)parent, (String)DESCRIPTION);
        this.description = WidgetFactory.createTextField((Composite)parent, (int)768);
        this.description.setEditable(false);
        this.setInitialDescription();
        return control;
    }

    public void setInitialSelection() {
        ArrayList<Object> initialSelectionList = new ArrayList<Object>(1);
        Object[] listObjects = this.getElements(this.dialogInput);
        initialSelectionList.add(listObjects[0]);
        this.setInitialElementSelections(initialSelectionList);
    }

    protected void setInitialDescription() {
        Object[] listObjects = this.getElements(this.dialogInput);
        String name = (String)listObjects[0];
        if (name != null) {
            this.description.setText(this.descriptor.getModelInitializerDescription(name));
        } else {
            this.description.setText("");
        }
    }
}

