/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelLabelProvider
extends LabelProvider
implements PluginConstants.Images {
    private ILabelProvider workbenchProvider = new WorkbenchLabelProvider();
    private boolean fullpath = false;

    public Image getImage(Object element) {
        if (element instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)element))) {
            try {
                ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)false);
                if (modelResource == null) {
                    return this.workbenchProvider.getImage(element);
                }
                Image image = ModelIdentifier.getModelImage(modelResource);
                if (image != null) {
                    return image;
                }
                return UiPlugin.getDefault().getImage("icons/full/obj16/Model.gif");
            }
            catch (ModelWorkspaceException e) {
                e.printStackTrace();
            }
        }
        return this.workbenchProvider.getImage(element);
    }

    public String getText(Object element) {
        if (this.fullpath) {
            if (element instanceof IResource) {
                return ((IResource)element).getFullPath().makeRelative().toString();
            }
        } else if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        return super.getText(element);
    }

    public void setFullpath(boolean showPath) {
        this.fullpath = showPath;
    }
}

