/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.PresentationEntity;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.ExtendedModelObjectContentProvider;
import org.teiid.designer.ui.viewsupport.IExtendedModelObject;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class ModelObjectContentProvider
implements ITreeContentProvider,
UiConstants.ExtensionPoints.DiagramContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static ModelObjectContentProvider theInstance;
    private static final ArrayList diagramProviders;
    private static final HashMap diagramProviderIdMap;
    private static ExtendedModelObjectContentProvider extendedContentProvider;
    private static boolean IGNORE_DIAGRAMS;

    static {
        diagramProviders = new ArrayList();
        diagramProviderIdMap = new HashMap();
        extendedContentProvider = new ExtendedModelObjectContentProvider();
        IGNORE_DIAGRAMS = false;
    }

    public static ModelObjectContentProvider getInstance() {
        if (theInstance == null) {
            theInstance = new ModelObjectContentProvider();
            theInstance.loadProviderList();
        }
        return theInstance;
    }

    private ModelObjectContentProvider() {
    }

    private void loadProviderList() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "diagramContentProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                ITreeContentProvider contentProvider = null;
                int j = 0;
                while (j < elements.length) {
                    Object provider;
                    if (elements[j].getName().equals("class") && (provider = elements[j].createExecutableExtension("name")) instanceof ITreeContentProvider) {
                        contentProvider = (ITreeContentProvider)provider;
                        diagramProviders.add(provider);
                        break;
                    }
                    ++j;
                }
                j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("diagramType")) {
                        String type = elements[j].getAttribute("name");
                        diagramProviderIdMap.put(type, contentProvider);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelObjectContentProvider.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }

    private static ArrayList getDiagramChildren(Object parentElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (ModelObjectContentProvider.isXsdObject(parentElement)) {
            return result;
        }
        if (ModelObjectContentProvider.isViewProcedureFunction(parentElement)) {
            return result;
        }
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)true, null, (Object)theInstance);
        boolean succeeded = false;
        try {
            for (ITreeContentProvider provider : diagramProviders) {
                try {
                    Object[] diagrams = provider.getChildren(parentElement);
                    if (diagrams == null || diagrams.length <= 0) continue;
                    result.addAll(Arrays.asList(diagrams));
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("ModelObjectContentProvider.diagramProviderErrorMessage", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
            succeeded = true;
        }
        finally {
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return result;
    }

    private static boolean isXsdObject(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ModelResource) {
            return ((ModelResource)obj).isXsd();
        }
        if (obj instanceof EObject) {
            Resource rsrc = ((EObject)obj).eResource();
            return ModelUtil.isXsdFile((Resource)rsrc);
        }
        if (obj instanceof Resource) {
            return ModelUtil.isXsdFile((Resource)((Resource)obj));
        }
        return false;
    }

    private static boolean isViewProcedureFunction(Object obj) {
        boolean isViewProcFunction = false;
        if (obj == null || !(obj instanceof Procedure)) {
            return isViewProcFunction;
        }
        if (ModelUtil.isVirtual((Object)obj) && ((Procedure)obj).isFunction()) {
            isViewProcFunction = true;
        }
        return isViewProcFunction;
    }

    public synchronized Object[] getChildren(Object parentElement) {
        Object[] children;
        block15: {
            children = NO_CHILDREN;
            try {
                if (parentElement instanceof PresentationEntity || !(parentElement instanceof EObject) && !(parentElement instanceof ModelResource)) break block15;
                Object[] emfChildren = null;
                if (parentElement instanceof EObject) {
                    emfChildren = ModelUtilities.getModelContentProvider().getChildren(parentElement);
                } else {
                    try {
                        emfChildren = ((ModelResource)parentElement).getEObjects().toArray();
                    }
                    catch (ModelWorkspaceException exception) {
                        if (((ModelResource)parentElement).hasErrors()) {
                            return children;
                        }
                        throw exception;
                    }
                }
                Object[] extendedChildren = extendedContentProvider.getChildren(parentElement);
                int totalChildren = emfChildren.length;
                if (extendedChildren != null && extendedChildren.length > 0) {
                    totalChildren += extendedChildren.length;
                }
                Object[] tmpChildren = new Object[totalChildren];
                int i = 0;
                while (i < emfChildren.length) {
                    tmpChildren[i] = emfChildren[i];
                    ++i;
                }
                if (extendedChildren != null && extendedChildren.length > 0) {
                    int theIndex = emfChildren.length;
                    int i2 = 0;
                    while (i2 < extendedChildren.length) {
                        tmpChildren[theIndex++] = extendedChildren[i2];
                        ++i2;
                    }
                }
                if (IGNORE_DIAGRAMS) {
                    return tmpChildren;
                }
                ArrayList diagramList = ModelObjectContentProvider.getDiagramChildren(parentElement);
                if (diagramList.isEmpty()) {
                    children = tmpChildren;
                } else {
                    ArrayList<Object> allChildren = new ArrayList<Object>(diagramList);
                    int i3 = 0;
                    while (i3 < tmpChildren.length) {
                        allChildren.add(tmpChildren[i3]);
                        ++i3;
                    }
                    children = allChildren.toArray();
                }
            }
            catch (CoreException coreException) {
                children = NO_CHILDREN;
            }
        }
        return children;
    }

    public synchronized Object[] getSortedChildren(Object parentElement) {
        Object[] children;
        block19: {
            children = NO_CHILDREN;
            try {
                if (parentElement instanceof PresentationEntity || !(parentElement instanceof EObject) && !(parentElement instanceof ModelResource)) break block19;
                Object[] emfChildren = null;
                if (parentElement instanceof EObject) {
                    emfChildren = ModelUtilities.getModelContentProvider().getChildren(parentElement);
                } else {
                    try {
                        emfChildren = ((ModelResource)parentElement).getEObjects().toArray();
                    }
                    catch (ModelWorkspaceException exception) {
                        if (((ModelResource)parentElement).hasErrors()) {
                            return children;
                        }
                        throw exception;
                    }
                }
                ArrayList<String> eClasses = new ArrayList<String>();
                ArrayList<NameValuePair> nameValueList = new ArrayList<NameValuePair>(emfChildren.length);
                int i = 0;
                while (i < emfChildren.length) {
                    Object child = emfChildren[i];
                    if (child instanceof EObject) {
                        EObject eObj = (EObject)child;
                        String name = ModelerCore.getModelEditor().getName(eObj);
                        String eClassName = eObj.eClass().getName();
                        nameValueList.add(new NameValuePair(name, eObj, eClassName));
                        if (!eClasses.contains(eClassName)) {
                            eClasses.add(eClassName);
                        }
                    }
                    ++i;
                }
                List sortedNameValueList = this.sortNameValueList(nameValueList, eClasses);
                Object[] sortedChildren = new Object[sortedNameValueList.size()];
                int i2 = 0;
                while (i2 < sortedNameValueList.size()) {
                    NameValuePair nvPair = (NameValuePair)sortedNameValueList.get(i2);
                    sortedChildren[i2] = nvPair.getValue();
                    ++i2;
                }
                Object[] extendedChildren = extendedContentProvider.getChildren(parentElement);
                int totalChildren = emfChildren.length;
                if (extendedChildren != null && extendedChildren.length > 0) {
                    totalChildren += extendedChildren.length;
                }
                Object[] tmpChildren = new Object[totalChildren];
                int i3 = 0;
                while (i3 < sortedChildren.length) {
                    tmpChildren[i3] = sortedChildren[i3];
                    ++i3;
                }
                if (extendedChildren != null && extendedChildren.length > 0) {
                    int theIndex = sortedChildren.length;
                    int i4 = 0;
                    while (i4 < extendedChildren.length) {
                        tmpChildren[theIndex++] = extendedChildren[i4];
                        ++i4;
                    }
                }
                if (IGNORE_DIAGRAMS) {
                    return sortedChildren;
                }
                ArrayList diagramList = ModelObjectContentProvider.getDiagramChildren(parentElement);
                if (diagramList.isEmpty()) {
                    children = tmpChildren;
                } else {
                    ArrayList<Object> allChildren = new ArrayList<Object>(diagramList);
                    int i5 = 0;
                    while (i5 < tmpChildren.length) {
                        allChildren.add(tmpChildren[i5]);
                        ++i5;
                    }
                    children = allChildren.toArray();
                }
            }
            catch (CoreException coreException) {
                children = NO_CHILDREN;
            }
        }
        return children;
    }

    private List sortNameValueList(List nameValueList, List eClassList) {
        ArrayList resultList = new ArrayList(nameValueList.size());
        for (String currentEClass : eClassList) {
            if (currentEClass == null) continue;
            ArrayList<NameValuePair> nameValueSubList = new ArrayList<NameValuePair>(nameValueList.size());
            for (NameValuePair nvPair : nameValueList) {
                if (!currentEClass.equals(nvPair.getEClassName())) continue;
                nameValueSubList.add(nvPair);
            }
            Collections.sort(nameValueSubList);
            resultList.addAll(nameValueSubList);
        }
        return resultList;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        Object result = null;
        if (element instanceof Diagram) {
            ITreeContentProvider provider;
            String type = ((Diagram)element).getType();
            if (type != null && (provider = (ITreeContentProvider)diagramProviderIdMap.get(type)) != null) {
                try {
                    result = provider.getParent(element);
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("ModelObjectContentProvider.diagramProviderErrorMessage", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
            }
        } else if (element instanceof EObject) {
            result = ModelUtilities.getModelContentProvider().getParent(element);
            if (result instanceof ModelResource) {
                result = ((ModelResource)result).getResource();
            } else if (result instanceof Resource && (result = ModelerCore.getModelEditor().findModelResource((Resource)result)) != null) {
                result = ((ModelResource)result).getResource();
            }
        } else if (extendedContentProvider.getParent(element) != null) {
            result = extendedContentProvider.getParent(element);
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.hasChildren(element, false);
    }

    private boolean hasChildren(Object parentElement, boolean dummyBoolean) {
        if (parentElement instanceof PresentationEntity) {
            return false;
        }
        if (parentElement instanceof EObject || parentElement instanceof ModelResource) {
            block13: {
                block12: {
                    block11: {
                        if (!(parentElement instanceof EObject)) break block11;
                        if (ModelUtilities.getModelContentProvider().hasChildren(parentElement)) {
                            return true;
                        }
                        break block12;
                    }
                    if (((ModelResource)parentElement).getEObjects().size() <= 0) break block12;
                    return true;
                }
                if (!this.hasDiagramChildren(parentElement)) break block13;
                return true;
            }
            try {
                if (ModelObjectContentProvider.getDiagramChildren(parentElement).size() > 0) {
                    return true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (parentElement instanceof IExtendedModelObject) {
            return extendedContentProvider.hasChildren(parentElement);
        }
        return false;
    }

    private boolean hasDiagramChildren(Object parentElement) {
        if (ModelObjectContentProvider.isXsdObject(parentElement)) {
            return false;
        }
        for (ITreeContentProvider provider : diagramProviders) {
            if (!provider.hasChildren(parentElement)) continue;
            return true;
        }
        return false;
    }

    class NameValuePair
    implements Comparable {
        private String name;
        private String eClassName;
        private Object value;

        public NameValuePair(String name, Object value, String eClassName) {
            this.name = name;
            this.value = value;
            this.eClassName = eClassName;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String getEClassName() {
            return this.eClassName;
        }

        public int compareTo(Object o) {
            int result = -1;
            if (o instanceof NameValuePair) {
                NameValuePair col2 = (NameValuePair)o;
                result = this.name == null ? (col2.getName() == null ? 0 : -1) : (col2.getName() == null ? 1 : this.getName().compareToIgnoreCase(col2.getName()));
            }
            return result;
        }
    }
}

