/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.IModelObjectEditHelper;

public abstract class ModelObjectEditHelperManager {
    private static HashMap editHelpers;
    private static boolean helpersLoaded;

    static {
        helpersLoaded = false;
    }

    public static boolean canRename(Object obj) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canRename(obj);
        }
        return oK;
    }

    public static boolean canCopy(Object obj) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canCopy(obj);
        }
        return oK;
    }

    public static boolean canCut(Object obj) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canCut(obj);
        }
        return oK;
    }

    public static boolean canUndoCut(Object obj) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canUndoCut(obj);
        }
        return oK;
    }

    public static boolean canDelete(Object obj) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canDelete(obj);
        }
        return oK;
    }

    public static boolean canUndoDelete(Object obj) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canUndoDelete(obj);
        }
        return oK;
    }

    public static boolean canClone(Object obj) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canClone(obj);
        }
        return oK;
    }

    public static boolean canPaste(Object obj, Object pasteParent) {
        if (!helpersLoaded) {
            ModelObjectEditHelperManager.loadHelperExtensions();
        }
        boolean oK = true;
        Iterator iter = editHelpers.values().iterator();
        IModelObjectEditHelper helper = null;
        while (iter.hasNext() && oK) {
            helper = (IModelObjectEditHelper)iter.next();
            oK = helper.canPaste(obj, pasteParent);
        }
        return oK;
    }

    private static void loadHelperExtensions() {
        editHelpers = new HashMap();
        helpersLoaded = true;
        String id = "modelObjectEditHelper";
        String classTag = "class";
        String className = "name";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", id);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object helper;
                    if (elements[j].getName().equals(classTag) && (helper = elements[j].createExecutableExtension(className)) instanceof IModelObjectEditHelper) {
                        String sThisClassName = elements[j].getAttribute(className);
                        editHelpers.put(sThisClassName, helper);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelerActionService.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }
}

