/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelObjectAnnotationHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelObjectLabelProvider
extends LabelProvider
implements ILightweightLabelDecorator,
UiConstants,
PluginConstants.Images {
    private static final String SUFFIX_EXCLUDED = Util.getString("ModelObjectLabelProvider.suffixExcluded", new Object[0]);
    private static final Color TEMP_COLOR = GlobalUiColorManager.getColor((RGB)new RGB(247, 247, 247));
    private static final Color PHYSICAL_COLOR = GlobalUiColorManager.getColor((RGB)new RGB(0, 180, 255));
    private static final Color LOGICAL_COLOR = GlobalUiColorManager.getColor((RGB)new RGB(0, 220, 152));
    private static final Color VIRTUAL_COLOR = GlobalUiColorManager.getColor((RGB)new RGB(255, 255, 156));
    static Color gray = null;
    private ILabelProvider delegate = ModelUtilities.getAdapterFactoryLabelProvider();

    public Image getImage(Object theElement) {
        Image result;
        block13: {
            result = null;
            if (theElement instanceof XSDSimpleTypeDefinition) {
                try {
                    if (ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)((XSDSimpleTypeDefinition)theElement))) {
                        result = UiPlugin.getDefault().getImage("icons/full/obj16/BuiltinDatatype.gif");
                        break block13;
                    }
                    result = this.delegate.getImage(theElement);
                }
                catch (Exception exception) {
                    result = this.delegate.getImage(theElement);
                }
            } else if (theElement instanceof EObject) {
                EObject eObj = (EObject)theElement;
                Image temp = this.delegate.getImage(theElement);
                if (ModelObjectUtilities.isVdbSourceModel(eObj)) {
                    if (eObj instanceof Table) {
                        temp = UiPlugin.getDefault().getImage("icons/full/obj16/table-vdb-source.png");
                    } else if (eObj instanceof Procedure) {
                        temp = UiPlugin.getDefault().getImage("icons/full/obj16/procedure-vdb-source.png");
                    }
                }
                boolean virtual = ModelObjectUtilities.isVirtual(eObj);
                boolean logical = ModelObjectUtilities.isLogical(eObj);
                boolean extension = ModelObjectUtilities.isExtension(eObj);
                boolean function = ModelObjectUtilities.isFunction(eObj);
                String prefix = virtual ? "virtual." : "physical.";
                String imageId = String.valueOf(prefix) + temp.hashCode();
                UiPlugin plugin = UiPlugin.getDefault();
                if (plugin.isImageRegistered(imageId)) {
                    result = plugin.getImage(imageId);
                } else {
                    result = virtual ? UiUtil.createImage((Image)temp, (Color)TEMP_COLOR, (Color)VIRTUAL_COLOR) : (logical || extension || function ? UiUtil.createImage((Image)temp, (Color)TEMP_COLOR, (Color)LOGICAL_COLOR) : UiUtil.createImage((Image)temp, (Color)TEMP_COLOR, (Color)PHYSICAL_COLOR));
                    plugin.registerPluginImage(imageId, result);
                }
            } else {
                result = this.delegate.getImage(theElement);
            }
        }
        return result;
    }

    public Image getImage(EObject theElement, boolean isVirtual) {
        Image result;
        block7: {
            result = null;
            if (theElement instanceof XSDSimpleTypeDefinition) {
                try {
                    if (ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype(theElement)) {
                        result = UiPlugin.getDefault().getImage("icons/full/obj16/BuiltinDatatype.gif");
                        break block7;
                    }
                    result = this.delegate.getImage((Object)theElement);
                }
                catch (Exception exception) {
                    result = this.delegate.getImage((Object)theElement);
                }
            } else {
                Image temp = this.delegate.getImage((Object)theElement);
                String prefix = isVirtual ? "virtual." : "physical.";
                String imageId = String.valueOf(prefix) + temp.hashCode();
                UiPlugin plugin = UiPlugin.getDefault();
                if (plugin.isImageRegistered(imageId)) {
                    result = plugin.getImage(imageId);
                } else {
                    result = UiUtil.createImage((Image)temp, (Color)TEMP_COLOR, (Color)(isVirtual ? VIRTUAL_COLOR : PHYSICAL_COLOR));
                    plugin.registerPluginImage(imageId, result);
                }
            }
        }
        return result;
    }

    public String getText(Object theElement) {
        return StringUtilities.replaceWhitespace((String)this.delegate.getText(theElement), (boolean)true);
    }

    public void decorate(Object element, IDecoration decoration) {
        EObject datatype;
        IMarker[] markers;
        ImageDescriptor decorationIcon;
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        IResource resrc = this.getResource(element);
        if (resrc == null || !resrc.exists() || resrc instanceof IProject && !((IProject)resrc).isOpen()) {
            return;
        }
        IMarker[] mrkrs = null;
        boolean errorOccurred = false;
        try {
            mrkrs = resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        }
        catch (CoreException ex) {
            Util.log((Throwable)ex);
            errorOccurred = true;
        }
        if (!errorOccurred && (decorationIcon = this.getDecorationIcon((EObject)element, resrc, markers = mrkrs)) != null) {
            decoration.addOverlay(decorationIcon);
        }
        if (gray == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    gray = UiUtil.getSystemColor((int)15);
                }
            });
        }
        if (element instanceof EObject) {
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            try {
                for (ModelExtensionAssistant assistant : registry.getModelExtensionAssistants(element.getClass().getName())) {
                    if (assistant.getModelExtensionDefinition().isBuiltIn() || !(assistant instanceof ModelObjectExtensionAssistant) || ((ModelObjectExtensionAssistant)assistant).getPropertyDefinitions(element).isEmpty()) continue;
                    decoration.addOverlay(UiPlugin.getDefault().getExtensionDecoratorImage(), 0);
                    break;
                }
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
        if (XmlDocumentUtil.isExcluded((Object)element, (boolean)true)) {
            decoration.setForegroundColor(gray);
            if (XmlDocumentUtil.isExcluded((Object)element, (boolean)false)) {
                decoration.addSuffix(SUFFIX_EXCLUDED);
            }
        }
        if (TransformationHelper.isSqlColumn((Object)element) && (datatype = DatatypeUtilities.getSqlColumnDatatype((EObject)element)) != null && ModelerCore.getDatatypeManager((EObject)datatype, (boolean)true).isEnumeration(datatype)) {
            ImageDescriptor enumIcon = UiPlugin.getDefault().getImageDescriptor("icons/full/ovr16/enum_co.gif");
            decoration.addOverlay(enumIcon, 3);
        }
        ModelObjectAnnotationHelper moah = new ModelObjectAnnotationHelper();
        try {
            if (moah.hasExtensionProperties(element)) {
                decoration.addOverlay(UiPlugin.getDefault().getExtensionDecoratorImage(), 0);
            }
        }
        catch (ModelerCoreException e) {
            Util.log((Throwable)e);
        }
    }

    private ImageDescriptor getDecorationIcon(EObject element, IResource resrc, IMarker[] markers) {
        ImageDescriptor icon = null;
        int ndx = markers.length;
        while (--ndx >= 0) {
            Object attr;
            boolean usable;
            IMarker marker = markers[ndx];
            EObject targetEObject = ModelWorkspaceManager.getModelWorkspaceManager().getMarkerManager().getMarkedEObject(resrc, marker);
            boolean bl = usable = element == targetEObject || ModelObjectUtilities.isDescendant(element, targetEObject);
            if (!usable || (attr = MarkerUtilities.getMarkerAttribute(marker, "severity")) == null) continue;
            int severity = (Integer)attr;
            if (severity == 2) {
                icon = UiPlugin.getDefault().getErrorDecoratorImage();
                break;
            }
            if (icon != null || severity != 1) continue;
            icon = UiPlugin.getDefault().getWarningDecoratorImage();
        }
        return icon;
    }

    private IResource getResource(Object element) {
        if (element instanceof EObject) {
            IResource ir = null;
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)element);
            if (modelResource != null) {
                ir = modelResource.getResource();
            }
            return ir;
        }
        return null;
    }
}

