/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.viewers.deferred.AbstractConcurrentModel;
import org.eclipse.jface.viewers.deferred.DeferredContentProvider;
import org.eclipse.jface.viewers.deferred.IConcurrentModelListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.filter.StructuredViewerTextFilterer;
import org.teiid.designer.ui.viewsupport.IFilter;
import org.teiid.designer.ui.viewsupport.TextCachingLabelProvider;

public class ModelObjectListDialog
extends ListDialog
implements IFilter.IConstants,
ISelectionChangedListener {
    private static final String EMPTY_STRING = "";
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ModelObjectListDialog.class);
    private static final String MESSAGE_ID = String.valueOf(PREFIX) + "selectMessage";
    private static final String BUTTON_NULL = UiConstants.Util.getString(String.valueOf(PREFIX) + "button.nullValue", new Object[0]);
    private static final String GROUP_SELECTED = UiConstants.Util.getString(String.valueOf(PREFIX) + "groupSelected", new Object[0]);
    private static final String LABEL_NAME = UiConstants.Util.getString(String.valueOf(PREFIX) + "labelName", new Object[0]);
    private static final String LABEL_PATH = UiConstants.Util.getString(String.valueOf(PREFIX) + "labelPath", new Object[0]);
    private static final String LOADING_TABLE_MSG = UiConstants.Util.getString(String.valueOf(PREFIX) + "loadingTable", new Object[0]);
    static final Object[] LOADING_TABLE_ARRAY = new Object[]{LOADING_TABLE_MSG};
    static final Object[] NULL_VALUE = new Object[0];
    private Button btnOk;
    private Button btnNullValue;
    private CLabel nameLabel;
    private CLabel pathLabel;
    private boolean showNullValueAssigner = true;
    private boolean nullValue = false;
    private boolean virtual;
    private StructuredViewerTextFilterer filter;
    private IFilter contentFilter = PASSING_FILTER;

    public ModelObjectListDialog(Shell parent, ILabelProvider labelProvider) {
        this(parent, labelProvider, true, false);
    }

    public ModelObjectListDialog(Shell theParent, ILabelProvider theLabelProvider, boolean theShowNullValueAssignerFlag, boolean virtual) {
        super(theParent);
        this.virtual = virtual;
        TextCachingLabelProvider cached = new TextCachingLabelProvider(theLabelProvider);
        if (virtual) {
            this.setContentProvider(new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return NULL_VALUE;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
        } else {
            this.setContentProvider(new ContentProvider((ILabelProvider)cached));
        }
        this.setLabelProvider((ILabelProvider)cached);
        this.setShowNullValueAssigner(theShowNullValueAssignerFlag);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setFeatureName(String name) {
        this.setTitle(name);
        this.setMessage(UiConstants.Util.getString(MESSAGE_ID, (Object)name));
    }

    public void setShowNullValueAssigner(boolean theShowFlag) {
        this.showNullValueAssigner = theShowFlag;
    }

    public boolean isShowNullValueAssigner() {
        return this.showNullValueAssigner;
    }

    protected int getTableStyle() {
        int tableStyle = super.getTableStyle();
        if (this.virtual) {
            tableStyle |= 0x10000000;
        }
        return tableStyle;
    }

    public Object[] getResult() {
        if (this.nullValue) {
            return NULL_VALUE;
        }
        return super.getResult();
    }

    protected Label createMessageArea(Composite composite) {
        Label l = super.createMessageArea(composite);
        Control filtCtrl = this.filter.addControl(composite);
        filtCtrl.setLayoutData((Object)new GridData(4, 4, true, false));
        return l;
    }

    protected Control createDialogArea(Composite parent) {
        this.filter = new StructuredViewerTextFilterer(StructuredViewerTextFilterer.DEFAULT_PROMPT, StructuredViewerTextFilterer.DEFAULT_CLEAR);
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.isShowNullValueAssigner()) {
            this.btnNullValue = new Button(composite, 32);
            this.btnNullValue.setText(BUTTON_NULL);
            this.btnNullValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent theEvent) {
                    ModelObjectListDialog.this.handleNullValueSelected();
                }
            });
        }
        Group selectedInfoGroup = new Group(composite, 0);
        selectedInfoGroup.setText(GROUP_SELECTED);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 2;
        selectedInfoGroup.setLayout((Layout)gridLayout);
        selectedInfoGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        Label l = new Label((Composite)selectedInfoGroup, 0);
        l.setText(LABEL_NAME);
        this.nameLabel = new CLabel((Composite)selectedInfoGroup, 0);
        this.nameLabel.setLayoutData((Object)new GridData(768));
        l = new Label((Composite)selectedInfoGroup, 0);
        l.setText(LABEL_PATH);
        this.pathLabel = new CLabel((Composite)selectedInfoGroup, 0);
        this.pathLabel.setFont(composite.getFont());
        this.pathLabel.setLayoutData((Object)new GridData(768));
        List initialSelections = this.getInitialElementSelections();
        if (initialSelections != null && !initialSelections.isEmpty() && initialSelections.get(0) instanceof EObject) {
            EObject e = (EObject)initialSelections.get(0);
            this.nameLabel.setText(this.constructName(e));
            this.pathLabel.setText(this.constructPath(e));
        }
        final TableViewer tableViewer = this.getTableViewer();
        ILabelProvider labelProvider = (ILabelProvider)tableViewer.getLabelProvider();
        this.filter.setLabelProvider(labelProvider);
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.virtual) {
            Object input = tableViewer.getInput();
            Object selected = initialSelections != null && !initialSelections.isEmpty() ? initialSelections.get(0) : null;
            ContentProvider content = new ContentProvider(input, selected, labelProvider);
            tableViewer.setInput((Object)content);
            DeferredContentProvider dcp = new DeferredContentProvider((Comparator)content);
            tableViewer.setContentProvider((IContentProvider)dcp);
            this.filter.attachToVirtualViewer((StructuredViewer)tableViewer, dcp, true);
            if (selected != null) {
                final StructuredSelection ss = new StructuredSelection(selected);
                final Timer t = new Timer(true);
                TimerTask tt = new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (tableViewer.getTable().isDisposed() || !tableViewer.getSelection().isEmpty()) {
                                    t.cancel();
                                } else {
                                    tableViewer.setSelection((ISelection)ss, true);
                                }
                            }
                        });
                    }
                };
                t.schedule(tt, 500L, 500L);
            }
        } else {
            this.filter.attachToViewer((StructuredViewer)tableViewer, true);
            tableViewer.setSorter(new ViewerSorter());
        }
        return composite;
    }

    protected Button createButton(Composite theParent, int theId, String theLabel, boolean theDefaultButton) {
        Button btn = super.createButton(theParent, theId, theLabel, theDefaultButton);
        if (theId == 0) {
            this.btnOk = btn;
            this.btnOk.setEnabled(!this.getTableViewer().getSelection().isEmpty());
        }
        return btn;
    }

    void handleNullValueSelected() {
        if (this.isShowNullValueAssigner()) {
            boolean selected = this.btnNullValue.getSelection();
            this.getTableViewer().getTable().setEnabled(!selected);
            this.btnOk.setEnabled(selected);
            this.nullValue = selected;
            if (selected) {
                this.nameLabel.setText(EMPTY_STRING);
                this.pathLabel.setText(EMPTY_STRING);
            } else {
                this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.getTableViewer(), this.getTableViewer().getSelection()));
            }
        }
    }

    private String constructPath(EObject e) {
        IPath result = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(e);
        return result.toString();
    }

    private String constructName(EObject e) {
        return ModelerCore.getModelEditor().getName(e);
    }

    public IFilter getContentFilter() {
        return this.contentFilter;
    }

    public void setContentFilter(IFilter filter) {
        this.contentFilter = filter == null ? PASSING_FILTER : filter;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj = SelectionUtilities.getSelectedObject((ISelection)event.getSelection());
        if (obj instanceof EObject) {
            EObject eObj = (EObject)obj;
            this.nameLabel.setText(this.constructName(eObj));
            this.pathLabel.setText(this.constructPath(eObj));
            this.btnOk.setEnabled(true);
        } else if (obj != null) {
            this.nameLabel.setText(obj.toString());
            this.pathLabel.setText(EMPTY_STRING);
            this.btnOk.setEnabled(true);
        } else {
            this.btnOk.setEnabled(false);
        }
    }

    private class ContentProvider
    extends AbstractConcurrentModel
    implements IStructuredContentProvider,
    Comparator {
        private Map elementsCache = new HashMap();
        final Object input;
        private final ILabelProvider labelProvider;
        boolean isRunningUpdate;
        private final Object selected;

        public ContentProvider(ILabelProvider labelProvider) {
            this(null, null, labelProvider);
        }

        public ContentProvider(Object input, Object selected, ILabelProvider labelProvider) {
            this.input = input;
            this.selected = selected;
            this.labelProvider = labelProvider;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return null;
            }
            Object[] rv = (Object[])this.elementsCache.get(inputElement);
            if (rv == null) {
                Object[] inputElements = null;
                if (inputElement instanceof Object[]) {
                    inputElements = (Object[])inputElement;
                } else if (inputElement instanceof Collection) {
                    inputElements = this.processInputs((Collection)inputElement).toArray();
                } else {
                    return null;
                }
                EList resourcesInModelContainer = null;
                try {
                    resourcesInModelContainer = ModelerCore.getModelContainer().getResources();
                }
                catch (CoreException ce) {
                    ModelerCore.Util.log((Throwable)ce);
                }
                HashSet hsEmfResources = null;
                hsEmfResources = resourcesInModelContainer != null ? new HashSet(resourcesInModelContainer) : new HashSet();
                ArrayList<Object> arylResultElements = new ArrayList<Object>(inputElements.length);
                int i = 0;
                while (i < inputElements.length) {
                    Object inputObject = inputElements[i];
                    if (inputObject instanceof EObject) {
                        EObject eoTemp = (EObject)inputObject;
                        Resource res = eoTemp.eResource();
                        if (res == null && eoTemp.eIsProxy()) {
                            URI uri = ((EObjectImpl)eoTemp).eProxyURI();
                            if (this.resourceSetContains(uri, hsEmfResources)) {
                                arylResultElements.add(eoTemp);
                            }
                        } else if (res != null && res.getURI() != null && res.getURI().toString() != null && WorkspaceResourceFinderUtil.isGlobalResource((String)res.getURI().toString())) {
                            arylResultElements.add(eoTemp);
                        } else if (hsEmfResources.contains(res)) {
                            arylResultElements.add(eoTemp);
                        }
                    } else {
                        arylResultElements.add(inputObject);
                    }
                    ++i;
                }
                rv = arylResultElements.toArray();
                this.elementsCache.put(inputElement, rv);
            }
            return rv;
        }

        private Collection processInputs(Collection inputs) {
            ArrayList result = new ArrayList(inputs.size());
            IFilter filter = ModelObjectListDialog.this.getContentFilter();
            for (Object obj : inputs) {
                if (!filter.passes(obj)) continue;
                result.add(obj);
            }
            return result;
        }

        private boolean resourceSetContains(URI uri, HashSet hsResources) {
            for (Resource res : hsResources) {
                if (!res.getURI().equals(uri)) continue;
                return true;
            }
            return false;
        }

        public void requestUpdate(final IConcurrentModelListener listener) {
            if (!this.isRunningUpdate) {
                this.isRunningUpdate = true;
                listener.setContents(LOADING_TABLE_ARRAY);
                Thread runThread = new Thread("ModelObjectListDialog content update"){

                    @Override
                    public void run() {
                        Object[] elements = ContentProvider.this.getElements(ContentProvider.this.input);
                        if (!ModelObjectListDialog.this.getTableViewer().getTable().isDisposed()) {
                            listener.setContents(elements);
                        }
                        ContentProvider.this.isRunningUpdate = false;
                    }
                };
                runThread.setPriority(4);
                runThread.start();
            }
        }

        public int compare(Object o1, Object o2) {
            if (o1 == this.selected) {
                return -1;
            }
            if (o2 == this.selected) {
                return 1;
            }
            String s1 = this.labelProvider.getText(o1);
            String s2 = this.labelProvider.getText(o2);
            return s1.compareToIgnoreCase(s2);
        }
    }
}

