/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;

public class ModelProjectSelectionStatusValidator
implements ISelectionStatusValidator,
UiConstants {
    private static final IStatus OK_STATUS = new StatusInfo("org.teiid.designer.ui");
    private static final String NO_SELECTION = Util.getString("ModelProjectSelectionStatusValidator.noSelection", new Object[0]);
    private static final String NO_MULTI_SELECTION = Util.getString("ModelProjectSelectionStatusValidator.noMultiSelection", new Object[0]);
    private static final String PROJECT_CLOSED = Util.getString("ModelProjectSelectionStatusValidator.projectClosed", new Object[0]);
    private static final String NOT_MODELING_PROJECT = Util.getString("ModelProjectSelectionStatusValidator.notModelProject", new Object[0]);
    private static final String NOT_FOLDER = Util.getString("ModelProjectSelectionStatusValidator.notFolderSelection", new Object[0]);

    public IStatus validate(Object[] selection) {
        IStatus result = OK_STATUS;
        String message = null;
        if (selection == null || selection.length == 0) {
            message = NO_SELECTION;
        } else if (selection.length > 1) {
            message = NO_MULTI_SELECTION;
        } else {
            Object obj = selection[0];
            if (obj == null) {
                message = NO_SELECTION;
            } else if (obj instanceof IContainer) {
                IProject project = ((IContainer)obj).getProject();
                if (!project.isOpen()) {
                    message = PROJECT_CLOSED;
                } else {
                    try {
                        if (project.getNature("org.teiid.designer.core.modelNature") == null) {
                            message = NOT_MODELING_PROJECT;
                        }
                    }
                    catch (CoreException e) {
                        message = NOT_MODELING_PROJECT;
                        Util.log((Throwable)e);
                    }
                }
            } else {
                message = NOT_FOLDER;
            }
        }
        if (message != null) {
            result = new StatusInfo("org.teiid.designer.ui", 4, message);
        }
        return result;
    }
}

