/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelSelectorInfo;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;

public class ModelSelectorDialog
extends ModelWorkspaceDialog
implements UiConstants {
    private Label lbModelName;
    private Text txtModelName;
    private IContainer newModelParent;
    private IPath targetFilePath;
    private ModelResource modelResource;
    private SelectionAdapter checkBoxSelectionAdapter;
    private String newModelName;
    private boolean newModel = false;
    private ModelSelectorInfo newModelInfo;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelSelectorDialog.class);
    private static final String FILE_EXT = ".xmi";
    private static final int MODEL_NAME_TEXT_WIDTH = (int)((double)Display.getCurrent().getBounds().width * 0.25);
    private static final String MODEL_CREATE_ERROR_NO_NAME = ModelSelectorDialog.getString("noName.message");
    private static final String MODEL_CREATE_ERROR_IS_VALID = ModelSelectorDialog.getString("isValid.message");
    private static final String MODEL_NAME_LABEL = ModelSelectorDialog.getString("newModelName.text");

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object obj1, Object obj2) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{obj1, obj2});
    }

    public ModelSelectorDialog(Shell parent, ModelSelectorInfo modelInfo) {
        this(parent, modelInfo, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
    }

    public ModelSelectorDialog(Shell parent, ModelSelectorInfo modelInfo, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, modelInfo.getTitle(), labelProvider, contentProvider);
        this.newModelInfo = modelInfo;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createModelCreationComposite(composite);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        return composite;
    }

    private Composite createModelCreationComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout nameCompositeLayout = new GridLayout();
        nameComposite.setLayout((Layout)nameCompositeLayout);
        nameCompositeLayout.numColumns = 3;
        nameCompositeLayout.marginWidth = 0;
        GridData nameCompositeGridData = new GridData(768);
        nameCompositeGridData.horizontalIndent = 20;
        nameComposite.setLayoutData((Object)nameCompositeGridData);
        this.lbModelName = new Label(nameComposite, 0);
        this.lbModelName.setText(MODEL_NAME_LABEL);
        this.lbModelName.getAlignment();
        this.txtModelName = WidgetFactory.createTextField((Composite)nameComposite, (int)256);
        GridData modelNameTextGridData = new GridData();
        modelNameTextGridData.widthHint = MODEL_NAME_TEXT_WIDTH;
        this.txtModelName.setLayoutData((Object)modelNameTextGridData);
        this.txtModelName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ModelSelectorDialog.this.handleSetModelName();
            }
        });
        this.handleSetModelName();
        this.setCreateControlsEnabled(false);
        return nameComposite;
    }

    void createModel() {
        this.modelResource = this.constructModel((IResource)this.newModelParent, this.newModelName);
        try {
            if (this.modelResource != null) {
                this.modelResource.save(null, false);
                this.newModel = true;
            }
        }
        catch (ModelWorkspaceException mwe) {
            Util.log((Throwable)mwe);
        }
    }

    public Object[] getResult() {
        if (this.modelResource != null) {
            IFile theFile = null;
            try {
                theFile = (IFile)this.modelResource.getUnderlyingResource();
            }
            catch (ModelWorkspaceException theException) {
                ModelerCore.Util.log((Throwable)theException);
            }
            if (theFile != null) {
                return new Object[]{theFile};
            }
        }
        return super.getResult();
    }

    public boolean isNewModel() {
        return this.newModel;
    }

    private SelectionAdapter getOKSelectionListener() {
        if (this.checkBoxSelectionAdapter == null) {
            this.checkBoxSelectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Get Primary Metamodel URI", (Object)((Object)this));
                    boolean succeeded = false;
                    try {
                        ModelSelectorDialog.this.createModel();
                        succeeded = true;
                    }
                    finally {
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            };
        }
        return this.checkBoxSelectionAdapter;
    }

    private void updateDialogMessage(String sMessage, boolean bIsError) {
        int iStatusCode = 0;
        if (bIsError) {
            iStatusCode = 4;
        }
        StatusInfo status = new StatusInfo("org.teiid.designer.ui", iStatusCode, sMessage);
        this.updateStatus((IStatus)status);
    }

    void handleSetModelName() {
        String nameText = this.txtModelName.getText();
        if (this.isValidModelName(nameText)) {
            this.newModelName = nameText;
            if (this.getOkButton() != null) {
                this.getOkButton().addSelectionListener((SelectionListener)this.getOKSelectionListener());
                this.getOkButton().setEnabled(true);
            }
            String message = this.getModelNameStatus(nameText);
            this.updateDialogMessage(message, false);
        } else {
            if (this.getOkButton() != null) {
                this.getOkButton().removeSelectionListener((SelectionListener)this.getOKSelectionListener());
                this.getOkButton().setEnabled(false);
            }
            if (nameText.trim().length() == 0) {
                if (this.newModelParent != null) {
                    String msg = ModelSelectorDialog.getString("modelCreateInstruction.message", this.newModelInfo.getModelTypeDisplayName(), this.newModelParent.getName());
                    this.updateDialogMessage(msg, true);
                }
            } else {
                String message = this.getModelNameStatus(nameText);
                this.updateDialogMessage(message, true);
            }
        }
    }

    public ModelResource constructModel(IResource targetRes, String sModelName) {
        String sFileName = this.getFileName(sModelName);
        IPath relativeModelPath = targetRes.getProjectRelativePath().append(sFileName);
        IFile modelFile = targetRes.getProject().getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        try {
            resrc.getModelAnnotation().setPrimaryMetamodelUri(this.newModelInfo.getModelURI());
            resrc.getModelAnnotation().setModelType(this.newModelInfo.getModelType());
        }
        catch (ModelWorkspaceException mwe) {
            mwe.printStackTrace();
        }
        return resrc;
    }

    private boolean isValidModelName(String sModelName) {
        if (sModelName == null || sModelName.length() == 0) {
            return false;
        }
        IStatus status = ModelNameUtil.validate(sModelName, FILE_EXT, this.newModelParent, 7);
        if (status.getSeverity() == 4) {
            return false;
        }
        String sFileName = this.getFileName(sModelName);
        IPath modelFullPath = null;
        IPath modelRelativePath = null;
        if (this.newModelParent != null) {
            modelFullPath = this.newModelParent.getFullPath().append(sFileName);
            modelRelativePath = this.newModelParent.getProjectRelativePath().append(sFileName);
        }
        if (this.newModelParent != null && this.newModelParent.getProject().exists(modelRelativePath)) {
            return false;
        }
        return this.targetFilePath == null || !this.targetFilePath.equals((Object)modelFullPath);
    }

    private String getFileName(String sModelName) {
        String sResult = sModelName.trim();
        if (!sResult.endsWith(FILE_EXT)) {
            sResult = String.valueOf(sResult) + FILE_EXT;
        }
        return sResult;
    }

    private String getModelNameStatus(String sModelName) {
        if (sModelName == null || sModelName.length() == 0) {
            return MODEL_CREATE_ERROR_NO_NAME;
        }
        IStatus status = ModelNameUtil.validate(sModelName, FILE_EXT, this.newModelParent, 7);
        if (status.getSeverity() == 4) {
            return String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage();
        }
        return MODEL_CREATE_ERROR_IS_VALID;
    }

    protected void registerControls() {
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        this.newModelParent = null;
        this.setCreateControlsEnabled(false);
        IStructuredSelection sel = (IStructuredSelection)this.getTreeViewer().getSelection();
        Object oSelection = sel.getFirstElement();
        if (this.isValidModelResource(oSelection)) {
            this.newModelParent = null;
            this.setCreateControlsEnabled(false);
            String msg = ModelSelectorDialog.getString("useExistingModelInstruction.message", this.newModelInfo.getModelTypeDisplayName(), ((IResource)oSelection).getName());
            this.updateDialogMessage(msg, false);
        } else if (this.isContainer(oSelection)) {
            this.newModelParent = (IContainer)oSelection;
            this.setCreateControlsEnabled(true);
            this.handleSetModelName();
        }
    }

    private void setCreateControlsEnabled(boolean b) {
        this.txtModelName.setEnabled(b);
        this.lbModelName.setEnabled(b);
    }

    private boolean isValidModelResource(Object oSelection) {
        boolean bResult = false;
        if (oSelection instanceof IResource) {
            try {
                ModelResource mr;
                IResource resource = (IResource)oSelection;
                if (ModelUtilities.isModelFile(resource) && (mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true)).getModelType() != null && mr.getModelType().equals(this.newModelInfo.getModelType()) && mr.getPrimaryMetamodelDescriptor() != null && mr.getPrimaryMetamodelDescriptor().getNamespaceURI().equals(this.newModelInfo.getModelURI())) {
                    bResult = true;
                }
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        }
        return bResult;
    }

    private boolean isContainer(Object oSelection) {
        return oSelection instanceof IContainer;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = super.createTreeViewer(parent);
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean result = true;
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    if (!project.isOpen()) {
                        result = false;
                    } else {
                        try {
                            if (!project.hasNature("org.teiid.designer.core.modelNature")) {
                                result = false;
                            }
                        }
                        catch (CoreException theException) {
                            ModelerCore.Util.log((Throwable)theException);
                            result = false;
                        }
                    }
                }
                return result;
            }
        });
        result.expandToLevel(2);
        return result;
    }
}

