/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.search.IFinderHostDialog;
import org.teiid.designer.ui.search.IFinderPanel;
import org.teiid.designer.ui.viewsupport.EObjectSelectionValidator;

public class ModelWorkspacePanel
extends Composite
implements IFinderPanel,
ISelectionChangedListener {
    private static final String TITLE = UiConstants.Util.getString("ModelWorkspacePanel.title", new Object[0]);
    private IWorkspaceRoot root;
    private String sMessage;
    private EObject selectedEObject;
    TreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ISelectionStatusValidator fValidator = null;
    private ViewerSorter fSorter;
    private boolean fAllowMultiple = true;
    boolean fDoubleClickSelects = true;
    private String fEmptyListMessage = UiConstants.Util.getString("ElementTreeSelectionDialog.nothing_available", new Object[0]);
    IStatus fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
    private List fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private Object[] result;
    private List initialSelections = new ArrayList();
    private IFinderHostDialog fhpHostDialog;

    public ModelWorkspacePanel(Composite parent, IFinderHostDialog fhpHostDialog) {
        this(parent, fhpHostDialog, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
    }

    public ModelWorkspacePanel(Composite parent, IFinderHostDialog fhpHostDialog, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, 0);
        this.fhpHostDialog = fhpHostDialog;
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.init();
    }

    IFinderHostDialog getHost() {
        return this.fhpHostDialog;
    }

    public void init() {
        this.setValidator(new EObjectSelectionValidator());
        if (this.root != null) {
            this.setInput(this.root);
        } else {
            this.setInput(ModelerCore.getWorkspace().getRoot());
        }
        this.createControl(this);
    }

    private Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data1 = new GridData(1808);
        composite.setLayoutData((Object)data1);
        Label messageLabel = this.createMessageArea(composite);
        TreeViewer treeViewer = this.createTreeViewer(composite);
        GridData data = new GridData(1808);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayout((Layout)new GridLayout());
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        if (this.fIsEmpty) {
            messageLabel.setEnabled(false);
            treeWidget.setEnabled(false);
        }
        return composite;
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.getTreeViewer().addFilter(filter);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.selectedEObject = sel.getFirstElement() instanceof EObject ? (EObject)sel.getFirstElement() : null;
        this.getSelectedEObject();
    }

    private EObject getSelectedEObject() {
        return this.selectedEObject;
    }

    public void initializeElementTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.setResult(new ArrayList(0));
    }

    protected void setResult(List newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    public void setInitialSelection(Object selection) {
        this.setInitialSelections(new Object[]{selection});
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.initialSelections = new ArrayList(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            this.initialSelections.add(selectedElements[i]);
            ++i;
        }
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.fAllowMultiple = allowMultiple;
    }

    public void setDoubleClickSelects(boolean doubleClickSelects) {
        this.fDoubleClickSelects = doubleClickSelects;
    }

    public void setSorter(ViewerSorter sorter) {
        this.fSorter = sorter;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(filter);
    }

    @Override
    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    protected void cancelPressed() {
        this.setResult(null);
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
    }

    public void create() {
        UiBusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                ModelWorkspacePanel.this.fViewer.setSelection((ISelection)new StructuredSelection(ModelWorkspacePanel.this.getInitialElementSelections()), true);
                ModelWorkspacePanel.this.updateOKStatus();
            }
        });
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.sMessage != null) {
            label.setText(this.sMessage);
        }
        label.setFont(composite.getFont());
        return label;
    }

    @Deprecated
    protected List getInitialSelections() {
        if (this.initialSelections.isEmpty()) {
            return null;
        }
        return this.getInitialElementSelections();
    }

    protected List getInitialElementSelections() {
        return this.initialSelections;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        int style = 0x800 | (this.fAllowMultiple ? 2 : 4);
        this.fViewer = new TreeViewer(new Tree(parent, style));
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelWorkspacePanel.this.access$setResult(((IStructuredSelection)event.getSelection()).toList());
                ModelWorkspacePanel.this.updateOKStatus();
            }
        });
        this.fViewer.setSorter(this.fSorter);
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(i));
                ++i;
            }
        }
        if (this.fDoubleClickSelects) {
            Tree tree = this.fViewer.getTree();
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ModelWorkspacePanel.this.updateOKStatus();
                    if (ModelWorkspacePanel.this.fCurrStatus.isOK()) {
                        ModelWorkspacePanel.this.getHost().okPressed();
                    }
                }
            });
        }
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection;
                ModelWorkspacePanel.this.updateOKStatus();
                if (!(ModelWorkspacePanel.this.fDoubleClickSelects && ModelWorkspacePanel.this.fCurrStatus.isOK() || !((selection = event.getSelection()) instanceof IStructuredSelection))) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ModelWorkspacePanel.this.fViewer.getExpandedState(item)) {
                        ModelWorkspacePanel.this.fViewer.collapseToLevel(item, 1);
                    } else {
                        ModelWorkspacePanel.this.fViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.fViewer.setInput(this.fInput);
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        return this.fViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected void access$setResult(List result) {
        this.setResult(result);
    }

    @Override
    public void createButtonsForButtonBar(Composite parent) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    @Override
    public void handleOkPressed() {
    }

    @Override
    public void handleCancelPressed() {
    }

    @Override
    public void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.getResult());
                this.getHost().updateTheStatus(this.fCurrStatus);
            } else {
                this.fCurrStatus = new Status(0, "org.eclipse.ui", 0, "", null);
            }
        } else {
            this.fCurrStatus = new Status(4, "org.eclipse.ui", 4, this.fEmptyListMessage, null);
        }
        this.getHost().updateTheStatus(this.fCurrStatus);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public Object[] getResult() {
        return this.result;
    }
}

