/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.viewsupport.IExtendedModelObject;
import org.teiid.designer.ui.viewsupport.ImportContainer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelWorkspaceViewerFilter
extends ViewerFilter
implements UiConstants {
    private boolean showModels = false;
    private boolean showModelContent = false;
    private boolean showClosedProjects = false;
    private ViewerFilter resourceFilter;

    public ModelWorkspaceViewerFilter() {
    }

    public ModelWorkspaceViewerFilter(boolean theShowModelsFlag) {
        this.setShowModels(theShowModelsFlag);
    }

    public ModelWorkspaceViewerFilter(boolean theShowModelsFlag, boolean theShowModelContentFlag, boolean theShowClosedProjectsFlag) {
        this.setShowModels(theShowModelsFlag);
        this.setShowModelContent(theShowModelContentFlag);
        this.setShowClosedProjects(theShowClosedProjectsFlag);
    }

    public boolean isShowingModels() {
        return this.showModels;
    }

    public boolean isShowingModelContent() {
        return this.showModelContent;
    }

    public boolean isShowingClosedProjects() {
        return this.showModelContent;
    }

    private ViewerFilter getResourceFilter() {
        if (this.resourceFilter == null) {
            this.resourceFilter = UiUtil.getResourceFilter((String)"explorer.view");
        }
        return this.resourceFilter;
    }

    public boolean select(Viewer theViewer, Object theParent, Object theElement) {
        boolean result = false;
        if (theElement instanceof IContainer) {
            IFile dotProjectFile;
            IProject project = ((IContainer)theElement).getProject();
            if (project.isOpen()) {
                try {
                    if (!project.hasNature("org.teiid.designer.core.hiddenProjectNature") && project.getNature("org.teiid.designer.core.modelNature") != null) {
                        result = this.getResourceFilter().select(theViewer, theParent, theElement);
                    }
                }
                catch (CoreException theException) {
                    Util.log((Throwable)theException);
                }
            } else if (this.showClosedProjects && (dotProjectFile = DotProjectUtils.getDotProjectFile((IContainer)((IContainer)theElement))) != null) {
                try {
                    result = DotProjectUtils.isDotProject((IResource)dotProjectFile, (boolean)true);
                }
                catch (Exception e) {
                    Util.log((Throwable)e);
                }
            }
        } else if (theElement instanceof IFile) {
            result = ModelUtilities.isModelingRelatedFile((IResource)((IFile)theElement)) ? this.showModels : this.getResourceFilter().select(theViewer, theParent, theElement);
        } else if (theElement instanceof EObject || theElement instanceof ImportContainer || theElement instanceof IExtendedModelObject) {
            result = this.showModelContent;
        }
        return result;
    }

    public void setResourceFilter(ViewerFilter theResourceFilter) {
        this.resourceFilter = theResourceFilter;
    }

    public void setShowModels(boolean theShowModelsFlag) {
        this.showModels = theShowModelsFlag;
    }

    public void setShowModelContent(boolean theShowModelContentFlag) {
        this.showModelContent = theShowModelContentFlag;
    }

    public void setShowClosedProjects(boolean theShowClosedProjectsFlag) {
        this.showClosedProjects = theShowClosedProjectsFlag;
    }
}

