/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.CompositeViewerFilter;

public class ModelingResourceFilter
extends CompositeViewerFilter
implements UiConstants.Extensions.Explorer {
    private ViewerFilter hiddenProjectFilter;
    private SingleProjectFilter singleProjectFilter;

    public ModelingResourceFilter() {
        this.addFilter(UiUtil.getResourceFilter((String)"explorer.view"));
        this.setShowHiddenProjects(false);
    }

    public ModelingResourceFilter(ViewerFilter theFilter) {
        this();
        this.addFilter(theFilter);
    }

    public void setShowHiddenProjects(boolean showHiddenProjects) {
        if (showHiddenProjects) {
            if (this.hiddenProjectFilter != null) {
                this.removeFilter(this.hiddenProjectFilter);
                this.hiddenProjectFilter = null;
            }
        } else if (this.hiddenProjectFilter == null) {
            this.hiddenProjectFilter = new HiddenProjectFilter();
            this.addFilter(this.hiddenProjectFilter);
        }
    }

    public void setSingleProjectProject(IProject project) {
        if (project == null) {
            if (this.singleProjectFilter != null) {
                this.removeFilter(this.singleProjectFilter);
            }
            this.singleProjectFilter = null;
        } else if (this.singleProjectFilter == null) {
            this.singleProjectFilter = new SingleProjectFilter(project);
            this.addFilter(this.singleProjectFilter);
        } else {
            this.singleProjectFilter.setProject(project);
        }
    }

    class HiddenProjectFilter
    extends ViewerFilter {
        HiddenProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                boolean result = false;
                try {
                    result = ((IProject)element).isOpen() && !((IProject)element).hasNature("org.teiid.designer.core.hiddenProjectNature") && ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                }
                catch (CoreException e) {
                    UiConstants.Util.log((Throwable)e);
                }
                return result;
            }
            return true;
        }
    }

    class SingleProjectFilter
    extends ViewerFilter {
        IProject singleProject;

        SingleProjectFilter(IProject project) {
            this.singleProject = project;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                if (this.singleProject == null) {
                    return true;
                }
                IProject proj = (IProject)element;
                if (proj.getName().equals(this.singleProject.getName())) {
                    return true;
                }
            } else if (element instanceof IContainer) {
                if (this.singleProject == null) {
                    return true;
                }
                IProject proj = ((IContainer)element).getProject();
                if (proj.getName().equals(this.singleProject.getName())) {
                    return true;
                }
            }
            return false;
        }

        public void setProject(IProject project) {
            this.singleProject = project;
        }
    }
}

