/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ModelObjectPropertySheetPage;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PropertiesDialog
extends SelectionDialog {
    private static final String TITLE = UiConstants.Util.getString("PropertiesDialog.title", new Object[0]);
    private static final String MSG_PREFIX = String.valueOf(UiConstants.Util.getString("PropertiesDialog.message", new Object[0])) + ' ';
    private EObject propertiedObject;

    public PropertiesDialog(EObject propertiedObject, Shell parent) {
        super(parent);
        this.propertiedObject = propertiedObject;
        this.setTitle(TITLE);
        String name = ModelUtilities.getEMFItemDelegator().getText((Object)propertiedObject);
        this.setMessage(String.valueOf(MSG_PREFIX) + propertiedObject.eClass().getName() + ' ' + name);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        ModelObjectPropertySheetPage page = new ModelObjectPropertySheetPage();
        page.setPropertySourceProvider(ModelUtilities.getPropertySourceProvider());
        page.createControl(parent);
        page.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.propertiedObject));
        Control result = page.getControl();
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 600;
        result.setLayoutData((Object)gd);
        return parent;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
    }
}

