/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.ui.UiConstants;

public class RelationalObjectFactory {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RelationalObjectFactory.class);
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory factory = RelationalFactory.eINSTANCE;
    public static final int UNKNOWN = -1;
    public static final int BASE_TABLE = 10;
    public static final int VIEW = 11;
    public static final int INDEX = 12;
    public static final int COLUMN = 13;
    public static final int UNIQUE_KEY = 14;
    public static final int PRIMARY_KEY = 15;
    public static final int PROCEDURE = 16;
    public static final int PARAMETER = 17;
    public static final String BASE_TABLE_STRING = "TABLE";
    public static final String VIEW_STRING = "VIEW";
    public static final String INDEX_STRING = "INDEX";
    public static final String COLUMN_STRING = "COLUMN";
    public static final String UNIQUE_KEY_STRING = "UNIQUEKEY";
    public static final String PRIMARY_KEY_STRING = "PRIMARYKEY";
    public static final String SCHEMA_STRING = "SCHEMA";
    public static final String CATALOG_STRING = "CATALOG";
    public static final String PROCEDURE_STRING = "PROCEDURE";
    public static final String PARAMETER_STRING = "PARAMETER";
    private static final String GET_MODEL_CONTENTS_ERROR = "getModelContentsError";
    private static final String ADD_VALUE_ERROR = "addValueError";
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;
    private EObject defaultDatatype;
    private int defaultLength;
    private final ModelResource modelResource;

    private static String getString(String id, Object obj) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, obj);
    }

    private static String getString(String id, Object value, Object value2) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{value, value2});
    }

    public RelationalObjectFactory(ModelResource modelResource) {
        this.modelResource = modelResource;
    }

    public BaseTable createBaseTable(String name, String description, boolean supportsUpdate) {
        BaseTable baseTable = factory.createBaseTable();
        if (baseTable != null) {
            baseTable.setName(name);
            baseTable.setSupportsUpdate(supportsUpdate);
            this.addValue(this.modelResource, baseTable, this.getModelResourceContents(this.modelResource));
            this.addDescription((EObject)baseTable, description);
        }
        return baseTable;
    }

    public View createView(String name, String description, boolean supportsUpdate) {
        View view = factory.createView();
        if (view != null) {
            view.setName(name);
            view.setSupportsUpdate(supportsUpdate);
            this.addValue(this.modelResource, view, this.getModelResourceContents(this.modelResource));
            this.addDescription((EObject)view, description);
        }
        return view;
    }

    public Procedure createProcedure(String name, String description) {
        Procedure procedure = factory.createProcedure();
        if (procedure != null) {
            procedure.setName(name);
            this.addValue(this.modelResource, procedure, this.getModelResourceContents(this.modelResource));
            this.addDescription((EObject)procedure, description);
        }
        return procedure;
    }

    public Procedure createPushdownFunction(String name, String description) {
        Procedure procedure = this.createProcedure(name, description);
        procedure.setFunction(true);
        return procedure;
    }

    public Column createColumn(String name, String description, EObject viewOrBaseTable, boolean useDefaultDatatype, EObject datatype, int length) {
        Column column = factory.createColumn();
        if (column != null) {
            column.setName(name);
            if (datatype != null) {
                column.setType(datatype);
            } else if (useDefaultDatatype && this.defaultDatatype != null) {
                column.setType(this.defaultDatatype);
            }
            if (length > 0) {
                column.setLength(length);
            } else if (useDefaultDatatype) {
                column.setLength(this.defaultLength);
            }
            if (viewOrBaseTable instanceof BaseTable) {
                this.addValue(viewOrBaseTable, column, ((BaseTable)viewOrBaseTable).getColumns());
            } else if (viewOrBaseTable instanceof View) {
                this.addValue(viewOrBaseTable, column, ((View)viewOrBaseTable).getColumns());
            }
            this.addDescription((EObject)column, description);
        }
        return column;
    }

    public ProcedureParameter createParameter(String name, String description, boolean isOutput, Procedure procedure, boolean useDefaultDatatype, EObject datatype, int length) {
        ProcedureParameter param = factory.createProcedureParameter();
        if (param != null) {
            param.setName(name);
            if (datatype != null) {
                param.setType(datatype);
            } else if (useDefaultDatatype && this.defaultDatatype != null) {
                param.setType(this.defaultDatatype);
            }
            if (length > 0) {
                param.setLength(length);
            } else if (useDefaultDatatype) {
                param.setLength(this.defaultLength);
            }
            if (isOutput) {
                param.setDirection(DirectionKind.RETURN_LITERAL);
            } else {
                param.setDirection(DirectionKind.IN_LITERAL);
            }
            this.addValue(procedure, param, procedure.getParameters());
            this.addDescription((EObject)param, description);
        }
        return param;
    }

    private void addDescription(EObject eObject, String description) {
        if (this.modelResource != null && description != null && description.length() > 0) {
            ModelContents contents = ModelerCore.getModelEditor().getModelContents(this.modelResource);
            Annotation newAnnot = ModelResourceContainerFactory.createNewAnnotation((EObject)eObject, (AnnotationContainer)contents.getAnnotationContainer(true));
            newAnnot.setDescription(description);
        }
    }

    public EList getModelResourceContents(ModelResource resource) {
        EList eList = null;
        try {
            eList = resource.getEmfResource().getContents();
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log(4, (Throwable)e, RelationalObjectFactory.getString(GET_MODEL_CONTENTS_ERROR, resource));
        }
        return eList;
    }

    public void addValue(Object owner, Object value, EList feature) {
        try {
            if (isTransactionable) {
                ModelerCore.getModelEditor().addValue(owner, value, feature);
            } else {
                feature.add(value);
            }
        }
        catch (ModelerCoreException err) {
            UiConstants.Util.log(4, (Throwable)err, RelationalObjectFactory.getString(ADD_VALUE_ERROR, value, owner));
        }
    }
}

