/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.CompositeViewerFilter;

public class SingleProjectOrFolderFilter
extends CompositeViewerFilter
implements UiConstants.Extensions.Explorer {
    private ViewerFilter hiddenProjectFilter;
    private IProject targetProject;

    private SingleProjectOrFolderFilter() {
        this.addFilter(UiUtil.getResourceFilter((String)"explorer.view"));
        this.setShowHiddenProjects(false);
    }

    public SingleProjectOrFolderFilter(IProject targetProject) {
        this();
        this.targetProject = targetProject;
        this.addFilter(new OneProjectFilter());
    }

    public void setShowHiddenProjects(boolean showHiddenProjects) {
        if (showHiddenProjects) {
            if (this.hiddenProjectFilter != null) {
                this.removeFilter(this.hiddenProjectFilter);
                this.hiddenProjectFilter = null;
            }
        } else if (this.hiddenProjectFilter == null) {
            this.hiddenProjectFilter = new HiddenProjectFilter();
            this.addFilter(this.hiddenProjectFilter);
        }
    }

    class HiddenProjectFilter
    extends ViewerFilter {
        HiddenProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                boolean result = false;
                IProject project = (IProject)element;
                try {
                    result = project.isOpen() && !project.hasNature("org.teiid.designer.core.hiddenProjectNature") && project.hasNature("org.teiid.designer.core.modelNature");
                }
                catch (CoreException e) {
                    UiConstants.Util.log((Throwable)e);
                }
                return result;
            }
            return true;
        }
    }

    class OneProjectFilter
    extends ViewerFilter {
        OneProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                boolean result = false;
                IProject project = (IProject)element;
                try {
                    result = project.isOpen() && !project.hasNature("org.teiid.designer.core.hiddenProjectNature") && project.hasNature("org.teiid.designer.core.modelNature") && SingleProjectOrFolderFilter.this.targetProject.getName().equals(project.getName());
                }
                catch (CoreException e) {
                    UiConstants.Util.log((Throwable)e);
                }
                return result;
            }
            return true;
        }
    }
}

