/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDParticle;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.IExtendedModelObject;
import org.teiid.designer.ui.viewsupport.ImportContainer;

public class StatusBarUpdater
implements ISelectionChangedListener,
UiConstants {
    private IStatusLineManager statusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.statusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        String statusBarMessage = this.formatMessage(selection);
        this.statusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return Util.getString("StatusBarUpdater.num_elements_selected", (Object)String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof EObject) {
                return StatusBarUpdater.formatEObjectMessage((EObject)elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
            if (elem instanceof ImportContainer) {
                return ((ImportContainer)elem).toString();
            }
            if (elem instanceof IExtendedModelObject) {
                return ((IExtendedModelObject)elem).getStatusLabel();
            }
            return elem.getClass().getName();
        }
        return "";
    }

    public static String formatEObjectMessage(EObject element) {
        String result;
        if (element instanceof ENamedElement) {
            result = element.eClass().getName();
            result = String.valueOf(result) + ": " + ((ENamedElement)element).getName();
        } else {
            result = element instanceof XSDParticle ? ((XSDParticle)element).getTerm().eClass().getName() : (element instanceof XSDAttributeUse ? ((XSDAttributeUse)element).getAttributeDeclaration().eClass().getName() : element.eClass().getName());
            result = String.valueOf(result) + ": ";
            result = String.valueOf(result) + ModelerCore.getModelEditor().getModelRelativePathIncludingModel(element);
        }
        return result;
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            try {
                return ModelUtil.getLocation((IResource)element).toString();
            }
            catch (CoreException ex) {
                UiConstants.Util.log((Throwable)ex);
                return ex.getLocalizedMessage();
            }
        }
        return String.valueOf(element.getName()) + Util.getString("StatusBarUpdater._class____4", new Object[0]) + element.getClass().getName();
    }
}

