/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TextCachingLabelProvider
extends LabelProvider {
    private int cacheHits;
    private int cacheMisses;
    private final ILabelProvider realProvider;
    private final Map cache = new HashMap();

    public TextCachingLabelProvider(ILabelProvider provider) {
        this.realProvider = provider;
    }

    public String getText(Object element) {
        String value = (String)this.cache.get(element);
        if (value == null) {
            ++this.cacheMisses;
            value = this.realProvider.getText(element);
            this.cache.put(element, value);
        } else {
            ++this.cacheHits;
        }
        return value;
    }

    public Image getImage(Object element) {
        return this.realProvider.getImage(element);
    }

    public void printStats() {
        System.out.println("Cache size: " + this.cache.size() + "; hits: " + this.cacheHits + "; misses: " + this.cacheMisses);
    }
}

