/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.ui.common.table.PropertyEditingSupport;

public class TranslatorOverridePropertyEditingSupport
extends PropertyEditingSupport {
    public TranslatorOverridePropertyEditingSupport(ColumnViewer viewer, IResource vdb) {
        super(viewer, vdb);
    }

    protected String getElementValue(Object element) {
        TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
        String overrideValue = property.getOverriddenValue();
        if (StringUtilities.isEmpty((String)overrideValue)) {
            return property.getDefinition().getDefaultValue();
        }
        return overrideValue;
    }

    protected PropertyDefinition getPropertyDefinition(Object element) {
        TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
        return property.getDefinition();
    }

    protected void setElementValue(Object element, String newValue) {
        TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
        String currentValue = property.getOverriddenValue();
        boolean doIt = false;
        if (StringUtilities.isEmpty((String)newValue)) {
            if (!StringUtilities.isEmpty((String)currentValue)) {
                doIt = true;
            }
        } else {
            String defaultValue = property.getDefinition().getDefaultValue();
            if (StringUtilities.isEmpty((String)currentValue)) {
                if (StringUtilities.isEmpty((String)defaultValue) || !defaultValue.equals(newValue)) {
                    doIt = true;
                }
            } else if (!newValue.equals(currentValue)) {
                doIt = true;
                if (!StringUtilities.isEmpty((String)defaultValue) && defaultValue.equals(newValue)) {
                    newValue = null;
                }
            }
        }
        if (doIt) {
            property.setValue(newValue);
            this.getViewer().setSelection((ISelection)new StructuredSelection(element));
        }
    }
}

