/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.product.IProductCharacteristics;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.wizards.INewModelWizardContributor;

public abstract class AbstractNewModelContributorWizard
extends AbstractWizard
implements UiConstants {
    private IFile file;
    private IWizardPage hiddenProjectPage;
    private ModelResource model;
    private AbstractUiPlugin plugin;
    protected ISelection selection;
    private IContainer modelContainer;

    public AbstractNewModelContributorWizard(AbstractUiPlugin thePlugin, String theTitle, ImageDescriptor theImage, ModelResource theNewModel) {
        super((AbstractUIPlugin)thePlugin, theTitle, theImage);
        this.model = theNewModel;
        this.file = (IFile)this.model.getResource();
        this.modelContainer = this.file.getParent();
    }

    public AbstractNewModelContributorWizard(AbstractUiPlugin thePlugin, String theTitle, ImageDescriptor theImage, ModelResource theNewModel, ISelection theSelection) {
        this(thePlugin, theTitle, theImage, theNewModel);
        this.selection = theSelection;
    }

    public void addPages() {
        IProductCharacteristics characteristics = ProductCustomizerMgr.getInstance().getProductCharacteristics();
        if (characteristics.isHiddenProjectCentric() && characteristics.getHiddenProject(false) == null) {
            this.hiddenProjectPage = characteristics.getCreateHiddenProjectWizardPage();
            if (this.hiddenProjectPage != null) {
                this.addPage(this.hiddenProjectPage);
            }
        }
        this.getContributor().createWizardPages(this.getSelection(), (IResource)this.getModelContainer(), this.getModelPath(), this.getMetamodelDescriptor(), this.isVirtual());
        IWizardPage[] pages = this.getContributor().getWizardPages();
        int i = 0;
        while (i < pages.length) {
            this.addPage(pages[i]);
            ++i;
        }
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (this.hiddenProjectPage == null || this.hiddenProjectPage != null && this.hiddenProjectPage != currentPage) {
            result = this.getContributor().canFinishEarly(currentPage);
        }
        return result;
    }

    public void createPageControls(Composite thePageContainer) {
        super.createPageControls(thePageContainer, false);
    }

    protected void doFinish(final ModelResource modelResource, final IProgressMonitor theMonitor) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractNewModelContributorWizard.this.getContributor().doFinish(modelResource, theMonitor);
            }
        });
    }

    public final boolean finish() {
        boolean success;
        block14: {
            final ModelResource modelResource = this.model;
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor theMonitor) throws InvocationTargetException {
                    try {
                        try {
                            AbstractNewModelContributorWizard.this.doFinish(modelResource, theMonitor);
                        }
                        catch (Exception theException) {
                            throw new InvocationTargetException(theException);
                        }
                    }
                    finally {
                        theMonitor.done();
                    }
                }
            };
            boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.getWindowTitle(), (Object)this);
            success = true;
            try {
                try {
                    this.getContainer().run(false, true, (IRunnableWithProgress)op);
                }
                catch (InterruptedException interruptedException) {
                    success = false;
                    if (startedTxn) {
                        if (success) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                catch (InvocationTargetException theException) {
                    block15: {
                        String PREFIX = I18nUtil.getPropertyPrefix(AbstractNewModelContributorWizard.class);
                        success = false;
                        String msg = theException.getTargetException().getLocalizedMessage();
                        if (CoreStringUtil.isEmpty((String)msg)) {
                            msg = Util.getString(String.valueOf(PREFIX) + "noDetailsMsg", new Object[0]);
                        }
                        MessageDialog.openError((Shell)this.getShell(), (String)Util.getString(String.valueOf(PREFIX) + "problemDialog.title", new Object[0]), (String)msg);
                        if (!startedTxn) break block14;
                        if (!success) break block15;
                        ModelerCore.commitTxn();
                        break block14;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (startedTxn) {
                    if (success) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return success;
    }

    protected abstract INewModelWizardContributor getContributor();

    protected IFile getFile() {
        return this.file;
    }

    protected abstract MetamodelDescriptor getMetamodelDescriptor();

    protected IContainer getModelContainer() {
        return this.modelContainer;
    }

    protected String getModelShortName() {
        return this.file.getProjectRelativePath().removeFileExtension().lastSegment();
    }

    protected IPath getModelPath() {
        return this.model.getPath();
    }

    public ModelResource getModelResource() {
        return this.model;
    }

    public IWizardPage getNextPage(IWizardPage thePage) {
        this.getContributor().currentPageChanged(thePage);
        return super.getNextPage(thePage);
    }

    protected AbstractUiPlugin getPlugin() {
        return this.plugin;
    }

    protected ISelection getSelection() {
        if (this.selection == null) {
            this.selection = StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    protected abstract boolean isVirtual();

    public boolean performCancel() {
        this.getContributor().doCancel();
        return super.performCancel();
    }
}

