/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.tree.TreeViewerUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.ClosedProjectFilter;
import org.teiid.designer.ui.common.viewsupport.DotProjectFilter;
import org.teiid.designer.ui.common.widget.INodeDescendantsDeselectionHandler;
import org.teiid.designer.ui.common.widget.InheritanceCheckboxTreeViewer;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceTreeProvider;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.wizards.ICheckboxTreeViewerListenerController;
import org.teiid.designer.ui.wizards.IStructuralCopyTreePopulator;
import org.teiid.designer.ui.wizards.StructuralCopyModelFeaturePopulator;

public class CheckboxTreeViewerWizardPanel
extends Composite
implements UiConstants,
ICheckboxTreeViewerListenerController {
    private static final String BROWSE_SHORTHAND = "...";
    private static final int FILE_NAME_TEXT_WIDTH = (int)((double)Display.getCurrent().getBounds().width * 0.25);
    private static final String SELECT_MODEL_TITLE = Util.getString("StructuralCopyWizardPage.selectModelTitle", new Object[0]);
    private static final String SELECT_MODEL_MSG = Util.getString("StructuralCopyWizardPage.selectModelMsg", new Object[0]);
    private static final String CHECK_ALL = Util.getString("StructuralCopyWizardPage.checkAll", new Object[0]);
    private static final String UNCHECK_ALL = Util.getString("StructuralCopyWizardPage.uncheckAll", new Object[0]);
    private static final String COPY_ALL_DESCRIPTIONS = Util.getString("StructuralCopyWizardPage.copyAllDescriptions", new Object[0]);
    private WizardPage wizardPage;
    private INodeDescendantsDeselectionHandler deselectionHandler;
    private Text fileNameText;
    private Button browseButton;
    private Button checkAllButton;
    private Button uncheckAllButton;
    private Button copyAllDescriptions;
    private IStructuralCopyTreePopulator populator = null;
    private Tree tree;
    InheritanceCheckboxTreeViewer treeViewer;
    private MetamodelDescriptor metamodelDescriptor;
    private ModelResource selectorDialogResult = null;
    boolean listenForCheckboxChanges = true;
    protected boolean targetIsVirtual;
    private boolean firstTimeVisible = true;
    private boolean copyEntire;

    public CheckboxTreeViewerWizardPanel(Composite parent, WizardPage wizardPage, INodeDescendantsDeselectionHandler deselectionHandler, MetamodelDescriptor metamodelDescriptor, ModelResource selection, boolean targetIsVirtual) {
        super(parent, 0);
        this.wizardPage = wizardPage;
        this.deselectionHandler = deselectionHandler;
        this.metamodelDescriptor = metamodelDescriptor;
        this.selectorDialogResult = selection;
        this.targetIsVirtual = targetIsVirtual;
        this.initialize();
    }

    public InheritanceCheckboxTreeViewer getViewer() {
        return this.treeViewer;
    }

    public IStructuralCopyTreePopulator getTreePopulator() {
        return this.populator;
    }

    @Override
    public void enableCheckboxChangeListener(boolean flag) {
        this.listenForCheckboxChanges = flag;
    }

    @Override
    public void checkboxStateChanged() {
        this.checkedItemsChanged();
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        Composite fileComposite = new Composite((Composite)this, 0);
        GridLayout fileCompositeLayout = new GridLayout();
        fileComposite.setLayout((Layout)fileCompositeLayout);
        fileCompositeLayout.numColumns = 3;
        fileCompositeLayout.marginWidth = 0;
        GridData fileCompositeGridData = new GridData(768);
        fileComposite.setLayoutData((Object)fileCompositeGridData);
        Label schemaNameLabel = new Label(fileComposite, 0);
        schemaNameLabel.setText(Util.getString("StructuralCopyWizardPage.existingModelLabel", new Object[0]));
        this.fileNameText = WidgetFactory.createTextField((Composite)fileComposite, (int)256);
        this.fileNameText.setEditable(false);
        GridData fileNameTextGridData = new GridData();
        fileNameTextGridData.widthHint = FILE_NAME_TEXT_WIDTH;
        this.fileNameText.setLayoutData((Object)fileNameTextGridData);
        this.browseButton = new Button(fileComposite, 8);
        this.browseButton.setText(BROWSE_SHORTHAND);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                CheckboxTreeViewerWizardPanel.this.browseButtonClicked();
            }
        });
        Group treeGroup = new Group((Composite)this, 0);
        GridLayout treeGroupLayout = new GridLayout();
        treeGroup.setLayout((Layout)treeGroupLayout);
        GridData treeGroupGridData = new GridData(1808);
        treeGroup.setLayoutData((Object)treeGroupGridData);
        Button copyEntire = new Button((Composite)treeGroup, 16);
        copyEntire.setLayoutData((Object)new GridData(4, 4, true, false));
        copyEntire.setText(Util.getString("StructuralCopyWizardPage.copyEntireLabel", new Object[0]));
        final Button selectFeatures = new Button((Composite)treeGroup, 16);
        selectFeatures.setLayoutData((Object)new GridData(4, 4, true, false));
        selectFeatures.setText(Util.getString("StructuralCopyWizardPage.selectFeaturesLabel", new Object[0]));
        this.tree = new Tree((Composite)treeGroup, 2848);
        GridData treeGridData = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)treeGridData);
        this.treeViewer = new InheritanceCheckboxTreeViewer(this.tree, 4, this.deselectionHandler);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (CheckboxTreeViewerWizardPanel.this.listenForCheckboxChanges) {
                    CheckboxTreeViewerWizardPanel.this.checkedItemsChanged();
                }
            }
        });
        Composite buttonComposite = new Composite((Composite)treeGroup, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonComposite.setLayout((Layout)buttonLayout);
        buttonLayout.numColumns = 2;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        this.checkAllButton = new Button(buttonComposite, 8);
        this.checkAllButton.setText(CHECK_ALL);
        this.checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                CheckboxTreeViewerWizardPanel.this.treeViewer.setListenerEnabled(false);
                TreeViewerUtil.setAllChecked((CheckboxTreeViewer)CheckboxTreeViewerWizardPanel.this.treeViewer, (boolean)true);
                CheckboxTreeViewerWizardPanel.this.treeViewer.setListenerEnabled(true);
                CheckboxTreeViewerWizardPanel.this.checkboxStateChanged();
            }
        });
        GridData buttonGridData = new GridData(64);
        this.checkAllButton.setLayoutData((Object)buttonGridData);
        this.uncheckAllButton = new Button(buttonComposite, 8);
        this.uncheckAllButton.setText(UNCHECK_ALL);
        this.uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                CheckboxTreeViewerWizardPanel.this.treeViewer.setListenerEnabled(false);
                TreeViewerUtil.setAllChecked((CheckboxTreeViewer)CheckboxTreeViewerWizardPanel.this.treeViewer, (boolean)false);
                CheckboxTreeViewerWizardPanel.this.treeViewer.setListenerEnabled(true);
                CheckboxTreeViewerWizardPanel.this.checkboxStateChanged();
            }
        });
        buttonGridData = new GridData(64);
        this.uncheckAllButton.setLayoutData((Object)buttonGridData);
        SelectionListener sl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean copyEntire = !selectFeatures.getSelection();
                CheckboxTreeViewerWizardPanel.this.setCopyEntireModel(copyEntire);
            }
        };
        selectFeatures.addSelectionListener(sl);
        copyEntire.setSelection(true);
        this.setCopyEntireModel(true);
        this.addOptions(this);
    }

    protected void addOptions(Composite parent) {
        this.copyAllDescriptions = new Button((Composite)this, 32);
        this.copyAllDescriptions.setSelection(true);
        this.copyAllDescriptions.setLayoutData((Object)new GridData(4, 4, false, false));
        this.copyAllDescriptions.setText(COPY_ALL_DESCRIPTIONS);
    }

    public boolean isCopyEntireModel() {
        return this.copyEntire;
    }

    public boolean isCopyAllDescriptions() {
        return this.copyAllDescriptions.getSelection();
    }

    public void setVisible(boolean theVisible) {
        super.setVisible(theVisible);
        if (theVisible && this.firstTimeVisible && this.selectorDialogResult != null) {
            this.firstTimeVisible = false;
            IFile file = (IFile)this.selectorDialogResult.getResource();
            this.fileNameText.setText(file.getProjectRelativePath().toString());
            this.populator = this.getFeaturePopulator(file);
            this.populator.populateModelFeaturesTree((TreeViewer)this.treeViewer, this.selectorDialogResult, this.targetIsVirtual);
        }
    }

    void browseButtonClicked() {
        IStructuralCopyTreePopulator thePopulator = this.displaySelectorDialog();
        if (thePopulator != null) {
            this.populator = thePopulator;
            this.populator.populateModelFeaturesTree((TreeViewer)this.treeViewer, this.selectorDialogResult, this.targetIsVirtual);
            this.setCopyEntireModel(this.isCopyEntireModel());
        }
    }

    private IStructuralCopyTreePopulator displaySelectorDialog() {
        Object[] selection;
        StructuralCopyModelFeaturePopulator result = null;
        this.selectorDialogResult = null;
        ModelWorkspaceTreeProvider provider = new ModelWorkspaceTreeProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)provider, (ITreeContentProvider)provider);
        dialog.setInput((Object)ModelerCore.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.addFilter((ViewerFilter)new ClosedProjectFilter());
        dialog.addFilter((ViewerFilter)new DotProjectFilter());
        dialog.addFilter((ViewerFilter)new ModelingResourceFilter());
        dialog.setValidator((ISelectionStatusValidator)new ModelResourceSelectionValidator(this.metamodelDescriptor, false));
        dialog.setTitle(SELECT_MODEL_TITLE);
        dialog.setMessage(SELECT_MODEL_MSG);
        if (dialog.open() == 0 && (selection = dialog.getResult()).length == 1 && selection[0] instanceof IFile) {
            IFile sourceFile = (IFile)selection[0];
            result = this.getFeaturePopulator(sourceFile);
            this.selectorDialogResult = null;
            this.fileNameText.setText("");
            boolean exceptionOccurred = false;
            try {
                this.selectorDialogResult = ModelUtil.getModelResource((IFile)sourceFile, (boolean)true);
            }
            catch (Exception ex) {
                Util.log((Throwable)ex);
                exceptionOccurred = true;
            }
            if (!exceptionOccurred) {
                this.fileNameText.setText(sourceFile.getName());
            }
        }
        return result;
    }

    protected StructuralCopyModelFeaturePopulator getFeaturePopulator(IFile sourceFile) {
        return new StructuralCopyModelFeaturePopulator(sourceFile, this);
    }

    void checkedItemsChanged() {
        int numItemsChecked = this.treeViewer.getCheckedElements().length;
        boolean complete = numItemsChecked > 0;
        this.wizardPage.setPageComplete(complete);
        if (complete) {
            this.wizardPage.setErrorMessage(null);
        } else if (TreeViewerUtil.getRootNodes((TreeViewer)this.treeViewer).size() > 0) {
            String msg = Util.getString("StructuralCopyWizardPage.needCheckedItem", new Object[0]);
            this.wizardPage.setErrorMessage(msg);
        }
    }

    void setCopyEntireModel(boolean copyEntireModel) {
        this.copyEntire = copyEntireModel;
        this.tree.setEnabled(!copyEntireModel);
        this.checkAllButton.setEnabled(!copyEntireModel);
        this.uncheckAllButton.setEnabled(!copyEntireModel);
        if (copyEntireModel && this.selectorDialogResult != null) {
            this.wizardPage.setPageComplete(true);
            this.wizardPage.setErrorMessage(null);
        } else {
            this.checkedItemsChanged();
        }
    }
}

