/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.accumulator.AccumulatorPanel;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatedValuesChangeListener;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ConvertEnterpriseTypesPage
extends WizardPage
implements InternalUiConstants.Widgets,
UiConstants,
IAccumulatedValuesChangeListener {
    private final DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
    private final String leftHeader = Util.getString("ConvertEnterpriseTypesPage.leftHeader", new Object[0]);
    private final String rightHeader = Util.getString("ConvertEnterpriseTypesPage.rightHeader", new Object[0]);
    private final Collection nonEnterpriseTypes = new HashSet();
    private final ILabelProvider accumulatorLabelProvider = ModelUtilities.getEMFLabelProvider();
    private TableViewer typeViewer;
    private AccumulatorPanel panel;
    private Collection typesToConvert;

    public ConvertEnterpriseTypesPage(Resource rsrc) {
        super("typesPage");
        this.setTitle(Util.getString("ConvertEnterpriseTypesPage.title", new Object[0]));
        this.setDescription(Util.getString("ConvertEnterpriseTypesPage.desc", new Object[0]));
        this.initialize(rsrc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Composite topComposite = new Composite(container, 0);
        GridData topCompositeGridData = new GridData(1040);
        topComposite.setLayoutData((Object)topCompositeGridData);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topComposite.setLayout((Layout)topLayout);
        EnterpriseTypeAccumulatorSource source = new EnterpriseTypeAccumulatorSource(this, topComposite);
        this.panel = new AccumulatorPanel(topComposite, (IAccumulatorSource)source, new ArrayList(), this.accumulatorLabelProvider, this.leftHeader, this.rightHeader);
        this.panel.addAccumulatedValuesChangeListener((IAccumulatedValuesChangeListener)this);
        this.setControl((Control)container);
        this.typeViewer.add(this.nonEnterpriseTypes.toArray());
        this.checkStatus();
    }

    public void accumulatedValuesChanged(AccumulatorPanel source) {
        this.typesToConvert = source.getItemsMovedToSelected();
        this.checkStatus();
    }

    public Collection getTypesToConvert() {
        if (this.typesToConvert == null) {
            return Collections.EMPTY_LIST;
        }
        return this.typesToConvert;
    }

    private void initialize(Resource rsrc) {
        if (rsrc != null) {
            this.addNonEnterpriseTypes(rsrc);
        }
    }

    private void addNonEnterpriseTypes(Resource xsdRsrc) {
        for (Object next : xsdRsrc.getContents()) {
            if (!(next instanceof XSDSchema)) continue;
            for (Object child : ((XSDSchema)next).eContents()) {
                if (!(child instanceof XSDSimpleTypeDefinition) || this.dtMgr.isEnterpriseDatatype((EObject)child)) continue;
                this.nonEnterpriseTypes.add(child);
            }
        }
    }

    private void checkStatus() {
        if (this.nonEnterpriseTypes == null || this.nonEnterpriseTypes.isEmpty()) {
            this.setMessage(Util.getString("ConvertEnterpriseTypesPage.none", new Object[0]), 3);
            this.setPageComplete(false);
            return;
        }
        if (this.typesToConvert == null || this.typesToConvert.isEmpty()) {
            this.setMessage(Util.getString("ConvertEnterpriseTypesPage.noneSelected", new Object[0]), 3);
            this.setPageComplete(false);
            return;
        }
        this.setMessage(Util.getString("ConvertEnterpriseTypesPage.done", new Object[0]), 0);
        this.setPageComplete(true);
    }

    void typesToConvertChanged() {
    }

    void typesToConvertRemoved(Collection values) {
        for (Object value : values) {
            this.typeViewer.add(value);
        }
    }

    void typesToConvertAdded(Collection values) {
        for (Object value : values) {
            this.typeViewer.remove(value);
        }
    }

    Collection getAvailableTypes() {
        int count = this.typeViewer.getTable().getItemCount();
        ArrayList<Object> values = new ArrayList<Object>(count);
        int i = 0;
        while (i < count) {
            Object value = this.typeViewer.getElementAt(i);
            values.add(value);
            ++i;
        }
        return values;
    }

    int getAvailableTypesCount() {
        return this.typeViewer.getTable().getItemCount();
    }

    Collection getSelectedAvailableTypes() {
        int[] selectionIndices = this.typeViewer.getTable().getSelectionIndices();
        ArrayList<Object> selectedValues = new ArrayList<Object>(selectionIndices.length);
        int i = 0;
        while (i < selectionIndices.length) {
            int index = selectionIndices[i];
            selectedValues.add(this.typeViewer.getElementAt(index));
            ++i;
        }
        return selectedValues;
    }

    int getSelectedAvailableTypeCount() {
        if (this.typeViewer != null) {
            return this.typeViewer.getTable().getSelectionCount();
        }
        return 0;
    }

    Control createTypeControl(Composite parent) {
        this.typeViewer = new TableViewer(parent, 2);
        this.typeViewer.setLabelProvider((IBaseLabelProvider)this.accumulatorLabelProvider);
        return this.typeViewer.getControl();
    }

    void addTypeSelectionListener(SelectionListener listener) {
        this.typeViewer.getTable().addSelectionListener(listener);
    }

    class EnterpriseTypeAccumulatorSource
    implements IAccumulatorSource {
        private final IStatus OK_STATUS = new StatusInfo("org.teiid.designer.ui");
        private final ConvertEnterpriseTypesPage caller;
        TableViewer viewer;

        public EnterpriseTypeAccumulatorSource(ConvertEnterpriseTypesPage cllr, Composite parent) {
            this.caller = cllr;
        }

        public void accumulatedValuesRemoved(Collection values) {
            this.caller.typesToConvertRemoved(values);
            this.caller.typesToConvertChanged();
        }

        public void accumulatedValuesAdded(Collection values) {
            this.caller.typesToConvertAdded(values);
            this.caller.typesToConvertChanged();
        }

        public Collection getAvailableValues() {
            return this.caller.getAvailableTypes();
        }

        public int getAvailableValuesCount() {
            return this.caller.getAvailableTypesCount();
        }

        public Collection getSelectedAvailableValues() {
            return this.caller.getSelectedAvailableTypes();
        }

        public int getSelectedAvailableValuesCount() {
            return this.caller.getSelectedAvailableTypeCount();
        }

        public Control createControl(Composite parent) {
            return this.caller.createTypeControl(parent);
        }

        public void addSelectionListener(SelectionListener listener) {
            this.caller.addTypeSelectionListener(listener);
        }

        public boolean supportsAddAll() {
            return true;
        }

        public IStatus getSelectionStatus() {
            return this.OK_STATUS;
        }
    }
}

